/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager {
    private final JavaPlugin plugin;
    private final Logger logger;
    private String databaseType;
    private Connection sqliteConnection;
    private HikariDataSource dataSource;

    public DatabaseManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.initializeDatabase();
    }

    private void initializeDatabase() {
        FileConfiguration config = this.plugin.getConfig();
        this.databaseType = config.getString("database.type", "sqlite").toLowerCase();
        try {
            if (this.databaseType.equals("mysql")) {
                this.initializeMySQL();
            } else {
                this.initializeSQLite();
            }
            this.createTables();
        }
        catch (Exception e) {
            this.logger.severe("Failed to initialize database: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Database initialization failed", e);
        }
    }

    private void initializeSQLite() {
        try {
            Class.forName("org.sqlite.JDBC");
            this.sqliteConnection = DriverManager.getConnection("jdbc:sqlite:plugins/OllamaChat/chat_history.db");
            this.sqliteConnection.setAutoCommit(true);
            this.databaseType = "sqlite";
            this.logger.info("SQLite database initialized successfully.");
        }
        catch (ClassNotFoundException | SQLException e) {
            this.logger.severe("Failed to initialize SQLite database: " + e.getMessage());
            throw new RuntimeException("SQLite initialization failed", e);
        }
    }

    private void initializeMySQL() {
        try {
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
            }
            catch (ClassNotFoundException e) {
                this.logger.severe("MySQL JDBC driver not found! Falling back to SQLite.");
                this.initializeSQLite();
                return;
            }
            FileConfiguration config = this.plugin.getConfig();
            String host = config.getString("database.mysql.host", "localhost");
            int port = config.getInt("database.mysql.port", 3306);
            String database = config.getString("database.mysql.database", "ollamachat");
            String username = config.getString("database.mysql.username", "root");
            String password = config.getString("database.mysql.password", "");
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setJdbcUrl(String.format("jdbc:mysql://%s:%d/%s?useSSL=false&allowPublicKeyRetrieval=true&autoReconnect=true", host, port, database));
            hikariConfig.setUsername(username);
            hikariConfig.setPassword(password);
            hikariConfig.setMaximumPoolSize(config.getInt("database.mysql.hikari.maximum-pool-size", 10));
            hikariConfig.setMinimumIdle(config.getInt("database.mysql.hikari.minimum-idle", 2));
            hikariConfig.setConnectionTimeout(config.getLong("database.mysql.hikari.connection-timeout", 30000L));
            hikariConfig.setIdleTimeout(config.getLong("database.mysql.hikari.idle-timeout", 600000L));
            hikariConfig.setMaxLifetime(config.getLong("database.mysql.hikari.max-lifetime", 1800000L));
            hikariConfig.addDataSourceProperty("cachePrepStmts", (Object)config.getString("database.mysql.hikari.cache-prep-stmts", "true"));
            hikariConfig.addDataSourceProperty("prepStmtCacheSize", (Object)config.getString("database.mysql.hikari.prep-stmt-cache-size", "250"));
            hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)config.getString("database.mysql.hikari.prep-stmt-cache-sql-limit", "2048"));
            this.dataSource = new HikariDataSource(hikariConfig);
            this.logger.info("MySQL database initialized successfully using HikariCP.");
        }
        catch (Exception e) {
            this.logger.severe("Failed to initialize MySQL database: " + e.getMessage());
            this.logger.warning("Falling back to SQLite due to MySQL initialization failure.");
            this.initializeSQLite();
        }
    }

    private Connection getConnection() throws SQLException {
        if ("sqlite".equals(this.databaseType)) {
            if (this.sqliteConnection == null || this.sqliteConnection.isClosed()) {
                this.sqliteConnection = DriverManager.getConnection("jdbc:sqlite:plugins/OllamaChat/chat_history.db");
                this.sqliteConnection.setAutoCommit(true);
            }
            return this.sqliteConnection;
        }
        return this.dataSource.getConnection();
    }

    private void createTables() throws SQLException {
        try (Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();){
            String uuidType = this.databaseType.equals("mysql") ? "VARCHAR(36)" : "TEXT";
            String textType = this.databaseType.equals("mysql") ? "VARCHAR(255)" : "TEXT";
            String aiModelType = this.databaseType.equals("mysql") ? "VARCHAR(100)" : "TEXT";
            String longTextType = this.databaseType.equals("mysql") ? "TEXT" : "TEXT";
            stmt.execute("CREATE TABLE IF NOT EXISTS players (uuid " + uuidType + " PRIMARY KEY,username " + textType + " NOT NULL)");
            stmt.execute("CREATE TABLE IF NOT EXISTS conversations (conversation_id " + uuidType + " NOT NULL,player_uuid " + uuidType + " NOT NULL,ai_model " + aiModelType + " NOT NULL,conversation_name " + textType + " NOT NULL,created_at DATETIME DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (conversation_id, player_uuid, ai_model),FOREIGN KEY (player_uuid) REFERENCES players(uuid))");
            stmt.execute("CREATE TABLE IF NOT EXISTS chat_history (id INTEGER PRIMARY KEY " + (this.databaseType.equals("sqlite") ? "AUTOINCREMENT" : "AUTO_INCREMENT") + ",player_uuid " + uuidType + " NOT NULL,ai_model " + aiModelType + " NOT NULL,conversation_id " + uuidType + ",timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,prompt " + longTextType + " NOT NULL,response " + longTextType + " NOT NULL,FOREIGN KEY (player_uuid) REFERENCES players(uuid),FOREIGN KEY (conversation_id, player_uuid, ai_model) REFERENCES conversations(conversation_id, player_uuid, ai_model))");
            this.logger.info("Database tables created successfully for " + this.databaseType.toUpperCase());
        }
    }

    public void savePlayerInfo(UUID uuid, String username) {
        String sql = this.databaseType.equals("sqlite") ? "INSERT OR REPLACE INTO players (uuid, username) VALUES (?, ?)" : "INSERT INTO players (uuid, username) VALUES (?, ?) ON DUPLICATE KEY UPDATE username = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, username);
            if (this.databaseType.equals("mysql")) {
                pstmt.setString(3, username);
            }
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.severe("Failed to save player info: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String createConversation(UUID playerUuid, String aiModel, String convName) {
        String convId = UUID.randomUUID().toString();
        String sql = "INSERT INTO conversations (conversation_id, player_uuid, ai_model, conversation_name) VALUES (?, ?, ?, ?)";
        try (Connection conn = this.getConnection();){
            String string;
            block14: {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                try {
                    pstmt.setString(1, convId);
                    pstmt.setString(2, playerUuid.toString());
                    pstmt.setString(3, aiModel);
                    pstmt.setString(4, convName);
                    pstmt.executeUpdate();
                    string = convId;
                    if (pstmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return string;
        }
        catch (SQLException e) {
            this.logger.severe("Failed to create conversation: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean conversationExistsByName(UUID playerUuid, String aiModel, String convName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getConversationId(UUID playerUuid, String aiModel, String convName) {
        String sql = "SELECT conversation_id FROM conversations WHERE conversation_name = ? AND player_uuid = ? AND ai_model = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, convName);
            pstmt.setString(2, playerUuid.toString());
            pstmt.setString(3, aiModel);
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString("conversation_id");
                return string;
            }
        }
        catch (SQLException e) {
            this.logger.severe("Failed to get conversation ID: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public boolean conversationExists(UUID playerUuid, String aiModel, String convId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean deleteConversation(UUID playerUuid, String aiModel, String convId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map<String, String> listConversations(UUID playerUuid, String aiModel) {
        HashMap<String, String> conversations = new HashMap<String, String>();
        String sql = "SELECT conversation_id, conversation_name FROM conversations WHERE player_uuid = ? AND ai_model = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            pstmt.setString(2, aiModel);
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    conversations.put(rs.getString("conversation_id"), rs.getString("conversation_name"));
                }
            }
        }
        catch (SQLException e) {
            this.logger.severe("Failed to list conversations: " + e.getMessage());
            e.printStackTrace();
        }
        return conversations;
    }

    public void saveChatHistory(UUID playerUuid, String aiModel, String conversationId, String prompt, String response) {
        String sql = "INSERT INTO chat_history (player_uuid, ai_model, conversation_id, prompt, response) VALUES (?, ?, ?, ?, ?)";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            pstmt.setString(2, aiModel);
            if (conversationId != null) {
                pstmt.setString(3, conversationId);
            } else {
                pstmt.setNull(3, 12);
            }
            pstmt.setString(4, prompt);
            pstmt.setString(5, response);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.severe("Failed to save chat history: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getChatHistory(UUID playerUuid, String aiModel, String conversationId, int maxHistory) {
        StringBuilder history = new StringBuilder();
        String sql = "SELECT prompt, response FROM chat_history WHERE player_uuid = ? AND ai_model = ? " + (conversationId != null ? "AND conversation_id = ? " : "AND conversation_id IS NULL ") + "ORDER BY timestamp DESC LIMIT ?";
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            pstmt.setString(2, aiModel);
            int index = 3;
            if (conversationId != null) {
                pstmt.setString(index++, conversationId);
            }
            pstmt.setInt(index, maxHistory);
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    history.insert(0, "User: " + rs.getString("prompt") + "\n");
                    history.insert(0, "AI: " + rs.getString("response") + "\n");
                }
            }
        }
        catch (SQLException e) {
            this.logger.severe("Failed to get chat history: " + e.getMessage());
            e.printStackTrace();
        }
        return history.toString();
    }

    public void close() {
        try {
            if (this.databaseType.equals("sqlite") && this.sqliteConnection != null && !this.sqliteConnection.isClosed()) {
                this.sqliteConnection.close();
            }
            if (this.dataSource != null) {
                this.dataSource.close();
            }
        }
        catch (SQLException e) {
            this.logger.severe("Failed to close database: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

