/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat;

import com.ollamachat.core.ConfigManager;
import com.ollamachat.core.Ollamachat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ProgressManager {
    private final Ollamachat plugin;
    private final ConfigManager configManager;
    private final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();
    private final Map<UUID, BukkitTask> tasks = new HashMap<UUID, BukkitTask>();

    public ProgressManager(Ollamachat plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
    }

    public void startProgress(Player player, String title, BarColor color, BarStyle style) {
        UUID uuid = player.getUniqueId();
        this.cleanup(player);
        if (this.plugin.getConfig().getString("progress-display.type", "bossbar").equalsIgnoreCase("bossbar")) {
            this.handleBossBarProgress(player, uuid, title, color, style);
        } else {
            this.handleActionBarProgress(player, uuid);
        }
    }

    private void handleBossBarProgress(Player player, UUID uuid, String title, BarColor color, BarStyle style) {
        BossBar bossBar = Bukkit.createBossBar((String)this.configManager.getMessage("generating-status", Map.of("progress", "0")), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
        bossBar.addPlayer(player);
        bossBar.setProgress(0.0);
        bossBar.setVisible(true);
        this.bossBars.put(uuid, bossBar);
        long interval = 20L * (long)this.plugin.getConfig().getInt("progress-display.update-interval", 1);
        this.tasks.put(uuid, Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!player.isOnline()) {
                this.cleanup(player);
            }
        }, 0L, interval));
    }

    private void handleActionBarProgress(Player player, UUID uuid) {
        long interval = 20L * (long)this.plugin.getConfig().getInt("progress-display.update-interval", 1);
        this.tasks.put(uuid, Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!player.isOnline()) {
                this.cleanup(player);
                return;
            }
            player.sendActionBar(this.configManager.getMessage("generating-status", Map.of("progress", "0")));
        }, 0L, interval));
    }

    public void complete(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.bossBars.containsKey(uuid)) {
            BossBar bossBar = this.bossBars.get(uuid);
            bossBar.setProgress(1.0);
            bossBar.setTitle(this.configManager.getMessage("complete-status", null));
            bossBar.setColor(BarColor.GREEN);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.cleanup(player), 40L);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.cleanup(player), 40L);
        }
    }

    public void error(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.bossBars.containsKey(uuid)) {
            BossBar bossBar = this.bossBars.get(uuid);
            bossBar.setTitle(this.configManager.getMessage("error-status", null));
            bossBar.setColor(BarColor.RED);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.cleanup(player), 40L);
        }
    }

    public void cleanup(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.tasks.containsKey(uuid)) {
            this.tasks.get(uuid).cancel();
            this.tasks.remove(uuid);
        }
        if (this.bossBars.containsKey(uuid)) {
            this.bossBars.get(uuid).removeAll();
            this.bossBars.remove(uuid);
        }
    }
}

