/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class AIService {
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final Gson gson = new Gson();

    public CompletableFuture<String> sendRequest(String apiUrl, String apiKey, String model, String prompt, boolean isMessagesFormat) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HttpRequest request;
                HttpResponse<String> response;
                Map<String, Boolean> requestBody = isMessagesFormat ? Map.of("model", model, "messages", List.of(Map.of("role", "user", "content", prompt)), "stream", false) : Map.of("model", model, "prompt", prompt, "stream", false);
                String jsonRequest = this.gson.toJson(requestBody);
                HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonRequest));
                if (apiKey != null && !apiKey.isEmpty()) {
                    requestBuilder.header("Authorization", "Bearer " + apiKey);
                }
                if ((response = this.httpClient.send(request = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode() == 200) {
                    return response.body();
                }
                throw new RuntimeException("AI API Error: " + response.body());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get response from AI: " + e.getMessage(), e);
            }
        });
    }

    public CompletableFuture<Void> sendStreamingRequest(String apiUrl, String apiKey, String model, String prompt, Consumer<String> responseConsumer, boolean isMessagesFormat) {
        return CompletableFuture.runAsync(() -> {
            block10: {
                try {
                    HttpRequest request;
                    HttpResponse<String> response;
                    Map<String, Boolean> requestBody = isMessagesFormat ? Map.of("model", model, "messages", List.of(Map.of("role", "user", "content", prompt)), "stream", true) : Map.of("model", model, "prompt", prompt, "stream", true);
                    String jsonRequest = this.gson.toJson(requestBody);
                    HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonRequest));
                    if (apiKey != null && !apiKey.isEmpty()) {
                        requestBuilder.header("Authorization", "Bearer " + apiKey);
                    }
                    if ((response = this.httpClient.send(request = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode() == 200) {
                        String[] lines;
                        StringBuilder buffer = new StringBuilder();
                        int minBufferLength = 50;
                        for (String line : lines = response.body().split("\n")) {
                            JsonObject json;
                            if (line.trim().isEmpty()) continue;
                            if (isMessagesFormat && line.startsWith("data: ")) {
                                String jsonData = line.substring(6);
                                if (jsonData.equals("[DONE]")) continue;
                                JsonObject json2 = (JsonObject)this.gson.fromJson(jsonData, JsonObject.class);
                                if (json2.has("choices")) {
                                    String partialResponse = json2.getAsJsonArray("choices").get(0).getAsJsonObject().get("delta").getAsJsonObject().get("content").getAsString();
                                    buffer.append(partialResponse);
                                }
                            } else if (!isMessagesFormat && (json = (JsonObject)this.gson.fromJson(line, JsonObject.class)).has("response")) {
                                String partialResponse = json.get("response").getAsString();
                                buffer.append(partialResponse);
                            }
                            String currentBuffer = buffer.toString();
                            if (!currentBuffer.endsWith(".") && !currentBuffer.endsWith("?") && !currentBuffer.endsWith("!") && currentBuffer.length() < minBufferLength) continue;
                            responseConsumer.accept(currentBuffer);
                            buffer.setLength(0);
                        }
                        if (buffer.length() > 0) {
                            responseConsumer.accept(buffer.toString());
                        }
                        break block10;
                    }
                    throw new RuntimeException("AI API Error: " + response.body());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to get streaming response from AI: " + e.getMessage(), e);
                }
            }
        });
    }
}

