/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat.core;

import com.ollamachat.ChatHistoryManager;
import com.ollamachat.DatabaseManager;
import com.ollamachat.DependencyLoader;
import com.ollamachat.ProgressManager;
import com.ollamachat.chat.ChatTriggerHandler;
import com.ollamachat.chat.SuggestedResponseHandler;
import com.ollamachat.command.AIChatCommand;
import com.ollamachat.command.OllamaChatCommand;
import com.ollamachat.command.OllamaChatTabCompleter;
import com.ollamachat.core.ConfigManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Ollamachat
extends JavaPlugin {
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private ChatHistoryManager chatHistoryManager;
    private ProgressManager progressManager;
    private SuggestedResponseHandler suggestedResponseHandler;
    private Map<UUID, Boolean> playerSuggestionToggles;

    public void onEnable() {
        ClassLoader dependencyClassLoader;
        DependencyLoader dependencyLoader = new DependencyLoader(this);
        try {
            dependencyLoader.loadDependencies();
            dependencyClassLoader = dependencyLoader.getClass().getClassLoader();
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load dependencies: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.configManager = new ConfigManager(this);
        this.configManager.initialize();
        try {
            this.databaseManager = new DatabaseManager(this, dependencyClassLoader);
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize DatabaseManager: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        int maxHistory = this.configManager.getMaxHistory();
        this.chatHistoryManager = new ChatHistoryManager(this.databaseManager, maxHistory);
        this.progressManager = new ProgressManager(this);
        this.suggestedResponseHandler = new SuggestedResponseHandler(this);
        this.playerSuggestionToggles = new HashMap<UUID, Boolean>();
        this.getServer().getPluginManager().registerEvents((Listener)new ChatTriggerHandler(this), (Plugin)this);
        this.getCommand("ollamachat").setExecutor((CommandExecutor)new OllamaChatCommand(this));
        this.getCommand("ollamachat").setTabCompleter((TabCompleter)new OllamaChatTabCompleter(this));
        this.getCommand("aichat").setExecutor((CommandExecutor)new AIChatCommand(this));
        this.getCommand("aichat").setTabCompleter((TabCompleter)new OllamaChatTabCompleter(this));
    }

    public void onDisable() {
        if (this.databaseManager != null) {
            this.databaseManager.close();
        } else {
            this.getLogger().warning("DatabaseManager was null, skipping close.");
        }
        if (this.progressManager != null) {
            this.getServer().getOnlinePlayers().forEach(this.progressManager::cleanup);
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public ChatHistoryManager getChatHistoryManager() {
        return this.chatHistoryManager;
    }

    public ProgressManager getProgressManager() {
        return this.progressManager;
    }

    public SuggestedResponseHandler getSuggestedResponseHandler() {
        return this.suggestedResponseHandler;
    }

    public Map<UUID, Boolean> getPlayerSuggestionToggles() {
        return this.playerSuggestionToggles;
    }
}

