/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat.chat;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.ollamachat.AIService;
import com.ollamachat.chat.SuggestedResponseHandler;
import com.ollamachat.core.ConfigManager;
import com.ollamachat.core.Ollamachat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatTriggerHandler
implements Listener {
    private final Ollamachat plugin;
    private final ConfigManager configManager;
    private final AIService aiService;
    private final SuggestedResponseHandler suggestedResponseHandler;
    private final Gson gson;

    public ChatTriggerHandler(Ollamachat plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.aiService = new AIService();
        this.suggestedResponseHandler = new SuggestedResponseHandler(plugin);
        this.gson = new Gson();
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.configManager.isOllamaEnabled()) {
            return;
        }
        String message = event.getMessage();
        Player player = event.getPlayer();
        for (String prefix : this.configManager.getTriggerPrefixes()) {
            if (!message.startsWith(prefix)) continue;
            event.setCancelled(true);
            String prompt = message.substring(prefix.length()).trim();
            if (prompt.isEmpty()) break;
            this.processAIQuery(player, "ollama", prompt);
            break;
        }
    }

    public void processAIQuery(Player player, String aiName, String prompt) {
        if (!aiName.equalsIgnoreCase("ollama") && !this.configManager.getOtherAIEnabled().getOrDefault(aiName, false).booleanValue()) {
            this.sendErrorMessage(player, this.configManager.getMessage("error-prefix", null) + this.configManager.getMessage("toggle-disabled", Map.of("ai-name", aiName)));
            return;
        }
        if (this.plugin.getConfig().getBoolean("progress-display.enabled", true)) {
            BarColor color = BarColor.valueOf((String)this.plugin.getConfig().getString("progress-display.color", "BLUE"));
            BarStyle style = BarStyle.valueOf((String)this.plugin.getConfig().getString("progress-display.style", "SOLID"));
            this.plugin.getProgressManager().startProgress(player, this.configManager.getMessage("generating-status", null), color, style);
        }
        CompletableFuture.runAsync(() -> {
            try {
                String finalResponse;
                boolean isMessagesFormat;
                String model;
                String apiKey;
                String apiUrl;
                UUID playerUuid = player.getUniqueId();
                this.plugin.getChatHistoryManager().savePlayerInfo(player);
                String conversationName = this.configManager.getSelectedConversations().computeIfAbsent(playerUuid, k -> new HashMap()).getOrDefault(aiName, null);
                String conversationId = conversationName != null ? this.plugin.getChatHistoryManager().getConversationId(playerUuid, aiName, conversationName) : null;
                String history = this.plugin.getChatHistoryManager().getChatHistory(playerUuid, aiName, conversationId);
                String selectedPrompt = this.configManager.getPrompts().getOrDefault(this.configManager.getDefaultPrompt(), "");
                String context = history + (String)(selectedPrompt.isEmpty() ? "" : selectedPrompt + "\n") + "User: " + prompt;
                if (aiName.equalsIgnoreCase("ollama")) {
                    apiUrl = this.configManager.getOllamaApiUrl();
                    apiKey = null;
                    model = this.configManager.getOllamaModel();
                    isMessagesFormat = false;
                } else {
                    ConfigManager.AIConfig aiConfig = this.configManager.getOtherAIConfigs().get(aiName);
                    apiUrl = aiConfig.getApiUrl();
                    apiKey = aiConfig.getApiKey();
                    model = aiConfig.getModel();
                    isMessagesFormat = aiConfig.isMessagesFormat();
                }
                if (this.configManager.isStreamingEnabled()) {
                    StringBuilder fullResponse = new StringBuilder();
                    AtomicBoolean isFirstMessage = new AtomicBoolean(true);
                    this.aiService.sendStreamingRequest(apiUrl, apiKey, model, context, partialResponse -> {
                        if (player.isOnline()) {
                            String formattedPartial = partialResponse.length() > this.configManager.getMaxResponseLength() ? partialResponse.substring(0, this.configManager.getMaxResponseLength()) + "..." : partialResponse;
                            String message = isFirstMessage.get() ? this.configManager.getMessage("response-prefix", null) + formattedPartial : formattedPartial;
                            player.sendMessage(message);
                            isFirstMessage.set(false);
                            fullResponse.append((String)partialResponse);
                        }
                    }, isMessagesFormat).join();
                    finalResponse = fullResponse.toString();
                } else {
                    String responseBody = this.aiService.sendRequest(apiUrl, apiKey, model, context, isMessagesFormat).join();
                    if (isMessagesFormat) {
                        JsonObject json = (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
                        finalResponse = json.getAsJsonArray("choices").get(0).getAsJsonObject().get("message").getAsJsonObject().get("content").getAsString();
                    } else {
                        JsonObject json = (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
                        finalResponse = json.get("response").getAsString();
                    }
                    if (player.isOnline()) {
                        this.sendFormattedResponse(player, finalResponse);
                    }
                }
                if (!finalResponse.isEmpty()) {
                    this.plugin.getChatHistoryManager().saveChatHistory(playerUuid, aiName, conversationId, prompt, finalResponse);
                    this.suggestedResponseHandler.sendSuggestedResponses(player, aiName, prompt, finalResponse);
                }
                this.plugin.getProgressManager().complete(player);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error processing " + aiName + " request: " + e.getMessage());
                if (player.isOnline()) {
                    this.sendErrorMessage(player, this.configManager.getMessage("error-prefix", null) + "Failed to get response from " + aiName);
                }
                this.plugin.getProgressManager().error(player);
            }
        });
    }

    private void sendFormattedResponse(Player player, String response) {
        if (((String)response).length() > this.configManager.getMaxResponseLength()) {
            response = ((String)response).substring(0, this.configManager.getMaxResponseLength()) + "...";
        }
        player.sendMessage(this.configManager.getMessage("response-prefix", null) + (String)response);
    }

    private void sendErrorMessage(Player player, String errorMessage) {
        player.sendMessage(errorMessage);
    }
}

