/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;

public class DependencyLoader {
    private final JavaPlugin plugin;
    private final Logger logger;
    private final File libDir;
    private URLClassLoader dependencyClassLoader;

    public DependencyLoader(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.libDir = new File(plugin.getDataFolder(), "libs");
    }

    public boolean loadDependencies() {
        try {
            if (!this.libDir.exists()) {
                this.libDir.mkdirs();
            }
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            dependencies.add(new Dependency("com.mysql", "mysql-connector-j", "8.0.33"));
            dependencies.add(new Dependency("org.xerial", "sqlite-jdbc", "3.46.0.0"));
            ArrayList<URL> jarUrls = new ArrayList<URL>();
            for (Dependency dep : dependencies) {
                File jarFile = this.downloadDependency(dep);
                if (jarFile != null) {
                    jarUrls.add(jarFile.toURI().toURL());
                    this.logger.info("Found dependency: " + jarFile.getName());
                    continue;
                }
                this.logger.warning("Failed to download dependency: " + dep.artifactId + "-" + dep.version);
            }
            if (jarUrls.isEmpty()) {
                this.logger.warning("No dependencies were successfully downloaded.");
                return false;
            }
            this.dependencyClassLoader = new URLClassLoader(jarUrls.toArray(new URL[0]), this.plugin.getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(this.dependencyClassLoader);
            this.logger.info("Successfully loaded " + jarUrls.size() + " dependencies");
            return true;
        }
        catch (Exception e) {
            this.logger.severe("Failed to load dependencies: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public ClassLoader getDependencyClassLoader() {
        return this.dependencyClassLoader;
    }

    private File downloadDependency(Dependency dep) {
        File file;
        block9: {
            String fileName = dep.artifactId + "-" + dep.version + ".jar";
            File file2 = new File(this.libDir, fileName);
            if (file2.exists()) {
                return file2;
            }
            String mavenPath = String.format("%s/%s/%s/%s-%s.jar", dep.groupId.replace(".", "/"), dep.artifactId, dep.version, dep.artifactId, dep.version);
            String url = "https://repo1.maven.org/maven2/" + mavenPath;
            InputStream in = new URL(url).openStream();
            try {
                Files.copy(in, file2.toPath(), new CopyOption[0]);
                this.logger.info("Downloaded dependency: " + fileName);
                file = file2;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.logger.severe("Failed to download dependency " + fileName + ": " + e.getMessage());
                    return null;
                }
            }
            in.close();
        }
        return file;
    }

    private static class Dependency {
        String groupId;
        String artifactId;
        String version;

        Dependency(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }
    }
}

