/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat.command;

import com.ollamachat.chat.ChatTriggerHandler;
import com.ollamachat.core.ConfigManager;
import com.ollamachat.core.Ollamachat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class OllamaChatCommand
implements CommandExecutor {
    private final Ollamachat plugin;
    private final ConfigManager configManager;
    private final ChatTriggerHandler chatTriggerHandler;

    public OllamaChatCommand(Ollamachat plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.chatTriggerHandler = new ChatTriggerHandler(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("usage-ollSnackChat", null), (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("ollamachat.reload")) {
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                return true;
            }
            this.configManager.reloadConfigValues();
            sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("reload-success", null), (TextColor)NamedTextColor.GREEN));
            return true;
        }
        if (args[0].equalsIgnoreCase("toggle") && args.length > 1) {
            if (!sender.hasPermission("ollamachat.toggle")) {
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                return true;
            }
            String aiName = args[1];
            if (aiName.equalsIgnoreCase("ollama")) {
                this.configManager.setOllamaEnabled(!this.configManager.isOllamaEnabled());
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage(this.configManager.isOllamaEnabled() ? "ollama-enabled" : "ollama-disabled", null), (TextColor)NamedTextColor.GREEN));
            } else if (this.configManager.getOtherAIConfigs().containsKey(aiName)) {
                boolean newState = this.configManager.getOtherAIEnabled().getOrDefault(aiName, false) == false;
                this.configManager.getOtherAIEnabled().put(aiName, newState);
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage(newState ? "toggle-enabled" : "toggle-disabled", Map.of("ai-name", aiName)), (TextColor)NamedTextColor.GREEN));
            } else {
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("invalid-ai-name", Map.of("ai-list", String.join((CharSequence)", ", this.configManager.getOtherAIConfigs().keySet()))), (TextColor)NamedTextColor.RED));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("prompt") && args.length > 1) {
            String subCommand = args[1].toLowerCase();
            if (subCommand.equals("set") && args.length > 3) {
                if (!sender.hasPermission("ollamachat.prompt.set")) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                    return true;
                }
                String promptName = args[2];
                String promptContent = String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length));
                this.plugin.getConfig().set("prompts." + promptName, (Object)promptContent);
                this.plugin.saveConfig();
                this.configManager.getPrompts().put(promptName, promptContent);
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("prompt-set", Map.of("name", promptName)), (TextColor)NamedTextColor.GREEN));
                return true;
            }
            if (subCommand.equals("delete") && args.length == 3) {
                if (!sender.hasPermission("ollamachat.prompt.delete")) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                    return true;
                }
                String promptName = args[2];
                if (this.configManager.getPrompts().containsKey(promptName)) {
                    this.plugin.getConfig().set("prompts." + promptName, null);
                    if (this.configManager.getDefaultPrompt().equals(promptName)) {
                        this.plugin.getConfig().set("default-prompt", (Object)"");
                        this.configManager.setDefaultPrompt("");
                    }
                    this.plugin.saveConfig();
                    this.configManager.getPrompts().remove(promptName);
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("prompt-deleted", Map.of("name", promptName)), (TextColor)NamedTextColor.GREEN));
                } else {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("prompt-not-found", Map.of("name", promptName)), (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            if (subCommand.equals("list")) {
                if (!sender.hasPermission("ollamachat.prompt.list")) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (this.configManager.getPrompts().isEmpty()) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("prompt-list-empty", null), (TextColor)NamedTextColor.GREEN));
                } else {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("prompt-list", Map.of("prompts", String.join((CharSequence)", ", this.configManager.getPrompts().keySet()))), (TextColor)NamedTextColor.GREEN));
                }
                if (!this.configManager.getDefaultPrompt().isEmpty() && this.configManager.getPrompts().containsKey(this.configManager.getDefaultPrompt())) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("prompt-default", Map.of("name", this.configManager.getDefaultPrompt())), (TextColor)NamedTextColor.GREEN));
                } else if (!this.configManager.getDefaultPrompt().isEmpty()) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("prompt-default-invalid", Map.of("name", this.configManager.getDefaultPrompt())), (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            if (subCommand.equals("select") && args.length == 3) {
                if (!sender.hasPermission("ollamachat.prompt.select")) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                    return true;
                }
                String promptName = args[2];
                if (this.configManager.getPrompts().containsKey(promptName)) {
                    this.plugin.getConfig().set("default-prompt", (Object)promptName);
                    this.plugin.saveConfig();
                    this.configManager.setDefaultPrompt(promptName);
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("prompt-selected", Map.of("name", promptName)), (TextColor)NamedTextColor.GREEN));
                } else {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("prompt-not-found", Map.of("name", promptName)), (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            if (subCommand.equals("clear")) {
                if (!sender.hasPermission("ollamachat.prompt.select")) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.plugin.getConfig().set("default-prompt", (Object)"");
                this.plugin.saveConfig();
                this.configManager.setDefaultPrompt("");
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("prompt-cleared", null), (TextColor)NamedTextColor.GREEN));
                return true;
            }
            sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("prompt-usage", null), (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        if (args[0].equalsIgnoreCase("conversation") && args.length > 1) {
            String aiName;
            if (!(sender instanceof Player)) {
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("player-only", null), (TextColor)NamedTextColor.RED));
                return true;
            }
            Player player = (Player)sender;
            String subCommand = args[1].toLowerCase();
            String string = aiName = args.length > 2 ? args[2] : "ollama";
            if (!aiName.equals("ollama") && !this.configManager.getOtherAIConfigs().containsKey(aiName)) {
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("invalid-ai-name", Map.of("ai-list", String.join((CharSequence)", ", this.configManager.getOtherAIConfigs().keySet()))), (TextColor)NamedTextColor.RED));
                return true;
            }
            if (subCommand.equals("new") && args.length == 4) {
                if (!sender.hasPermission("ollamachat.conversation.new")) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                    return true;
                }
                String convName = args[3];
                String convId = this.plugin.getChatHistoryManager().createConversation(player.getUniqueId(), aiName, convName);
                this.configManager.getSelectedConversations().computeIfAbsent(player.getUniqueId(), k -> new HashMap()).put(aiName, convName);
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("conversation-created", Map.of("name", convName, "ai-name", aiName)), (TextColor)NamedTextColor.GREEN));
                return true;
            }
            if (subCommand.equals("select") && args.length == 4) {
                if (!sender.hasPermission("ollamachat.conversation.select")) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                    return true;
                }
                String convName = args[3];
                if (this.plugin.getChatHistoryManager().conversationExistsByName(player.getUniqueId(), aiName, convName)) {
                    this.configManager.getSelectedConversations().computeIfAbsent(player.getUniqueId(), k -> new HashMap()).put(aiName, convName);
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("conversation-selected", Map.of("name", convName, "ai-name", aiName)), (TextColor)NamedTextColor.GREEN));
                } else {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("conversation-not-found", Map.of("name", convName)), (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            if (subCommand.equals("delete") && args.length == 4) {
                if (!sender.hasPermission("ollamachat.conversation.delete")) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                    return true;
                }
                String convName = args[3];
                String convId = this.plugin.getChatHistoryManager().getConversationId(player.getUniqueId(), aiName, convName);
                if (convId != null && this.plugin.getChatHistoryManager().deleteConversation(player.getUniqueId(), aiName, convId)) {
                    Map<String, String> convMap = this.configManager.getSelectedConversations().get(player.getUniqueId());
                    if (convMap != null && convName.equals(convMap.get(aiName))) {
                        convMap.remove(aiName);
                    }
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("conversation-deleted", Map.of("name", convName, "ai-name", aiName)), (TextColor)NamedTextColor.GREEN));
                } else {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("conversation-not-found", Map.of("name", convName)), (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            if (subCommand.equals("list") && args.length == 3) {
                if (!sender.hasPermission("ollamachat.conversation.list")) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                    return true;
                }
                Map<String, String> conversations = this.plugin.getChatHistoryManager().listConversations(player.getUniqueId(), aiName);
                if (conversations.isEmpty()) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("conversation-list-empty", Map.of("ai-name", aiName)), (TextColor)NamedTextColor.GREEN));
                } else {
                    String convList = String.join((CharSequence)", ", conversations.values());
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("conversation-list", Map.of("conversations", convList, "ai-name", aiName)), (TextColor)NamedTextColor.GREEN));
                }
                String selectedConv = (String)this.configManager.getSelectedConversations().computeIfAbsent(player.getUniqueId(), k -> new HashMap()).get(aiName);
                if (selectedConv != null && conversations.containsValue(selectedConv)) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("conversation-default", Map.of("name", selectedConv, "ai-name", aiName)), (TextColor)NamedTextColor.GREEN));
                } else if (selectedConv != null) {
                    sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("conversation-default-invalid", Map.of("name", selectedConv, "ai-name", aiName)), (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("conversation-usage", null), (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        if (args[0].equalsIgnoreCase("suggests") && args.length == 2) {
            if (!(sender instanceof Player)) {
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("player-only", null), (TextColor)NamedTextColor.RED));
                return true;
            }
            if (!sender.hasPermission("ollamachat.suggests.toggle")) {
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                return true;
            }
            Player player = (Player)sender;
            String subCommand = args[1].toLowerCase();
            if (subCommand.equals("on")) {
                this.plugin.getSuggestedResponseHandler().toggleSuggestionsForPlayer(player, true);
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("suggests-enabled", Map.of("player", player.getName())), (TextColor)NamedTextColor.GREEN));
                return true;
            }
            if (subCommand.equals("off")) {
                this.plugin.getSuggestedResponseHandler().toggleSuggestionsForPlayer(player, false);
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("suggests-disabled", Map.of("player", player.getName())), (TextColor)NamedTextColor.RED));
                return true;
            }
            sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("usage-ollamachat", null), (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        if (args[0].equalsIgnoreCase("suggests-presets") && args.length == 2) {
            if (!sender.hasPermission("ollamachat.suggests-presets.toggle")) {
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("no-permission", null), (TextColor)NamedTextColor.RED));
                return true;
            }
            String subCommand = args[1].toLowerCase();
            if (subCommand.equals("on")) {
                this.configManager.setSuggestedResponsePresetsEnabled(true);
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("suggests-presets-enabled", null), (TextColor)NamedTextColor.GREEN));
                return true;
            }
            if (subCommand.equals("off")) {
                this.configManager.setSuggestedResponsePresetsEnabled(false);
                sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("suggests-presets-disabled", null), (TextColor)NamedTextColor.RED));
                return true;
            }
            sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("usage-ollamachat", null), (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        sender.sendMessage((Component)Component.text((String)this.configManager.getMessage("usage-ollamachat", null), (TextColor)NamedTextColor.YELLOW));
        return true;
    }
}

