/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat.chat;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.ollamachat.AIService;
import com.ollamachat.core.ConfigManager;
import com.ollamachat.core.Ollamachat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;

public class SuggestedResponseHandler {
    private final Ollamachat plugin;
    private final ConfigManager configManager;
    private final AIService aiService;
    private final Gson gson;
    private final Map<UUID, Long> lastSuggestionTimes;

    public SuggestedResponseHandler(Ollamachat plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.aiService = new AIService();
        this.gson = new Gson();
        this.lastSuggestionTimes = new HashMap<UUID, Long>();
    }

    public boolean isSuggestionsEnabledForPlayer(Player player) {
        Map<UUID, Boolean> playerSuggestionToggles = this.plugin.getPlayerSuggestionToggles();
        return playerSuggestionToggles.computeIfAbsent(player.getUniqueId(), k -> true);
    }

    public void toggleSuggestionsForPlayer(Player player, boolean enabled) {
        this.plugin.getPlayerSuggestionToggles().put(player.getUniqueId(), enabled);
    }

    public boolean canGenerateSuggestions(Player player) {
        int cooldown = this.configManager.getSuggestedResponseCooldown();
        if (cooldown <= 0) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        Long lastTime = this.lastSuggestionTimes.get(player.getUniqueId());
        if (lastTime == null || (currentTime - lastTime) / 1000L >= (long)cooldown) {
            this.lastSuggestionTimes.put(player.getUniqueId(), currentTime);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void sendSuggestedResponses(Player player, String originalAIName, String originalPrompt, String originalResponse) {
        List<String> suggestedModels;
        if (!this.configManager.isSuggestedResponsesEnabled() || !this.isSuggestionsEnabledForPlayer(player)) {
            return;
        }
        if (!this.canGenerateSuggestions(player)) {
            int cooldown = this.configManager.getSuggestedResponseCooldown();
            long lastTime = this.lastSuggestionTimes.get(player.getUniqueId());
            long l = (long)cooldown - (System.currentTimeMillis() - lastTime) / 1000L;
            player.sendMessage((Component)Component.text((String)this.configManager.getMessage("suggests-rate-limit", Map.of("seconds", String.valueOf(l))), (TextColor)NamedTextColor.RED));
            return;
        }
        ArrayList<String> suggestedResponses = new ArrayList<String>();
        if (this.configManager.isSuggestedResponsePresetsEnabled()) {
            suggestedResponses.addAll(this.configManager.getSuggestedResponsePresets());
        }
        if (!(suggestedModels = this.configManager.getSuggestedResponseModels()).isEmpty()) {
            CompletableFuture.runAsync(() -> {
                for (String model : suggestedModels) {
                    if (model.equalsIgnoreCase(originalAIName) || !this.configManager.getSuggestedResponseModelToggles().getOrDefault(model, true).booleanValue()) continue;
                    try {
                        String[] suggestions;
                        String suggestedText;
                        boolean isMessagesFormat;
                        String apiKey;
                        String apiUrl;
                        ConfigManager.AIConfig aiConfig = this.configManager.getOtherAIConfigs().get(model);
                        if (aiConfig != null && this.configManager.getOtherAIEnabled().getOrDefault(model, false).booleanValue()) {
                            apiUrl = aiConfig.getApiUrl();
                            apiKey = aiConfig.getApiKey();
                            isMessagesFormat = aiConfig.isMessagesFormat();
                        } else {
                            apiUrl = this.configManager.getOllamaApiUrl();
                            apiKey = null;
                            isMessagesFormat = false;
                        }
                        String promptTemplate = this.configManager.getSuggestedResponsePrompt();
                        String context = promptTemplate.replace("{prompt}", originalPrompt).replace("{response}", originalResponse).replace("{count}", String.valueOf(this.configManager.getSuggestedResponseCount()));
                        String responseBody = this.aiService.sendRequest(apiUrl, apiKey, model, context, isMessagesFormat).join();
                        if (isMessagesFormat) {
                            json = (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
                            suggestedText = json.getAsJsonArray("choices").get(0).getAsJsonObject().get("message").getAsJsonObject().get("content").getAsString();
                        } else {
                            json = (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
                            suggestedText = json.get("response").getAsString();
                        }
                        for (String suggestion : suggestions = suggestedText.split("\n")) {
                            String cleanedSuggestion = suggestion.replaceAll("^\\d+\\.\\s*", "").trim();
                            if (cleanedSuggestion.isEmpty()) continue;
                            suggestedResponses.add("[" + model + "] " + cleanedSuggestion);
                        }
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Failed to get suggested response from " + model + ": " + e.getMessage());
                    }
                }
                if (player.isOnline() && !suggestedResponses.isEmpty()) {
                    player.sendMessage((Component)Component.text((String)this.configManager.getMessage("suggested-responses-header", null), (TextColor)NamedTextColor.GREEN));
                    for (Object response : suggestedResponses) {
                        if (((String)response).length() > this.configManager.getMaxResponseLength()) {
                            response = ((String)response).substring(0, this.configManager.getMaxResponseLength()) + "...";
                            player.sendMessage((Component)Component.text((String)this.configManager.getMessage("response-truncated", null), (TextColor)NamedTextColor.YELLOW));
                        }
                        String prefix = this.configManager.getMessage("suggested-response-prefix", null);
                        String command = "/aichat " + originalAIName + " " + ((String)response).replace("\"", "\\\"");
                        Component message = ((TextComponent)((TextComponent)Component.text((String)(prefix + (String)response)).color((TextColor)NamedTextColor.WHITE)).clickEvent(ClickEvent.runCommand((String)command))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)this.configManager.getMessage("suggested-response-hover", null), (TextColor)NamedTextColor.YELLOW)));
                        player.sendMessage(message);
                    }
                }
            });
        } else if (player.isOnline() && !suggestedResponses.isEmpty()) {
            player.sendMessage((Component)Component.text((String)this.configManager.getMessage("suggested-responses-header", null), (TextColor)NamedTextColor.GREEN));
            for (String string : suggestedResponses) {
                void var8_10;
                if (string.length() > this.configManager.getMaxResponseLength()) {
                    String string2 = string.substring(0, this.configManager.getMaxResponseLength()) + "...";
                    player.sendMessage((Component)Component.text((String)this.configManager.getMessage("response-truncated", null), (TextColor)NamedTextColor.YELLOW));
                }
                String prefix = this.configManager.getMessage("suggested-response-prefix", null);
                String command = "/aichat " + originalAIName + " " + var8_10.replace("\"", "\\\"");
                Component message = ((TextComponent)((TextComponent)Component.text((String)(prefix + (String)var8_10)).color((TextColor)NamedTextColor.WHITE)).clickEvent(ClickEvent.runCommand((String)command))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)this.configManager.getMessage("suggested-response-hover", null), (TextColor)NamedTextColor.YELLOW)));
                player.sendMessage(message);
            }
        }
    }
}

