/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DatabaseManager {
    private Connection connection;

    public DatabaseManager() {
        this.initializeDatabase();
    }

    private void initializeDatabase() {
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:plugins/OllamaChat/chat_history.db");
            this.createTables();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createTables() throws SQLException {
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute("CREATE TABLE IF NOT EXISTS players (uuid TEXT PRIMARY KEY,username TEXT NOT NULL)");
            stmt.execute("CREATE TABLE IF NOT EXISTS conversations (conversation_id TEXT NOT NULL,player_uuid TEXT NOT NULL,ai_model TEXT NOT NULL,conversation_name TEXT NOT NULL,created_at DATETIME DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (conversation_id, player_uuid, ai_model),FOREIGN KEY (player_uuid) REFERENCES players(uuid))");
            stmt.execute("CREATE TABLE IF NOT EXISTS chat_history (id INTEGER PRIMARY KEY AUTOINCREMENT,player_uuid TEXT NOT NULL,ai_model TEXT NOT NULL,conversation_id TEXT,timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,prompt TEXT NOT NULL,response TEXT NOT NULL,FOREIGN KEY (player_uuid) REFERENCES players(uuid),FOREIGN KEY (conversation_id, player_uuid, ai_model) REFERENCES conversations(conversation_id, player_uuid, ai_model))");
        }
    }

    public void savePlayerInfo(UUID uuid, String username) {
        String sql = "INSERT OR REPLACE INTO players(uuid, username) VALUES(?, ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, username);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String createConversation(UUID playerUuid, String aiModel, String convName) {
        String string;
        block8: {
            String convId = UUID.randomUUID().toString();
            String sql = "INSERT INTO conversations(conversation_id, player_uuid, ai_model, conversation_name) VALUES(?, ?, ?, ?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, convId);
                pstmt.setString(2, playerUuid.toString());
                pstmt.setString(3, aiModel);
                pstmt.setString(4, convName);
                pstmt.executeUpdate();
                string = convId;
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            pstmt.close();
        }
        return string;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean conversationExistsByName(UUID playerUuid, String aiModel, String convName) {
        String sql = "SELECT 1 FROM conversations WHERE conversation_name = ? AND player_uuid = ? AND ai_model = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            boolean bl;
            block14: {
                pstmt.setString(1, convName);
                pstmt.setString(2, playerUuid.toString());
                pstmt.setString(3, aiModel);
                ResultSet rs = pstmt.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getConversationId(UUID playerUuid, String aiModel, String convName) {
        String sql = "SELECT conversation_id FROM conversations WHERE conversation_name = ? AND player_uuid = ? AND ai_model = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, convName);
            pstmt.setString(2, playerUuid.toString());
            pstmt.setString(3, aiModel);
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString("conversation_id");
                return string;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean conversationExists(UUID playerUuid, String aiModel, String convId) {
        String sql = "SELECT 1 FROM conversations WHERE conversation_id = ? AND player_uuid = ? AND ai_model = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            boolean bl;
            block14: {
                pstmt.setString(1, convId);
                pstmt.setString(2, playerUuid.toString());
                pstmt.setString(3, aiModel);
                ResultSet rs = pstmt.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean deleteConversation(UUID playerUuid, String aiModel, String convId) {
        String sqlDeleteHistory = "DELETE FROM chat_history WHERE conversation_id = ? AND player_uuid = ? AND ai_model = ?";
        String sqlDeleteConv = "DELETE FROM conversations WHERE conversation_id = ? AND player_uuid = ? AND ai_model = ?";
        try (PreparedStatement pstmtHistory = this.connection.prepareStatement(sqlDeleteHistory);){
            boolean bl;
            block14: {
                PreparedStatement pstmtConv = this.connection.prepareStatement(sqlDeleteConv);
                try {
                    pstmtHistory.setString(1, convId);
                    pstmtHistory.setString(2, playerUuid.toString());
                    pstmtHistory.setString(3, aiModel);
                    pstmtConv.setString(1, convId);
                    pstmtConv.setString(2, playerUuid.toString());
                    pstmtConv.setString(3, aiModel);
                    int rowsAffected = pstmtHistory.executeUpdate() + pstmtConv.executeUpdate();
                    boolean bl2 = bl = rowsAffected > 0;
                    if (pstmtConv == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pstmtConv != null) {
                        try {
                            pstmtConv.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmtConv.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Map<String, String> listConversations(UUID playerUuid, String aiModel) {
        HashMap<String, String> conversations = new HashMap<String, String>();
        String sql = "SELECT conversation_id, conversation_name FROM conversations WHERE player_uuid = ? AND ai_model = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            pstmt.setString(2, aiModel);
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    conversations.put(rs.getString("conversation_id"), rs.getString("conversation_name"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return conversations;
    }

    public void saveChatHistory(UUID playerUuid, String aiModel, String conversationId, String prompt, String response) {
        String sql = "INSERT INTO chat_history(player_uuid, ai_model, conversation_id, prompt, response) VALUES(?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            pstmt.setString(2, aiModel);
            if (conversationId != null) {
                pstmt.setString(3, conversationId);
            } else {
                pstmt.setNull(3, 12);
            }
            pstmt.setString(4, prompt);
            pstmt.setString(5, response);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getChatHistory(UUID playerUuid, String aiModel, String conversationId, int maxHistory) {
        StringBuilder history = new StringBuilder();
        String sql = "SELECT prompt, response FROM chat_history WHERE player_uuid = ? AND ai_model = ? " + (conversationId != null ? "AND conversation_id = ? " : "AND conversation_id IS NULL ") + "ORDER BY timestamp DESC LIMIT ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUuid.toString());
            pstmt.setString(2, aiModel);
            int index = 3;
            if (conversationId != null) {
                pstmt.setString(index++, conversationId);
            }
            pstmt.setInt(index, maxHistory);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                history.insert(0, "User: " + rs.getString("prompt") + "\n");
                history.insert(0, "AI: " + rs.getString("response") + "\n");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return history.toString();
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

