/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat.core;

import com.ollamachat.ChatHistoryManager;
import com.ollamachat.DatabaseManager;
import com.ollamachat.ProgressManager;
import com.ollamachat.chat.ChatTriggerHandler;
import com.ollamachat.command.AIChatCommand;
import com.ollamachat.command.OllamaChatCommand;
import com.ollamachat.command.OllamaChatTabCompleter;
import com.ollamachat.core.ConfigManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Ollamachat
extends JavaPlugin {
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private ChatHistoryManager chatHistoryManager;
    private ProgressManager progressManager;

    public void onEnable() {
        this.configManager = new ConfigManager(this);
        this.configManager.initialize();
        try {
            this.databaseManager = new DatabaseManager();
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize DatabaseManager: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        int maxHistory = this.configManager.getMaxHistory();
        this.chatHistoryManager = new ChatHistoryManager(this.databaseManager, maxHistory);
        this.progressManager = new ProgressManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatTriggerHandler(this), (Plugin)this);
        this.getCommand("ollamachat").setExecutor((CommandExecutor)new OllamaChatCommand(this));
        this.getCommand("ollamachat").setTabCompleter((TabCompleter)new OllamaChatTabCompleter(this));
        this.getCommand("aichat").setExecutor((CommandExecutor)new AIChatCommand(this));
        this.getCommand("aichat").setTabCompleter((TabCompleter)new OllamaChatTabCompleter(this));
    }

    public void onDisable() {
        if (this.databaseManager != null) {
            this.databaseManager.close();
        } else {
            this.getLogger().warning("DatabaseManager was null, skipping close.");
        }
        this.getServer().getOnlinePlayers().forEach(this.progressManager::cleanup);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public ChatHistoryManager getChatHistoryManager() {
        return this.chatHistoryManager;
    }

    public ProgressManager getProgressManager() {
        return this.progressManager;
    }
}

