/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat.core;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.ollamachat.core.Ollamachat;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final Ollamachat plugin;
    private final Gson gson;
    private JsonObject langConfig;
    private String ollamaApiUrl;
    private String ollamaModel;
    private List<String> triggerPrefixes;
    private int maxResponseLength;
    private Map<String, AIConfig> otherAIConfigs;
    private boolean ollamaEnabled;
    private Map<String, Boolean> otherAIEnabled;
    private boolean streamingEnabled;
    private String defaultPrompt;
    private Map<String, String> prompts;
    private Map<UUID, Map<String, String>> selectedConversations;
    private int maxHistory;
    private List<String> suggestedResponseModels;
    private boolean suggestedResponsesEnabled;

    public ConfigManager(Ollamachat plugin) {
        this.plugin = plugin;
        this.gson = new Gson();
        this.selectedConversations = new HashMap<UUID, Map<String, String>>();
    }

    public void initialize() {
        this.plugin.saveDefaultConfig();
        this.reloadConfigValues();
        this.loadLanguageFile(this.plugin.getConfig().getString("language", "en_us"));
    }

    private void updateConfig() {
        FileConfiguration config = this.plugin.getConfig();
        if (!config.contains("ollama-enabled")) {
            config.set("ollama-enabled", (Object)true);
        }
        if (!config.contains("language")) {
            config.set("language", (Object)"en");
        }
        if (!config.contains("other-ai-configs")) {
            config.createSection("other-ai-configs");
        }
        if (!config.contains("max-history")) {
            config.set("max-history", (Object)5);
        }
        if (!config.contains("stream-settings")) {
            config.set("stream-settings.enabled", (Object)true);
        }
        if (!config.contains("prompts")) {
            config.createSection("prompts");
        }
        if (!config.contains("default-prompt")) {
            config.set("default-prompt", (Object)"");
        }
        if (!config.contains("trigger-prefixes")) {
            config.set("trigger-prefixes", Arrays.asList("@bot", "@ai", "/chat"));
        }
        if (!config.contains("suggested-response-models")) {
            config.set("suggested-response-models", Arrays.asList("llama3", "mistral"));
        }
        if (!config.contains("suggested-responses-enabled")) {
            config.set("suggested-responses-enabled", (Object)true);
        }
        this.plugin.saveConfig();
    }

    public void reloadConfigValues() {
        YamlConfiguration config;
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.plugin.saveDefaultConfig();
        } else {
            try {
                config = YamlConfiguration.loadConfiguration((File)configFile);
                if (!config.contains("ollama-api-url") || !config.contains("model")) {
                    this.plugin.getLogger().warning(this.getMessage("config-invalid", null));
                    configFile.delete();
                    this.plugin.saveDefaultConfig();
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe(this.getMessage("config-load-failed", Map.of("error", e.getMessage())));
                configFile.delete();
                this.plugin.saveDefaultConfig();
            }
        }
        this.plugin.reloadConfig();
        this.updateConfig();
        config = this.plugin.getConfig();
        this.ollamaApiUrl = config.getString("ollama-api-url", "http://localhost:11434/api/generate");
        this.ollamaModel = config.getString("model", "llama3");
        this.triggerPrefixes = config.getStringList("trigger-prefixes");
        this.maxResponseLength = config.getInt("max-response-length", 500);
        this.ollamaEnabled = config.getBoolean("ollama-enabled", true);
        this.maxHistory = config.getInt("max-history", 5);
        this.streamingEnabled = config.getBoolean("stream-settings.enabled", true);
        this.defaultPrompt = config.getString("default-prompt", "");
        this.suggestedResponseModels = config.getStringList("suggested-response-models");
        this.suggestedResponsesEnabled = config.getBoolean("suggested-responses-enabled", true);
        this.prompts = new HashMap<String, String>();
        if (config.contains("prompts")) {
            for (String promptName : config.getConfigurationSection("prompts").getKeys(false)) {
                String promptContent = config.getString("prompts." + promptName);
                this.prompts.put(promptName, promptContent);
            }
        }
        this.otherAIConfigs = new HashMap<String, AIConfig>();
        this.otherAIEnabled = new HashMap<String, Boolean>();
        if (config.contains("other-ai-configs")) {
            for (String aiName : config.getConfigurationSection("other-ai-configs").getKeys(false)) {
                String apiUrl = config.getString("other-ai-configs." + aiName + ".api-url");
                String apiKey = config.getString("other-ai-configs." + aiName + ".api-key");
                String model = config.getString("other-ai-configs." + aiName + ".model");
                boolean enabled = config.getBoolean("other-ai-configs." + aiName + ".enabled", true);
                boolean isMessagesFormat = config.getBoolean("other-ai-configs." + aiName + ".messages-format", false);
                this.otherAIConfigs.put(aiName, new AIConfig(apiUrl, apiKey, model, isMessagesFormat));
                this.otherAIEnabled.put(aiName, enabled);
            }
        }
    }

    private void loadLanguageFile(String language) {
        File langFile;
        File langFolder = new File(this.plugin.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        if (!(langFile = new File(langFolder, language + ".json")).exists()) {
            this.plugin.saveResource("lang/" + language + ".json", false);
        }
        try (FileReader reader = new FileReader(langFile);){
            this.langConfig = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
            if (this.langConfig == null) {
                this.langConfig = new JsonObject();
                this.plugin.getLogger().warning("Language file is empty or invalid: " + langFile.getName());
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to load language file: " + langFile.getName() + " - " + e.getMessage());
            this.langConfig = new JsonObject();
        }
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        Object message;
        Object object = message = this.langConfig != null && this.langConfig.has(key) ? this.langConfig.get(key).getAsString() : "\u00a7c[OllamaChat] Missing language key: " + key;
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = ((String)message).replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return message;
    }

    public String getOllamaApiUrl() {
        return this.ollamaApiUrl;
    }

    public String getOllamaModel() {
        return this.ollamaModel;
    }

    public List<String> getTriggerPrefixes() {
        return this.triggerPrefixes;
    }

    public int getMaxResponseLength() {
        return this.maxResponseLength;
    }

    public Map<String, AIConfig> getOtherAIConfigs() {
        return this.otherAIConfigs;
    }

    public boolean isOllamaEnabled() {
        return this.ollamaEnabled;
    }

    public void setOllamaEnabled(boolean enabled) {
        this.ollamaEnabled = enabled;
    }

    public Map<String, Boolean> getOtherAIEnabled() {
        return this.otherAIEnabled;
    }

    public boolean isStreamingEnabled() {
        return this.streamingEnabled;
    }

    public String getDefaultPrompt() {
        return this.defaultPrompt;
    }

    public void setDefaultPrompt(String prompt) {
        this.defaultPrompt = prompt;
    }

    public Map<String, String> getPrompts() {
        return this.prompts;
    }

    public Map<UUID, Map<String, String>> getSelectedConversations() {
        return this.selectedConversations;
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public List<String> getSuggestedResponseModels() {
        return this.suggestedResponseModels;
    }

    public boolean isSuggestedResponsesEnabled() {
        return this.suggestedResponsesEnabled;
    }

    public static class AIConfig {
        private final String apiUrl;
        private final String apiKey;
        private final String model;
        private final boolean isMessagesFormat;

        public AIConfig(String apiUrl, String apiKey, String model, boolean isMessagesFormat) {
            this.apiUrl = apiUrl;
            this.apiKey = apiKey;
            this.model = model;
            this.isMessagesFormat = isMessagesFormat;
        }

        public String getApiUrl() {
            return this.apiUrl;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public String getModel() {
            return this.model;
        }

        public boolean isMessagesFormat() {
            return this.isMessagesFormat;
        }
    }
}

