/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat.command;

import com.ollamachat.core.ConfigManager;
import com.ollamachat.core.Ollamachat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class OllamaChatTabCompleter
implements TabCompleter {
    private final Ollamachat plugin;
    private final ConfigManager configManager;

    public OllamaChatTabCompleter(Ollamachat plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("ollamachat")) {
            if (args.length == 1) {
                ArrayList<String> subCommands = new ArrayList<String>();
                if (sender.hasPermission("ollamachat.reload")) {
                    subCommands.add("reload");
                }
                if (sender.hasPermission("ollamachat.toggle")) {
                    subCommands.add("toggle");
                }
                if (sender.hasPermission("ollamachat.prompt.set") || sender.hasPermission("ollamachat.prompt.delete") || sender.hasPermission("ollamachat.prompt.list") || sender.hasPermission("ollamachat.prompt.select")) {
                    subCommands.add("prompt");
                }
                if (sender instanceof Player && (sender.hasPermission("ollamachat.conversation.new") || sender.hasPermission("ollamachat.conversation.select") || sender.hasPermission("ollamachat.conversation.delete") || sender.hasPermission("ollamachat.conversation.list"))) {
                    subCommands.add("conversation");
                }
                return this.filterCompletions(subCommands, args[0]);
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("toggle") && sender.hasPermission("ollamachat.toggle")) {
                ArrayList<String> aiNames = new ArrayList<String>();
                aiNames.add("ollama");
                aiNames.addAll(this.configManager.getOtherAIConfigs().keySet());
                return this.filterCompletions(aiNames, args[1]);
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("prompt") && (sender.hasPermission("ollamachat.prompt.set") || sender.hasPermission("ollamachat.prompt.delete") || sender.hasPermission("ollamachat.prompt.list") || sender.hasPermission("ollamachat.prompt.select"))) {
                ArrayList<String> promptSubCommands = new ArrayList<String>();
                if (sender.hasPermission("ollamachat.prompt.set")) {
                    promptSubCommands.add("set");
                }
                if (sender.hasPermission("ollamachat.prompt.delete")) {
                    promptSubCommands.add("delete");
                }
                if (sender.hasPermission("ollamachat.prompt.list")) {
                    promptSubCommands.add("list");
                }
                if (sender.hasPermission("ollamachat.prompt.select")) {
                    promptSubCommands.add("select");
                    promptSubCommands.add("clear");
                }
                return this.filterCompletions(promptSubCommands, args[1]);
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("prompt") && (args[1].equalsIgnoreCase("delete") || args[1].equalsIgnoreCase("select")) && (sender.hasPermission("ollamachat.prompt.delete") || sender.hasPermission("ollamachat.prompt.select"))) {
                return this.filterCompletions(new ArrayList<String>(this.configManager.getPrompts().keySet()), args[2]);
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("conversation") && sender instanceof Player && (sender.hasPermission("ollamachat.conversation.new") || sender.hasPermission("ollamachat.conversation.select") || sender.hasPermission("ollamachat.conversation.delete") || sender.hasPermission("ollamachat.conversation.list"))) {
                ArrayList<String> convSubCommands = new ArrayList<String>();
                if (sender.hasPermission("ollamachat.conversation.new")) {
                    convSubCommands.add("new");
                }
                if (sender.hasPermission("ollamachat.conversation.select")) {
                    convSubCommands.add("select");
                }
                if (sender.hasPermission("ollamachat.conversation.delete")) {
                    convSubCommands.add("delete");
                }
                if (sender.hasPermission("ollamachat.conversation.list")) {
                    convSubCommands.add("list");
                }
                return this.filterCompletions(convSubCommands, args[1]);
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("conversation") && sender instanceof Player) {
                ArrayList<String> aiNames = new ArrayList<String>();
                aiNames.add("ollama");
                aiNames.addAll(this.configManager.getOtherAIConfigs().keySet());
                return this.filterCompletions(aiNames, args[2]);
            }
            if (args.length == 4 && args[0].equalsIgnoreCase("conversation") && (args[1].equalsIgnoreCase("select") || args[1].equalsIgnoreCase("delete")) && sender instanceof Player && (sender.hasPermission("ollamachat.conversation.select") || sender.hasPermission("ollamachat.conversation.delete"))) {
                String aiName = args[2];
                Map<String, String> conversations = this.plugin.getChatHistoryManager().listConversations(((Player)sender).getUniqueId(), aiName);
                return this.filterCompletions(new ArrayList<String>(conversations.values()), args[3]);
            }
        } else if (command.getName().equalsIgnoreCase("aichat") && sender.hasPermission("ollamachat.use") && args.length == 1) {
            ArrayList<String> aiNames = new ArrayList<String>();
            aiNames.add("ollama");
            aiNames.addAll(this.configManager.getOtherAIConfigs().keySet());
            return this.filterCompletions(aiNames, args[0]);
        }
        return completions;
    }

    private List<String> filterCompletions(List<String> options, String input) {
        return options.stream().filter(option -> option.toLowerCase().startsWith(input.toLowerCase())).collect(Collectors.toList());
    }
}

