/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat.chat;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.ollamachat.AIService;
import com.ollamachat.core.ConfigManager;
import com.ollamachat.core.Ollamachat;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;

public class SuggestedResponseHandler {
    private final Ollamachat plugin;
    private final ConfigManager configManager;
    private final AIService aiService;
    private final Gson gson;

    public SuggestedResponseHandler(Ollamachat plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.aiService = new AIService();
        this.gson = new Gson();
    }

    public void sendSuggestedResponses(Player player, String originalAIName, String originalPrompt, String originalResponse) {
        if (!this.configManager.isSuggestedResponsesEnabled()) {
            return;
        }
        List<String> suggestedModels = this.configManager.getSuggestedResponseModels();
        if (suggestedModels.isEmpty()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            ArrayList<CallSite> suggestedResponses = new ArrayList<CallSite>();
            for (String string : suggestedModels) {
                if (string.equalsIgnoreCase(originalAIName)) continue;
                try {
                    String[] suggestions;
                    String suggestedText;
                    boolean isMessagesFormat;
                    String apiKey;
                    String apiUrl;
                    ConfigManager.AIConfig aiConfig = this.configManager.getOtherAIConfigs().get(string);
                    if (aiConfig != null && this.configManager.getOtherAIEnabled().getOrDefault(string, false).booleanValue()) {
                        apiUrl = aiConfig.getApiUrl();
                        apiKey = aiConfig.getApiKey();
                        isMessagesFormat = aiConfig.isMessagesFormat();
                    } else {
                        apiUrl = this.configManager.getOllamaApiUrl();
                        apiKey = null;
                        isMessagesFormat = false;
                    }
                    String context = "Conversation:\nUser: " + originalPrompt + "\nAI: " + originalResponse + "\n\nBased on the above conversation, suggest 3 follow-up questions or prompts the user might want to ask. List them as:\n1. Question 1\n2. Question 2\n3. Question 3";
                    String responseBody = this.aiService.sendRequest(apiUrl, apiKey, string, context, isMessagesFormat).join();
                    if (isMessagesFormat) {
                        json = (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
                        suggestedText = json.getAsJsonArray("choices").get(0).getAsJsonObject().get("message").getAsJsonObject().get("content").getAsString();
                    } else {
                        json = (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
                        suggestedText = json.get("response").getAsString();
                    }
                    for (String suggestion : suggestions = suggestedText.split("\n")) {
                        String cleanedSuggestion = suggestion.replaceAll("^\\d+\\.\\s*", "").trim();
                        if (cleanedSuggestion.isEmpty()) continue;
                        suggestedResponses.add((CallSite)((Object)("[" + string + "] " + cleanedSuggestion)));
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to get suggested response from " + string + ": " + e.getMessage());
                }
            }
            if (player.isOnline() && !suggestedResponses.isEmpty()) {
                player.sendMessage((Component)Component.text((String)this.configManager.getMessage("suggested-responses-header", null), (TextColor)NamedTextColor.GREEN));
                for (String string : suggestedResponses) {
                    void var8_12;
                    if (string.length() > this.configManager.getMaxResponseLength()) {
                        String string2 = string.substring(0, this.configManager.getMaxResponseLength()) + "...";
                        player.sendMessage((Component)Component.text((String)this.configManager.getMessage("response-truncated", null), (TextColor)NamedTextColor.YELLOW));
                    }
                    String prefix = this.configManager.getMessage("suggested-response-prefix", null);
                    String command = "/aichat " + originalAIName + " " + var8_12.replace("\"", "\\\"");
                    Component message = ((TextComponent)Component.text((String)(prefix + (String)var8_12)).color((TextColor)NamedTextColor.WHITE)).clickEvent(ClickEvent.runCommand((String)command));
                    player.sendMessage(message);
                }
            }
        });
    }
}

