/*
 * Decompiled with CFR 0.152.
 */
package com.ollamachat;

import com.ollamachat.DatabaseManager;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class ChatHistoryManager {
    private final DatabaseManager databaseManager;
    private final int maxHistory;

    public ChatHistoryManager(DatabaseManager databaseManager, int maxHistory) {
        this.databaseManager = databaseManager;
        this.maxHistory = maxHistory;
    }

    public void savePlayerInfo(Player player) {
        this.databaseManager.savePlayerInfo(player.getUniqueId(), player.getName());
    }

    public String createConversation(UUID playerUuid, String aiModel, String convName) {
        return this.databaseManager.createConversation(playerUuid, aiModel, convName);
    }

    public boolean conversationExistsByName(UUID playerUuid, String aiModel, String convName) {
        return this.databaseManager.conversationExistsByName(playerUuid, aiModel, convName);
    }

    public String getConversationId(UUID playerUuid, String aiModel, String convName) {
        return this.databaseManager.getConversationId(playerUuid, aiModel, convName);
    }

    public boolean conversationExists(UUID playerUuid, String aiModel, String convId) {
        return this.databaseManager.conversationExists(playerUuid, aiModel, convId);
    }

    public boolean deleteConversation(UUID playerUuid, String aiModel, String convId) {
        return this.databaseManager.deleteConversation(playerUuid, aiModel, convId);
    }

    public Map<String, String> listConversations(UUID playerUuid, String aiModel) {
        return this.databaseManager.listConversations(playerUuid, aiModel);
    }

    public void saveChatHistory(UUID playerUuid, String aiModel, String conversationId, String prompt, String response) {
        this.databaseManager.saveChatHistory(playerUuid, aiModel, conversationId, prompt, response);
    }

    public String getChatHistory(UUID playerUuid, String aiModel, String conversationId) {
        return this.databaseManager.getChatHistory(playerUuid, aiModel, conversationId, this.maxHistory);
    }
}

