/*
 * Decompiled with CFR 0.152.
 */
package ru.xordev.stopAndCheck.handlers;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.xordev.stopAndCheck.Utils;

public class CheckerEventHandler
implements Listener {
    private final JavaPlugin plugin;
    private final Utils utils;

    public CheckerEventHandler(JavaPlugin plugin, Utils utils) {
        this.plugin = plugin;
        this.utils = utils;
    }

    @EventHandler
    public void checkPlayerMove(PlayerMoveEvent e) {
        Player player = e.getPlayer();
        if (this.isPlayerOnCheck(player)) {
            player.setAllowFlight(true);
            player.setFlying(false);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void checkPlayerCommand(PlayerCommandPreprocessEvent e) {
        Player player = e.getPlayer();
        if (this.isPlayerOnCheck(player)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void checkPlayerDropItem(PlayerDropItemEvent e) {
        Player player = e.getPlayer();
        if (this.isPlayerOnCheck(player)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void checkPlayerBreakBlock(BlockBreakEvent e) {
        Player player = e.getPlayer();
        if (this.isPlayerOnCheck(player)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void checkPlayerDamage(EntityDamageEvent e) {
        Player player;
        Entity entity = e.getEntity();
        if (entity instanceof Player && this.isPlayerOnCheck(player = (Player)entity)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void checkPlayerAttack(EntityDamageByEntityEvent e) {
        Player player;
        Player damager;
        Entity entity = e.getDamager();
        if (entity instanceof Player && this.isPlayerOnCheck(damager = (Player)entity)) {
            e.setCancelled(true);
            return;
        }
        entity = e.getEntity();
        if (entity instanceof Player && this.isPlayerOnCheck(player = (Player)entity)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void checkPlayerUseItem(PlayerInteractEvent e) {
        Material itemType;
        Player player = e.getPlayer();
        if (!(!this.isPlayerOnCheck(player) || e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_BLOCK || (itemType = player.getInventory().getItemInMainHand().getType()) != Material.EGG && itemType != Material.SNOWBALL && itemType != Material.ENDER_PEARL && itemType != Material.SPLASH_POTION)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void checkPlayerChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        if (this.isPlayerOnCheck(player)) {
            String text = e.getMessage();
            UUID mod_uuid = UUID.fromString(((MetadataValue)player.getMetadata("sac_check_moderator").get(0)).asString());
            Player moderator = this.plugin.getServer().getPlayer(mod_uuid);
            e.setCancelled(true);
            String playerMsg = this.utils.get_str("messages.check-chat-tag", player, null) + "&7" + player.getName() + ": &r" + text;
            String targetMsg = this.utils.get_str("messages.you-tag", player, null) + this.utils.get_str("messages.check-chat-tag", player, null) + " " + text;
            moderator.sendMessage(this.utils.color(playerMsg));
            player.sendMessage(this.utils.color(targetMsg));
        } else if (player.hasMetadata("sac_check_player")) {
            String text = e.getMessage();
            UUID ply_uuid = UUID.fromString(((MetadataValue)player.getMetadata("sac_check_player").get(0)).asString());
            Player ply = this.plugin.getServer().getPlayer(ply_uuid);
            e.setCancelled(true);
            String playerMsg = this.utils.get_str("messages.check-chat-tag", player, null) + "&7" + player.getName() + ": &r" + text;
            String targetMsg = this.utils.get_str("messages.you-tag", player, null) + this.utils.get_str("messages.check-chat-tag", player, null) + " " + text;
            ply.sendMessage(this.utils.color(playerMsg));
            player.sendMessage(this.utils.color(targetMsg));
        }
    }

    private void executeBan(Player player, Player mod) {
        try {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.utils.get_str("check.on-disconnect.command", mod, player));
            this.plugin.getLogger().info(player.getName() + " leaved from check");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning(e.getMessage());
        }
    }

    @EventHandler
    public void playerLeave(PlayerQuitEvent e) {
        Player quited_player = e.getPlayer();
        if (this.isPlayerOnCheck(quited_player)) {
            if (this.plugin.getConfig().getBoolean("check.on-disconnect.enabled", true)) {
                quited_player.sendTitle("", "", 0, 0, 10);
                quited_player.removeMetadata("sac_oncheck", (Plugin)this.plugin);
                UUID mod_uuid = UUID.fromString(((MetadataValue)quited_player.getMetadata("sac_check_moderator").get(0)).asString());
                Player moderator = this.plugin.getServer().getPlayer(mod_uuid);
                quited_player.removeMetadata("sac_check_moderator", (Plugin)this.plugin);
                quited_player.removeMetadata("sac_beforecheck_pos", (Plugin)this.plugin);
                this.executeBan(quited_player, moderator);
            }
        } else if (quited_player.hasMetadata("sac_check_player") && ((MetadataValue)quited_player.getMetadata("sac_check_player").get(0)).asString() != "") {
            UUID moder_player_uuid = UUID.fromString(((MetadataValue)quited_player.getMetadata("sac_check_player").get(0)).asString());
            Player player = this.plugin.getServer().getPlayer(moder_player_uuid);
            if (Objects.equals(quited_player.getUniqueId().toString(), moder_player_uuid.toString())) {
                return;
            }
            if (this.isPlayerOnCheck(Objects.requireNonNull(player))) {
                this.releasePlayer(player, quited_player);
            }
        }
    }

    private boolean isPlayerOnCheck(Player player) {
        if (!player.hasMetadata("sac_oncheck")) {
            return false;
        }
        try {
            List metadata = player.getMetadata("sac_oncheck");
            if (metadata.isEmpty()) {
                return false;
            }
            return ((MetadataValue)metadata.get(0)).asBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void releasePlayer(Player player, Player moderator) {
        player.removeMetadata("sac_oncheck", (Plugin)this.plugin);
        player.removeMetadata("sac_check_moderator", (Plugin)this.plugin);
        moderator.removeMetadata("sac_check_player", (Plugin)this.plugin);
        player.sendTitle("", "", 0, 0, 10);
        player.sendMessage(this.utils.get_str("messages.player.free-msg", moderator, player));
    }
}

