/*
 * Decompiled with CFR 0.152.
 */
package ru.xordev.stopAndCheck.commands;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.xordev.stopAndCheck.Utils;

public class CheckerCommand
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private final Utils utils;

    public CheckerCommand(JavaPlugin plugin) {
        this.plugin = plugin;
        this.utils = new Utils(plugin);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        Player sender = commandSender instanceof Player ? (Player)commandSender : null;
        if (sender != null && !sender.hasPermission("sac.command")) {
            sender.sendMessage(this.utils.get_str("messages.moderator.no-permission", sender, null));
            return true;
        }
        if (strings.length == 0 || strings[0].equalsIgnoreCase("help")) {
            this.send_help((CommandSender)sender);
            return true;
        }
        if (strings[0].equalsIgnoreCase("check")) {
            if (!(commandSender instanceof Player)) {
                this.plugin.getServer().getLogger().log(Level.INFO, "Console can't check player!");
                return true;
            }
            if (!sender.hasPermission("sac.moder.check")) {
                sender.sendMessage(this.utils.get_str("messages.moderator.no-permission", sender, null));
                return true;
            }
            if (strings.length < 2) {
                sender.sendMessage(this.utils.get_str("messages.usage", sender, null) + " /sac check <player>");
                return true;
            }
            String playername = strings[1];
            Player player = this.plugin.getServer().getPlayer(playername);
            if (player == null) {
                sender.sendMessage(this.utils.get_str("messages.moderator.player-offline", sender, null));
                return true;
            }
            if (player == sender) {
                sender.sendMessage(this.utils.get_str("messages.moderator.self-check", sender, player));
                return true;
            }
            if (player.hasMetadata("sac_check_player")) {
                sender.sendMessage(this.utils.get_str("messages.moderator.is-checking", player, sender));
                return true;
            }
            if (this.isPlayerOnCheck(player)) {
                sender.sendMessage(this.utils.get_str("messages.moderator.already-check", sender, player));
                return true;
            }
            if (player.hasPermission("sac.immunity")) {
                sender.sendMessage(this.utils.get_str("messages.moderator.player-has-perm", sender, player));
                return true;
            }
            player.setMetadata("sac_oncheck", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            player.setMetadata("sac_check_moderator", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)sender.getUniqueId().toString()));
            sender.setMetadata("sac_check_player", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getUniqueId().toString()));
            String title = this.utils.get_str("messages.player.check-title", sender, player);
            String subtitle = this.utils.get_str("messages.player.check-subtitle", sender, player);
            if (this.plugin.getConfig().getBoolean("check.teleport.enabled")) {
                player.setMetadata("sac_beforecheck_pos", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getLocation()));
                String coords = this.plugin.getConfig().getString("check.teleport.coordinates", "0 0 0 0 0");
                String wrld = this.plugin.getConfig().getString("check.teleport.world", "world");
                Location loc = this.utils.parse_location(coords, wrld, " ");
                sender.setMetadata("sac_beforecheck_pos", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)sender.getLocation()));
                player.teleport(loc);
                sender.teleport(loc);
            }
            player.sendTitle(title, subtitle, 10, 999999, 0);
            List<String> instructions = this.utils.get_str_list("messages.player.check-chatmsg", sender, player);
            instructions.forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
            sender.sendMessage(this.utils.get_str("messages.moderator.successful-called", sender, player));
            return true;
        }
        if (strings[0].equalsIgnoreCase("free")) {
            if (sender != null && !sender.hasPermission("sac.moder.free")) {
                sender.sendMessage(this.utils.get_str("messages.moderator.no-permission", null, null));
                return true;
            }
            if (strings.length < 2) {
                this.utils.sendMessage(commandSender, this.utils.get_str("messages.usage", sender, null) + " /sac free <player>");
                return true;
            }
            String playername = strings[1];
            Player player = this.plugin.getServer().getPlayer(playername);
            if (player == null) {
                this.utils.sendMessage(commandSender, this.utils.get_str("messages.moderator.player-offline", sender, null));
                return true;
            }
            if (player == sender) {
                this.utils.sendMessage(commandSender, this.utils.get_str("messages.moderator.self-free", sender, player));
                return true;
            }
            if (!this.isPlayerOnCheck(player)) {
                this.utils.sendMessage(commandSender, this.utils.get_str("messages.moderator.already-free", sender, player));
                return true;
            }
            player.removeMetadata("sac_oncheck", (Plugin)this.plugin);
            UUID playerModeratorUuid = UUID.fromString(((MetadataValue)player.getMetadata("sac_check_moderator").get(0)).asString());
            player.removeMetadata("sac_check_moderator", (Plugin)this.plugin);
            Player playerModerator = this.plugin.getServer().getPlayer(playerModeratorUuid);
            playerModerator.removeMetadata("sac_check_player", (Plugin)this.plugin);
            player.setAllowFlight(false);
            if (this.plugin.getConfig().getBoolean("check.teleport.enabled")) {
                Location oldPos = (Location)((MetadataValue)player.getMetadata("sac_beforecheck_pos").get(0)).value();
                Location oldModPos = (Location)((MetadataValue)Objects.requireNonNull(sender).getMetadata("sac_beforecheck_pos").get(0)).value();
                player.removeMetadata("sac_beforecheck_pos", (Plugin)this.plugin);
                sender.removeMetadata("sac_beforecheck_pos", (Plugin)this.plugin);
                player.teleport(oldPos);
                sender.teleport(oldModPos);
            }
            player.sendTitle("", "", 0, 0, 10);
            player.sendMessage(this.utils.get_str("messages.player.free-msg", sender, player));
            this.utils.sendMessage(commandSender, this.utils.get_str("messages.moderator.successful-free", sender, player));
            return true;
        }
        if (strings[0].equalsIgnoreCase("reload")) {
            if (!(commandSender instanceof ConsoleCommandSender) && !sender.hasPermission("sac.moder.reload")) {
                sender.sendMessage(this.utils.get_str("messages.moderator.no-permission", sender, null));
                return true;
            }
            try {
                this.plugin.reloadConfig();
                if (commandSender instanceof ConsoleCommandSender) {
                    this.plugin.getLogger().log(Level.INFO, "[StopAndCheck] Successful config reload");
                    return true;
                }
                sender.sendMessage(this.utils.get_str("messages.cfg-reload", sender, null));
                return true;
            }
            catch (Exception err) {
                if (commandSender instanceof ConsoleCommandSender) {
                    this.plugin.getLogger().log(Level.SEVERE, "[StopAndCheck] Error when reloading plugin!");
                    this.plugin.getLogger().log(Level.SEVERE, err.getMessage());
                    return true;
                }
                sender.sendMessage(this.utils.color("&c&lError when reloading plugin: &7" + err.getMessage()));
                return true;
            }
        }
        if (!strings[0].equalsIgnoreCase("info")) {
            this.send_help(commandSender);
            return true;
        }
        if (sender != null && !sender.hasPermission("sac.moder.free")) {
            sender.sendMessage(this.utils.get_str("messages.moderator.no-permission", sender, null));
            return true;
        }
        if (strings.length < 2) {
            this.utils.sendMessage(commandSender, this.utils.get_str("messages.usage", sender, null) + " /sac info <player>");
            return true;
        }
        String playername = strings[1];
        Player player = this.plugin.getServer().getPlayer(playername);
        if (player == null) {
            this.utils.sendMessage(commandSender, this.utils.get_str("messages.moderator.player-offline", sender, null));
            return true;
        }
        List<String> lines = this.utils.get_str_list("messages.moderator.info", sender, player);
        String status = this.plugin.getConfig().getString("messages.moderator.status-free", "Free");
        String checking_player = this.plugin.getConfig().getString("messages.moderator.no", "&7No");
        String checking_moderator = this.plugin.getConfig().getString("messages.moderator.no", "&7No");
        if (player.hasMetadata("sac_oncheck") && ((MetadataValue)player.getMetadata("sac_oncheck").get(0)).asBoolean()) {
            status = this.plugin.getConfig().getString("messages.moderator.status-oncheck", "On check");
            UUID mod_uuid = UUID.fromString(((MetadataValue)player.getMetadata("sac_check_moderator").get(0)).asString());
            checking_moderator = Objects.requireNonNull(this.plugin.getServer().getPlayer(mod_uuid)).getName();
            checking_player = this.plugin.getConfig().getString("messages.moderator.no", "&7No");
        } else if (player.hasMetadata("sac_oncheck") && !((MetadataValue)player.getMetadata("sac_oncheck").get(0)).asBoolean()) {
            status = this.plugin.getConfig().getString("messages.moderator.status-free", "Free");
            checking_moderator = this.plugin.getConfig().getString("messages.moderator.no", "&7No");
            checking_player = this.plugin.getConfig().getString("messages.moderator.no", "&7No");
        }
        if (player.hasMetadata("sac_check_player") && !((MetadataValue)player.getMetadata("sac_cheking_player").get(0)).asString().isEmpty()) {
            status = this.plugin.getConfig().getString("messages.moderator.status-checking", "Checking");
            checking_moderator = this.plugin.getConfig().getString("messages.moderator.no", "&7No");
            UUID ply_uuid = UUID.fromString(((MetadataValue)player.getMetadata("sac_check_player").get(0)).asString());
            checking_player = Objects.requireNonNull(this.plugin.getServer().getPlayer(ply_uuid)).getName();
        }
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next();
            String fline = this.utils.color(line.replace("{info_status}", status).replace("{checking_player}", checking_player).replace("{checking_moderator}", checking_moderator));
            this.utils.sendMessage(commandSender, fline);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (strings.length == 1) {
            return Stream.of("check", "free", "info", "reload", "help").filter(action -> action.startsWith(strings[0].toLowerCase())).collect(Collectors.toList());
        }
        if (strings.length == 2) {
            Set<String> commands_with_players = Set.of("check", "free", "info");
            if (commands_with_players.contains(strings[0].toLowerCase())) {
                return null;
            }
            return List.of();
        }
        return List.of();
    }

    private void send_help(CommandSender sender) {
        Player player = sender instanceof Player ? (Player)sender : null;
        List<String> help_text = this.utils.get_str_list("messages.player.help", player, null);
        for (String line : help_text) {
            this.utils.sendMessage(sender, line);
        }
    }

    private boolean isPlayerOnCheck(Player player) {
        if (!player.hasMetadata("sac_oncheck")) {
            return false;
        }
        try {
            List metadata = player.getMetadata("sac_oncheck");
            if (metadata.isEmpty()) {
                return false;
            }
            return ((MetadataValue)metadata.get(0)).asBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }
}

