/*
 * Decompiled with CFR 0.152.
 */
package ru.xordev.stopAndCheck.handlers;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.xordev.stopAndCheck.Utils;

public class CheckerEventHandler
implements Listener {
    private final JavaPlugin plugin;

    public CheckerEventHandler(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void checkPlayerMove(PlayerMoveEvent e) {
        Player player = e.getPlayer();
        if (this.isPlayerOnCheck(player) && !this.plugin.getConfig().getBoolean("check.can-move")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void checkPlayerCommand(PlayerCommandPreprocessEvent e) {
        Player player = e.getPlayer();
        if (this.isPlayerOnCheck(player) && !this.plugin.getConfig().getBoolean("check.can-command")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void checkPlayerDropItem(PlayerDropItemEvent e) {
        Player player = e.getPlayer();
        if (this.isPlayerOnCheck(player) && !this.plugin.getConfig().getBoolean("check.can-drop-items")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void checkPlayerChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        if (this.isPlayerOnCheck(player)) {
            String text = e.getMessage();
            UUID mod_uuid = UUID.fromString(((MetadataValue)player.getMetadata("sac_check_moderator").get(0)).asString());
            Player moderator = this.plugin.getServer().getPlayer(mod_uuid);
            e.setCancelled(true);
            String playerMsg = Utils.color(this.plugin.getConfig().getString("messages.check-chat-tag") + "&7" + player.getName() + " ") + text;
            String targetMsg = Utils.color(this.plugin.getConfig().getString("messages.you-tag") + this.plugin.getConfig().getString("messages.check-chat-tag")) + text;
            moderator.sendMessage(playerMsg);
            player.sendMessage(targetMsg);
        } else if (player.hasMetadata("sac_check_player") && ((MetadataValue)player.getMetadata("sac_check_player").get(0)).value() != null) {
            String text = e.getMessage();
            UUID ply_uuid = UUID.fromString(((MetadataValue)player.getMetadata("sac_check_player").get(0)).asString());
            Player ply = this.plugin.getServer().getPlayer(ply_uuid);
            e.setCancelled(true);
            String playerMsg = Utils.color(this.plugin.getConfig().getString("messages.check-chat-tag") + "&7" + player.getName() + ": ") + text;
            String targetMsg = Utils.color(this.plugin.getConfig().getString("messages.you-tag") + this.plugin.getConfig().getString("messages.check-chat-tag")) + text;
            ply.sendMessage(playerMsg);
            player.sendMessage(targetMsg);
        }
    }

    private void executeBan(Player player) {
        try {
            String command = this.plugin.getConfig().getString("check.on-disconnect.command", "ban {player} 30d \u0423\u0445\u043e\u0434 \u0441 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438");
            String finalCommand = command.replace("{player}", player.getName());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand);
            this.plugin.getLogger().info(player.getName() + " leaved from check");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning(e.getMessage());
        }
    }

    @EventHandler
    public void playerLeave(PlayerQuitEvent e) {
        Player quited_player = e.getPlayer();
        if (this.isPlayerOnCheck(quited_player)) {
            if (this.plugin.getConfig().getBoolean("check.on-disconnect.enabled", true)) {
                quited_player.removeMetadata("sac_oncheck", (Plugin)this.plugin);
                quited_player.removeMetadata("sac_check_moderator", (Plugin)this.plugin);
                quited_player.removeMetadata("sac_beforecheck_pos", (Plugin)this.plugin);
                quited_player.sendTitle("", "", 0, 0, 10);
                this.executeBan(quited_player);
            }
        } else if (quited_player.hasMetadata("sac_check_player") && ((MetadataValue)quited_player.getMetadata("sac_check_player").get(0)).asString() != "") {
            UUID moder_player_uuid = UUID.fromString(((MetadataValue)quited_player.getMetadata("sac_check_player").get(0)).asString());
            Player player = this.plugin.getServer().getPlayer(moder_player_uuid);
            if (Objects.equals(quited_player.getUniqueId().toString(), moder_player_uuid.toString())) {
                return;
            }
            if (this.isPlayerOnCheck(player)) {
                this.releasePlayer(player, quited_player);
            }
        }
    }

    private boolean isPlayerOnCheck(Player player) {
        if (!player.hasMetadata("sac_oncheck")) {
            return false;
        }
        try {
            List metadata = player.getMetadata("sac_oncheck");
            if (metadata.isEmpty()) {
                return false;
            }
            return ((MetadataValue)metadata.get(0)).asBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void releasePlayer(Player player, Player moderator) {
        player.removeMetadata("sac_oncheck", (Plugin)this.plugin);
        player.removeMetadata("sac_check_moderator", (Plugin)this.plugin);
        moderator.removeMetadata("sac_check_player", (Plugin)this.plugin);
        player.sendTitle("", "", 0, 0, 10);
        player.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.player.free-msg").replace("{moderator}", moderator.getName())));
    }
}

