/*
 * Decompiled with CFR 0.152.
 */
package ru.xordev.stopAndCheck;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import ru.xordev.stopAndCheck.commands.CheckerCommand;
import ru.xordev.stopAndCheck.handlers.CheckerEventHandler;

public final class Main
extends JavaPlugin {
    public void onEnable() {
        try {
            this.saveDefaultConfig();
            PluginManager pm = this.getServer().getPluginManager();
            pm.addPermission(new Permission("sac.command", "Access to /sac command", PermissionDefault.OP));
            pm.addPermission(new Permission("sac.immunity", "Deny send player to checks", PermissionDefault.OP));
            pm.addPermission(new Permission("sac.help", "Access to /help command", PermissionDefault.OP));
            Permission moderPerm = new Permission("sac.moder.*", "Allow all moderator commands", PermissionDefault.OP);
            moderPerm.getChildren().put("sac.moder.reload", true);
            moderPerm.getChildren().put("sac.moder.check", true);
            moderPerm.getChildren().put("sac.moder.free", true);
            moderPerm.getChildren().put("sac.moder.info", true);
            pm.addPermission(moderPerm);
            pm.registerEvents((Listener)new CheckerEventHandler(this), (Plugin)this);
            this.getServer().getPluginCommand("sac").setExecutor((CommandExecutor)new CheckerCommand(this));
            this.getServer().getLogger().log(Level.INFO, " ");
            this.getServer().getLogger().log(Level.INFO, "-| StopAndCheck 1.0beta by XOR |-");
            this.getServer().getLogger().log(Level.INFO, "All releases here: https://github.com/justyXOR/StopAndCheck");
            this.getServer().getLogger().log(Level.INFO, " ");
            this.getServer().getLogger().log(Level.INFO, "Plugin is ready to work!");
            this.getServer().getLogger().log(Level.INFO, " ");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error when enabling plugin!", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        this.getLogger().info("Cleaning up metadata...");
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.removeMetadataByPrefix(player, "sac_");
            player.sendTitle("", "", 0, 0, 10);
        }
        this.getLogger().info("Cleaning up permissions...");
        this.unregisterPermissions();
        this.getLogger().info("See you next time!");
    }

    private void unregisterPermissions() {
        String[] permissionsToRemove;
        PluginManager pm = this.getServer().getPluginManager();
        for (String permName : permissionsToRemove = new String[]{"sac.command", "sac.immunity", "sac.help", "sac.moder.reload", "sac.moder.check", "sac.moder.free", "sac.moder.info", "sac.moder.*"}) {
            Permission perm = pm.getPermission(permName);
            if (perm == null) continue;
            pm.removePermission(perm);
        }
    }

    private void removeMetadataByPrefix(Player player, String prefix) {
        List metadata = player.getMetadata(prefix);
        for (MetadataValue meta : new ArrayList(player.getMetadata(prefix))) {
            if (!meta.getOwningPlugin().equals((Object)this)) continue;
            player.removeMetadata(prefix, (Plugin)this);
        }
    }
}

