/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.vanillahammers.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.item.NovaItem;
import xyz.xenondevs.nova.item.behavior.ItemBehavior;
import xyz.xenondevs.nova.item.behavior.ItemBehaviorFactory;
import xyz.xenondevs.nova.util.BlockFaceUtils;
import xyz.xenondevs.nova.util.BlockFaceUtilsKt;
import xyz.xenondevs.nova.util.BlockUtilsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.SchedulerUtilsKt;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.block.context.BlockBreakContext;
import xyz.xenondevs.nova.world.block.event.BlockBreakActionEvent;
import xyz.xenondevs.vanillahammers.item.Hammer;
import xyz.xenondevs.vanillahammers.item.options.HammerOptions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lxyz/xenondevs/vanillahammers/item/Hammer;", "Lxyz/xenondevs/nova/item/behavior/ItemBehavior;", "options", "Lxyz/xenondevs/vanillahammers/item/options/HammerOptions;", "(Lxyz/xenondevs/vanillahammers/item/options/HammerOptions;)V", "handleBlockBreakAction", "", "player", "Lorg/bukkit/entity/Player;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "event", "Lxyz/xenondevs/nova/world/block/event/BlockBreakActionEvent;", "nextAxis", "Lorg/bukkit/Axis;", "axis", "selectBlocks", "", "Lorg/bukkit/block/Block;", "middle", "face", "Lorg/bukkit/block/BlockFace;", "Companion", "vanilla_hammers"})
public final class Hammer
extends ItemBehavior {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HammerOptions options;
    @NotNull
    private static final HashMap<Player, Map<Block, Integer>> hammerWorkers = new HashMap();

    public Hammer(@NotNull HammerOptions options) {
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        this.options = options;
    }

    public void handleBlockBreakAction(@NotNull Player player, @NotNull ItemStack itemStack, @NotNull BlockBreakActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        switch (WhenMappings.$EnumSwitchMapping$0[event.getAction().ordinal()]) {
            case 1: {
                Hammer.Companion.cancelHammerWorkers(player);
                if (player.isSneaking()) {
                    return;
                }
                Location location = player.getEyeLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"player.eyeLocation");
                BlockFace blockFace = BlockFaceUtils.determineBlockFaceLookingAt$default((BlockFaceUtils)BlockFaceUtils.INSTANCE, (Location)location, (double)0.0, (int)2, null);
                if (blockFace == null) {
                    blockFace = BlockFace.NORTH;
                }
                BlockFace face = blockFace;
                Hammer.Companion.startHammerWorkers(player, this.selectBlocks(event.getBlock(), face));
                break;
            }
            case 2: {
                Hammer.Companion.finishHammerWorkers(player);
                break;
            }
            case 3: {
                Hammer.Companion.cancelHammerWorkers(player);
            }
        }
    }

    private final List<Block> selectBlocks(Block middle, BlockFace face) {
        ArrayList blocks = new ArrayList();
        Axis axisA = this.nextAxis(BlockFaceUtilsKt.getAxis((BlockFace)face));
        Axis axisB = this.nextAxis(axisA);
        int range = this.options.getRange();
        int depth = this.options.getDepth();
        int x = -range;
        if (x <= range) {
            while (true) {
                int y;
                if ((y = -range) <= range) {
                    while (true) {
                        for (int d = 0; d < depth; ++d) {
                            if (x == 0 && y == 0 && d == 0) continue;
                            Location location = middle.getLocation();
                            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"middle.location");
                            BlockFace blockFace = face.getOppositeFace();
                            Intrinsics.checkNotNullExpressionValue((Object)blockFace, (String)"face.oppositeFace");
                            Block block = LocationUtilsKt.advance((Location)LocationUtilsKt.advance((Location)LocationUtilsKt.advance((Location)location, (BlockFace)blockFace, (double)d), (Axis)axisA, (double)x), (Axis)axisB, (double)y).getBlock();
                            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"middle.location\n        \u2026                   .block");
                            Block block2 = block;
                            double hardnessDifference = Math.abs(BlockUtilsKt.getHardness((Block)block2) - BlockUtilsKt.getHardness((Block)middle));
                            if (hardnessDifference > this.options.getHardnessTolerance()) continue;
                            ((Collection)blocks).add(block2);
                        }
                        if (y == range) break;
                        ++y;
                    }
                }
                if (x == range) break;
                ++x;
            }
        }
        return blocks;
    }

    private final Axis nextAxis(Axis axis) {
        return switch (WhenMappings.$EnumSwitchMapping$1[axis.ordinal()]) {
            case 1 -> Axis.Y;
            case 2 -> Axis.Z;
            case 3 -> Axis.X;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    static {
        SchedulerUtilsKt.runTaskTimer((long)0L, (long)1L, (Function0)Companion.1.INSTANCE);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0002RB\u0010\u0004\u001a6\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005j\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lxyz/xenondevs/vanillahammers/item/Hammer$Companion;", "Lxyz/xenondevs/nova/item/behavior/ItemBehaviorFactory;", "Lxyz/xenondevs/vanillahammers/item/Hammer;", "()V", "hammerWorkers", "Ljava/util/HashMap;", "Lorg/bukkit/entity/Player;", "", "Lorg/bukkit/block/Block;", "", "Lkotlin/collections/HashMap;", "cancelHammerWorkers", "", "player", "create", "item", "Lxyz/xenondevs/nova/item/NovaItem;", "finishHammerWorkers", "startHammerWorkers", "blocks", "", "vanilla_hammers"})
    @SourceDebugExtension(value={"SMAP\nHammer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Hammer.kt\nxyz/xenondevs/vanillahammers/item/Hammer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,126:1\n1285#2,4:127\n215#3,2:131\n215#3,2:133\n*S KotlinDebug\n*F\n+ 1 Hammer.kt\nxyz/xenondevs/vanillahammers/item/Hammer$Companion\n*L\n108#1:127,4\n112#1:131,2\n121#1:133,2\n*E\n"})
    public static final class Companion
    extends ItemBehaviorFactory<Hammer> {
        private Companion() {
        }

        @NotNull
        public Hammer create(@NotNull NovaItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return new Hammer(new HammerOptions(item));
        }

        /*
         * WARNING - void declaration
         */
        private final void startHammerWorkers(Player player, List<? extends Block> blocks) {
            void $this$associateWithTo$iv;
            Map map = hammerWorkers;
            Object object = blocks;
            Map destination$iv = new HashMap();
            boolean $i$f$associateWithTo = false;
            for (Object element$iv : $this$associateWithTo$iv) {
                Block block = (Block)element$iv;
                Object t = element$iv;
                Map map2 = destination$iv;
                boolean bl = false;
                Integer n = Random.Default.nextInt();
                map2.put(t, n);
            }
            object = destination$iv;
            map.put(player, object);
        }

        private final void finishHammerWorkers(Player player) {
            block1: {
                Map map = (Map)hammerWorkers.remove(player);
                if (map == null) break block1;
                Map $this$forEach$iv = map;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    Block block = (Block)entry.getKey();
                    int breakerId = ((Number)entry.getValue()).intValue();
                    BlockUtilsKt.setBreakStage((Block)block, (int)breakerId, (int)-1);
                    BlockBreakContext ctx = new BlockBreakContext(BlockPosKt.getPos((Block)block), (Object)player, player.getLocation(), null, player.getInventory().getItemInMainHand());
                    BlockUtilsKt.breakNaturally((Block)block, (BlockBreakContext)ctx);
                }
            }
        }

        private final void cancelHammerWorkers(Player player) {
            block1: {
                Map map = (Map)hammerWorkers.remove(player);
                if (map == null) break block1;
                Map $this$forEach$iv = map;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    Block block = (Block)entry.getKey();
                    int breakerId = ((Number)entry.getValue()).intValue();
                    BlockUtilsKt.setBreakStage((Block)block, (int)breakerId, (int)-1);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BlockBreakActionEvent.Action.values().length];
            try {
                nArray[BlockBreakActionEvent.Action.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockBreakActionEvent.Action.FINISH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockBreakActionEvent.Action.CANCEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Axis.values().length];
            try {
                nArray[Axis.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Axis.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Axis.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

