/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.loader.library;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.DependencyResolutionException;
import xyz.xenondevs.nova.loader.library.LibraryFileParser;
import xyz.xenondevs.nova.loader.library.LibraryLoader;

public class NovaLibraryLoader {
    private static final HashSet<String> allExclusions = new HashSet();

    public static List<File> loadLibraries(Logger logger, String path) throws IOException, DependencyResolutionException {
        JsonObject librariesJson;
        try (InputStream stream = NovaLibraryLoader.class.getResourceAsStream(path);){
            assert (stream != null);
            librariesJson = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
        }
        List<String> repositories = LibraryFileParser.readRepositories(librariesJson);
        List<Dependency> dependencies = LibraryFileParser.readLibraries(librariesJson);
        Set<String> exclusions = LibraryFileParser.readExclusions(librariesJson);
        allExclusions.addAll(exclusions);
        return LibraryLoader.downloadLibraries(repositories, dependencies, exclusions, logger);
    }

    public static Set<String> getAllExclusions() {
        return allExclusions;
    }
}

