/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.loader;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NovaClassLoader
extends URLClassLoader {
    private final URLClassLoader prioritizedLibraries;

    public NovaClassLoader(@NotNull URL nova, @NotNull @NotNull URL @NotNull [] libraries, @NotNull @NotNull URL @NotNull [] prioritizedLibraries, @Nullable ClassLoader parent) {
        super(NovaClassLoader.concatUrls(nova, libraries), parent);
        this.prioritizedLibraries = new URLClassLoader(prioritizedLibraries, null);
    }

    private static URL[] concatUrls(URL url, URL[] arr) {
        URL[] result = new URL[arr.length + 1];
        result[0] = url;
        System.arraycopy(arr, 0, result, 1, arr.length);
        return result;
    }

    @Override
    @NotNull
    public Class<?> loadClass(@NotNull String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Class<?> loadClass(@NotNull String name, boolean resolve, boolean checkParents, boolean checkPrioritizedLibraries) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null && checkPrioritizedLibraries) {
                c = this.tryFindClass(this.prioritizedLibraries, name);
            }
            if (c == null && checkParents) {
                c = this.tryLoadClass(this.getParent(), name);
            }
            if (c == null) {
                c = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Nullable
    private Class<?> tryLoadClass(@NotNull ClassLoader loader, @NotNull String name) {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    @Nullable
    private Class<?> tryFindClass(@NotNull URLClassLoader loader, @NotNull String name) {
        try {
            return this.findClass(loader, name);
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    @NotNull
    private Class<?> findClass(@NotNull URLClassLoader loader, @NotNull String name) throws ClassNotFoundException {
        String path = name.replace('.', '/') + ".class";
        URL url = loader.findResource(path);
        if (url != null) {
            return this.defineClass(name, url);
        }
        throw new ClassNotFoundException(name);
    }

    @NotNull
    private Class<?> defineClass(String name, URL url) throws ClassNotFoundException {
        Class<?> clazz;
        block9: {
            String packageName;
            int i = name.lastIndexOf(46);
            if (i != -1 && this.getDefinedPackage(packageName = name.substring(0, i)) == null) {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            InputStream in = url.openStream();
            try {
                byte[] bin = in.readAllBytes();
                clazz = this.defineClass(name, bin, 0, bin.length);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassNotFoundException(name, e);
                }
            }
            in.close();
        }
        return clazz;
    }
}

