/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.loader.library;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.ExclusionsDependencyFilter;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;

public class LibraryLoader {
    private static final File LIBRARIES_DIR;

    public static List<File> downloadLibraries(List<String> repositories, List<Dependency> dependencies, Set<String> exclusions, Logger logger) throws DependencyResolutionException {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        RepositorySystem repoSystem = (RepositorySystem)locator.getService(RepositorySystem.class);
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setChecksumPolicy("fail");
        session.setUpdatePolicy("never");
        session.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(true, false));
        session.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(LIBRARIES_DIR)));
        session.setTransferListener((TransferListener)new LoggingTransferListener(logger));
        session.setReadOnly();
        List<Object> remoteRepos = new ArrayList<RemoteRepository>();
        int repoId = 0;
        for (String repoUrl : repositories) {
            remoteRepos.add(new RemoteRepository.Builder(String.valueOf(repoId), "default", repoUrl).build());
            ++repoId;
        }
        remoteRepos = repoSystem.newResolutionRepositories((RepositorySystemSession)session, remoteRepos);
        logger.info("Loading " + dependencies.size() + " libraries...");
        DependencyRequest request = new DependencyRequest(new CollectRequest((Dependency)null, dependencies, remoteRepos), (DependencyFilter)new ExclusionsDependencyFilter(exclusions));
        ArrayList<File> files = new ArrayList<File>();
        List results = repoSystem.resolveDependencies((RepositorySystemSession)session, request).getArtifactResults();
        for (ArtifactResult result : results) {
            File file = result.getArtifact().getFile();
            logger.info("Loaded library " + file.getAbsolutePath());
            files.add(file);
        }
        return files;
    }

    static {
        String repoProperty = System.getProperty("repo");
        LIBRARIES_DIR = repoProperty != null ? new File(repoProperty) : new File("libraries");
    }

    private static class LoggingTransferListener
    extends AbstractTransferListener {
        private final Logger logger;

        public LoggingTransferListener(Logger logger) {
            this.logger = logger;
        }

        public void transferStarted(TransferEvent event) {
            this.logger.info("Downloading " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
        }

        public void transferCorrupted(TransferEvent event) {
            this.logger.log(Level.SEVERE, "Invalid checksum for library " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName(), event.getException());
        }
    }
}

