/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.loader.library;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

public class LibraryFileParser {
    public static List<String> readRepositories(JsonObject json) {
        ArrayList<String> repositories = new ArrayList<String>();
        if (!json.has("repositories")) {
            return repositories;
        }
        for (JsonElement repo : json.get("repositories").getAsJsonArray()) {
            repositories.add(repo.getAsString());
        }
        return repositories;
    }

    public static List<Dependency> readLibraries(JsonObject json) {
        ArrayList<Dependency> libraries = new ArrayList<Dependency>();
        if (!json.has("libraries")) {
            return libraries;
        }
        for (JsonElement library : json.get("libraries").getAsJsonArray()) {
            JsonObject libraryObj = library.getAsJsonObject();
            String coords = libraryObj.get("coords").getAsString();
            ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
            for (JsonElement excludedCoords : libraryObj.get("excludes").getAsJsonArray()) {
                String[] parts = excludedCoords.getAsString().split(":");
                Exclusion exclusion = new Exclusion(parts.length > 0 ? parts[0] : null, parts.length > 1 ? parts[1] : null, parts.length > 2 ? parts[2] : null, parts.length > 3 ? parts[3] : null);
                exclusions.add(exclusion);
            }
            Dependency dependency = new Dependency((Artifact)new DefaultArtifact(coords), null, Boolean.valueOf(false), exclusions);
            libraries.add(dependency);
        }
        return libraries;
    }

    public static Set<String> readExclusions(JsonObject json) {
        HashSet<String> repositories = new HashSet<String>();
        if (!json.has("excludes")) {
            return repositories;
        }
        for (JsonElement repo : json.get("excludes").getAsJsonArray()) {
            repositories.add(repo.getAsString());
        }
        return repositories;
    }
}

