/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.loader;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import io.papermc.paper.plugin.bootstrap.PluginProviderContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.loader.NovaClassLoader;
import xyz.xenondevs.nova.loader.NovaJavaPlugin;
import xyz.xenondevs.nova.loader.library.NovaLibraryLoader;

public class NovaBootstrapper
implements PluginBootstrap {
    private static final String NOVA_JAR_PATH = "/nova.jar";
    private static final String LIBRARIES_PATH = "/libraries.json";
    private static final String PRIORITIZED_LIBRARIES_PATH = "/prioritized_libraries.json";
    private static final String BUNDLER_DIR_PATH = ".internal_data/bundler";
    private static final String NOVA_EXTRACTED_JAR_FORMAT = "Nova-%s.jar";

    public void bootstrap(@NotNull BootstrapContext context) {
    }

    @NotNull
    public JavaPlugin createPlugin(@NotNull PluginProviderContext context) {
        Logger logger = Logger.getLogger("Nova");
        try {
            File novaJar = this.extractNovaJar(context);
            NovaClassLoader classLoader = new NovaClassLoader(novaJar.toURI().toURL(), this.loadLibraries(logger, LIBRARIES_PATH), this.loadLibraries(logger, PRIORITIZED_LIBRARIES_PATH), this.getClass().getClassLoader());
            return new NovaJavaPlugin(novaJar, classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private File extractNovaJar(@NotNull PluginProviderContext context) throws IOException {
        File bundlerDir = context.getDataDirectory().resolve(BUNDLER_DIR_PATH).toFile();
        bundlerDir.mkdirs();
        File[] files = bundlerDir.listFiles();
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
        File novaJar = new File(bundlerDir, String.format(NOVA_EXTRACTED_JAR_FORMAT, context.getConfiguration().getVersion()));
        try (InputStream in = NovaBootstrapper.class.getResourceAsStream(NOVA_JAR_PATH);){
            assert (in != null);
            try (FileOutputStream out = new FileOutputStream(novaJar);){
                in.transferTo(out);
            }
        }
        return novaJar;
    }

    private URL[] loadLibraries(Logger logger, String path) throws DependencyResolutionException, IOException {
        return this.toUrlArray(NovaLibraryLoader.loadLibraries(logger, path));
    }

    private URL[] toUrlArray(List<File> files) throws MalformedURLException {
        URL[] array = new URL[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            array[i] = files.get(i).toURI().toURL();
        }
        return array;
    }
}

