/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.loader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class NovaClassLoader
extends URLClassLoader {
    private final Set<String> injectedClasses = new HashSet<String>();

    public NovaClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClass(String name, boolean resolve, boolean checkParents) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null && name.startsWith("net.kyori.adventure") && checkParents) {
                c = this.loadClassFromParentOrNull(name);
            }
            if (c == null && !this.injectedClasses.contains(name)) {
                c = this.findClassOrNull(name);
            }
            if (c == null && checkParents) {
                c = this.loadClassFromParentOrNull(name);
            }
            if (c == null) {
                throw new ClassNotFoundException(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    private Class<?> findClassOrNull(String name) {
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Class<?> loadClassFromParentOrNull(String name) {
        try {
            return this.getParent().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void addInjectedClass(String name) {
        this.injectedClasses.add(name);
    }

    public void addInjectedClasses(Collection<String> names) {
        this.injectedClasses.addAll(names);
    }
}

