/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.loader.library;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.configuration.file.YamlConfiguration;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.resolution.DependencyResolutionException;
import xyz.xenondevs.nova.loader.library.LibraryLoader;

public class NovaLibraryLoader {
    public static List<URL> loadLibraries(Logger logger) throws IOException, DependencyResolutionException {
        YamlConfiguration cfg;
        try (InputStream stream = NovaLibraryLoader.class.getResourceAsStream("/libraries.yml");){
            assert (stream != null);
            cfg = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream));
        }
        return LibraryLoader.downloadLibraries(cfg.getStringList("repositories"), NovaLibraryLoader.readRequestedLibraries(cfg), NovaLibraryLoader.readExclusions(cfg), logger);
    }

    public static List<Dependency> readRequestedLibraries(YamlConfiguration cfg) {
        ArrayList<Dependency> libraries = new ArrayList<Dependency>();
        if (!cfg.contains("libraries")) {
            return libraries;
        }
        for (Object obj : cfg.getList("libraries")) {
            HashMap map;
            Object coords;
            if (obj instanceof String) {
                String coords2 = (String)obj;
                libraries.add(new Dependency((Artifact)new DefaultArtifact(coords2), null));
                continue;
            }
            if (!(obj instanceof HashMap) || (coords = (map = (HashMap)obj).get("library")) == null) continue;
            Object exclusions = map.get("exclusions");
            Dependency dependency = exclusions != null ? new Dependency((Artifact)new DefaultArtifact((String)coords), null, Boolean.valueOf(false), ((List)exclusions).stream().map(exCoords -> {
                String[] parts = exCoords.split(":");
                return new Exclusion(parts.length > 0 ? parts[0] : null, parts.length > 1 ? parts[1] : null, parts.length > 2 ? parts[2] : null, parts.length > 3 ? parts[3] : null);
            }).toList()) : new Dependency((Artifact)new DefaultArtifact((String)coords), null);
            libraries.add(dependency);
        }
        return libraries;
    }

    public static List<String> readExclusions(YamlConfiguration cfg) {
        return cfg.getStringList("exclusions");
    }
}

