/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.loader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.xenondevs.nova.loader.NovaClassLoader;
import xyz.xenondevs.nova.loader.library.NovaLibraryLoader;

public class NovaLoader
extends JavaPlugin {
    private Plugin nova;
    private final Logger logger = this.getLogger();

    public void onEnable() {
        try {
            File novaJarFile = NovaLoader.extractNovaJar(this, "/nova.jar");
            List<URL> classpath = NovaLibraryLoader.loadLibraries(this.logger);
            classpath.add(novaJarFile.toURI().toURL());
            NovaClassLoader loader = new NovaClassLoader((URL[])classpath.toArray(URL[]::new), this.getClassLoader());
            Class<?> novaClass = loader.loadClass("xyz.xenondevs.nova.Nova");
            this.nova = (Plugin)novaClass.getConstructor(JavaPlugin.class, File.class).newInstance(new Object[]{this, novaJarFile});
            this.nova.onEnable();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "An exception occurred trying to load Nova and its libraries", e);
        }
    }

    public void onDisable() {
        if (this.nova != null) {
            this.nova.onDisable();
        }
    }

    public Plugin getNova() {
        return this.nova;
    }

    public static File extractNovaJar(NovaLoader loader, String pathInJar) throws IOException {
        File file = new File(loader.getDataFolder(), ".internal_data/bundler/Nova-" + loader.getDescription().getVersion() + ".jar");
        File parentFile = file.getParentFile();
        parentFile.mkdirs();
        Arrays.stream(parentFile.listFiles()).forEach(File::delete);
        try (InputStream in = NovaLoader.class.getResourceAsStream(pathInJar);){
            assert (in != null);
            try (FileOutputStream out = new FileOutputStream(file);){
                in.transferTo(out);
            }
        }
        return file;
    }
}

