/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.world;

import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.invui.item.impl.AbstractItem;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.integration.protection.ProtectionManager;
import xyz.xenondevs.nova.machines.registry.GuiMaterials;
import xyz.xenondevs.nova.machines.tileentity.world.PumpKt;
import xyz.xenondevs.nova.machines.tileentity.world.PumpMode;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.FluidType;
import xyz.xenondevs.nova.tileentity.network.fluid.container.FluidContainer;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.FluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.FluidBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigMenu;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.BlockUtilsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.nova.world.region.Region;
import xyz.xenondevs.nova.world.region.UpgradableRegion;
import xyz.xenondevs.nova.world.region.VisualRegion;
import xyz.xenondevs.simpleupgrades.UpgradeFunctionsKt;
import xyz.xenondevs.simpleupgrades.registry.UpgradeTypes;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001/B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010!\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010#0\"H\u0002J\u0018\u0010$\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010#0\"H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020&H\u0016J\b\u0010*\u001a\u00020&H\u0002J\b\u0010+\u001a\u00020&H\u0016J\b\u0010,\u001a\u00020&H\u0016J\u0018\u0010-\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010#0\"H\u0002J\f\u0010.\u001a\u00020(*\u00020\u0013H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00060"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/world/Pump;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "fluidHolder", "Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "getFluidHolder", "()Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "fluidTank", "Lxyz/xenondevs/nova/tileentity/network/fluid/container/FluidContainer;", "idleTime", "", "lastBlock", "Lorg/bukkit/block/Block;", "maxIdleTime", "mode", "Lxyz/xenondevs/nova/machines/tileentity/world/PumpMode;", "region", "Lxyz/xenondevs/nova/world/region/UpgradableRegion;", "sortedFaces", "Ljava/util/LinkedList;", "Lorg/bukkit/block/BlockFace;", "kotlin.jvm.PlatformType", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getNextBlock", "Lkotlin/Pair;", "Lxyz/xenondevs/nova/tileentity/network/fluid/FluidType;", "getRelativeBlock", "handleRemoved", "", "unload", "", "handleTick", "pumpNextBlock", "reload", "saveData", "searchBlock", "isInfiniteWaterSource", "PumpMenu", "machines"})
@SourceDebugExtension(value={"SMAP\nPump.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pump.kt\nxyz/xenondevs/nova/machines/tileentity/world/Pump\n+ 2 DataHolder.kt\nxyz/xenondevs/nova/data/serialization/DataHolder\n+ 3 Compound.kt\nxyz/xenondevs/cbf/Compound\n+ 4 Lists.kt\nxyz/xenondevs/commons/collections/ListsKt\n*L\n1#1,240:1\n30#2:241\n47#2:242\n73#2,3:247\n47#3:243\n8#4,3:244\n*S KotlinDebug\n*F\n+ 1 Pump.kt\nxyz/xenondevs/nova/machines/tileentity/world/Pump\n*L\n60#1:241\n60#1:242\n192#1:247,3\n60#1:243\n140#1:244,3\n*E\n"})
public final class Pump
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final FluidContainer fluidTank;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    @NotNull
    private final NovaFluidHolder fluidHolder;
    @NotNull
    private PumpMode mode;
    @NotNull
    private final UpgradableRegion region;
    private int maxIdleTime;
    private int idleTime;
    @Nullable
    private Block lastBlock;
    @NotNull
    private LinkedList<BlockFace> sortedFaces;

    /*
     * WARNING - void declaration
     */
    public Pump(@NotNull NovaTileEntityState blockState) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        UpgradeType[] upgradeTypeArray = new UpgradeType[]{UpgradeTypes.INSTANCE.getSPEED(), UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getENERGY(), UpgradeTypes.INSTANCE.getRANGE(), UpgradeTypes.INSTANCE.getFLUID()};
        this.upgradeHolder = this.getUpgradeHolder(upgradeTypeArray);
        upgradeTypeArray = new FluidType[]{FluidType.WATER, FluidType.LAVA};
        this.fluidTank = UpgradeFunctionsKt.getFluidContainer$default((TileEntity)((TileEntity)this), (String)"tank", (Set)SetsKt.hashSetOf((Object[])upgradeTypeArray), (Provider)PumpKt.access$getFLUID_CAPACITY$p(), (long)0L, null, (UpgradeHolder)this.getUpgradeHolder(), (boolean)false, (int)88, null);
        this.energyHolder = UpgradeFunctionsKt.ConsumerEnergyHolder$default((NetworkedTileEntity)this, (Provider)PumpKt.access$getENERGY_CAPACITY$p(), (Provider)PumpKt.access$getENERGY_PER_TICK$p(), null, (UpgradeHolder)this.getUpgradeHolder(), (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ Pump this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.TOP};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }), (int)8, null);
        this.fluidHolder = NovaFluidHolderKt.NovaFluidHolder$default((DataHolder)((DataHolder)this), (Pair)TuplesKt.to((Object)this.fluidTank, (Object)NetworkConnectionType.EXTRACT), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ Pump this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.TOP};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        }), (int)8, null);
        Pump pump = this;
        upgradeTypeArray = (UpgradeType[])this;
        String key$iv = "mode";
        boolean $i$f$retrieveData = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$retrieveDataOrNull = false;
        Compound this_$iv$iv$iv = this_$iv$iv.getData();
        boolean $i$f$get = false;
        Object object = this_$iv$iv$iv.get(Reflection.typeOf(PumpMode.class), key$iv);
        if (object == null) {
            this_$iv$iv$iv = this_$iv$iv.getGlobalData();
            $i$f$get = false;
            object = this_$iv$iv$iv.get(Reflection.typeOf(PumpMode.class), key$iv);
        }
        Object object2 = object;
        if (object == null) {
            Pump pump2 = pump;
            boolean bl = false;
            object2 = PumpMode.REPLACE;
            pump = pump2;
        }
        pump.mode = (PumpMode)((Object)object2);
        this.region = this.getUpgradableRegion(UpgradeTypes.INSTANCE.getRANGE(), PumpKt.access$getMIN_RANGE$p(), PumpKt.access$getMAX_RANGE$p(), PumpKt.access$getDEFAULT_RANGE(), (Function1)new Function1<Integer, Region>(this){
            final /* synthetic */ Pump this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Region invoke(int it) {
                Pump.access$setIdleTime$p(this.this$0, Pump.access$getMaxIdleTime$p(this.this$0));
                double range = it;
                Location location = this.this$0.getLocation().clone().subtract(range - 1.0, range, range - 1.0);
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location.clone().subtrac\u2026ge - 1, range, range - 1)");
                Location min = location;
                Location location2 = this.this$0.getLocation().clone().add(range, 0.0, range);
                Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"location.clone().add(range, 0.0, range)");
                Location max = location2;
                return new Region(min, max);
            }
        });
        this.sortedFaces = new LinkedList(LocationUtilsKt.getHORIZONTAL_FACES());
        this.reload();
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    @NotNull
    public NovaFluidHolder getFluidHolder() {
        return this.fluidHolder;
    }

    public void reload() {
        super.reload();
        this.maxIdleTime = (int)((double)PumpKt.access$getIDLE_TIME() / ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getSPEED())).doubleValue());
        if (this.idleTime > this.maxIdleTime) {
            this.idleTime = this.maxIdleTime;
        }
    }

    public void handleTick() {
        if (this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getEnergyConsumption() && this.fluidTank.accepts(FluidType.WATER, 1000L)) {
            this.idleTime += -1;
            if (this.idleTime <= 0) {
                this.pumpNextBlock();
            }
        }
    }

    private final void pumpNextBlock() {
        Pair<Block, FluidType> pair = this.getNextBlock();
        Block block = (Block)pair.component1();
        FluidType type = (FluidType)pair.component2();
        if (block != null && type != null) {
            if (this.mode == PumpMode.REPLACE) {
                block.setType(PumpKt.access$getREPLACEMENT_BLOCK());
                Material material = PumpKt.access$getREPLACEMENT_BLOCK();
                Location location = block.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"block.location");
                MaterialUtilsKt.playPlaceSoundEffect((Material)material, (Location)location);
            } else if (!this.isInfiniteWaterSource(block)) {
                block.setType(Material.AIR);
            }
            this.fluidTank.addFluid(type, 1000L);
            this.lastBlock = block;
            ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
            consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getEnergyConsumption());
            this.idleTime = this.maxIdleTime;
        } else {
            this.lastBlock = null;
            this.idleTime = 1200;
        }
    }

    private final Pair<Block, FluidType> getNextBlock() {
        Pair<Block, FluidType> pair;
        Block block = null;
        FluidType type = null;
        if (this.lastBlock != null) {
            pair = this.getRelativeBlock();
            block = (Block)pair.getFirst();
            type = (FluidType)pair.getSecond();
        }
        if (block == null) {
            pair = this.searchBlock();
            block = (Block)pair.getFirst();
            type = (FluidType)pair.getSecond();
        }
        return TuplesKt.to(block, type);
    }

    private final Pair<Block, FluidType> getRelativeBlock() {
        Block block = this.lastBlock;
        Intrinsics.checkNotNull((Object)block);
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"lastBlock!!.location");
        Location location2 = location;
        List faces = CollectionsKt.plus((Collection)LocationUtilsKt.getVERTICAL_FACES(), (Iterable)this.sortedFaces);
        Block block2 = null;
        FluidType type = null;
        for (BlockFace face : faces) {
            FluidType fluidType;
            Block newBlock;
            Location location3 = location2.clone();
            Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"location.clone()");
            Intrinsics.checkNotNullExpressionValue((Object)face, (String)"face");
            Intrinsics.checkNotNullExpressionValue((Object)LocationUtilsKt.advance((Location)location3, (BlockFace)face, (double)1.0).getBlock(), (String)"location.clone().advance(face, 1.0).block");
            if (BlockUtilsKt.getSourceFluidType((Block)newBlock) == null || !this.fluidTank.accepts(fluidType) || !this.region.contains(newBlock)) continue;
            TileEntity tileEntity = (TileEntity)this;
            Location location4 = newBlock.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location4, (String)"newBlock.location");
            Object t = ProtectionManager.INSTANCE.canBreak(tileEntity, null, location4).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"ProtectionManager.canBre\u2026 newBlock.location).get()");
            if (!((Boolean)t).booleanValue()) continue;
            if (!LocationUtilsKt.getVERTICAL_FACES().contains(face)) {
                List $this$rotateRight$iv = this.sortedFaces;
                boolean $i$f$rotateRight = false;
                Object last$iv = $this$rotateRight$iv.remove($this$rotateRight$iv.size() - 1);
                $this$rotateRight$iv.add(0, last$iv);
            }
            block2 = newBlock;
            type = fluidType;
            break;
        }
        return TuplesKt.to(block2, type);
    }

    private final Pair<Block, FluidType> searchBlock() {
        int n = this.region.getSize();
        block0: for (int i = 0; i < n; ++i) {
            int r = i;
            boolean bl = false;
            if (r == 0) {
                FluidType fluidType;
                Block block;
                Location location = this.getLocation().clone();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location.clone()");
                Intrinsics.checkNotNullExpressionValue((Object)LocationUtilsKt.advance$default((Location)location, (BlockFace)BlockFace.DOWN, (double)0.0, (int)2, null).getBlock(), (String)"location.clone().advance(BlockFace.DOWN).block");
                if (BlockUtilsKt.getSourceFluidType((Block)block) == null || !this.fluidTank.accepts(fluidType)) continue;
                TileEntity tileEntity = (TileEntity)this;
                Location location2 = block.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"block.location");
                Object t = ProtectionManager.INSTANCE.canBreak(tileEntity, null, location2).get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"ProtectionManager.canBre\u2026ll, block.location).get()");
                if (!((Boolean)t).booleanValue()) continue;
                return TuplesKt.to((Object)block, (Object)fluidType);
            }
            int x = -r;
            if (x > r) continue;
            while (true) {
                block2: for (int y = -r - 1; y < 0; ++y) {
                    int z = -r;
                    if (z > r) continue;
                    while (true) {
                        if (x == -r || x == r || y == -r - 1 || y == -1 || z == -r || z == r) {
                            FluidType fluidType;
                            Block block;
                            Intrinsics.checkNotNullExpressionValue((Object)this.getLocation().clone().add((double)x, (double)y, (double)z).getBlock(), (String)"location.clone().add(x.t\u2026le(), z.toDouble()).block");
                            if (BlockUtilsKt.getSourceFluidType((Block)block) != null && this.fluidTank.accepts(fluidType)) {
                                TileEntity tileEntity = (TileEntity)this;
                                Location location = block.getLocation();
                                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"block.location");
                                Object t = ProtectionManager.INSTANCE.canBreak(tileEntity, null, location).get();
                                Intrinsics.checkNotNullExpressionValue(t, (String)"ProtectionManager.canBre\u2026ll, block.location).get()");
                                if (((Boolean)t).booleanValue()) {
                                    return TuplesKt.to((Object)block, (Object)fluidType);
                                }
                            }
                        }
                        if (z == r) continue block2;
                        ++z;
                    }
                }
                if (x == r) continue block0;
                ++x;
            }
        }
        return TuplesKt.to(null, null);
    }

    private final boolean isInfiniteWaterSource(Block $this$isInfiniteWaterSource) {
        int waterCount = 0;
        for (BlockFace it : LocationUtilsKt.getHORIZONTAL_FACES()) {
            Block newBlock;
            Location location = $this$isInfiniteWaterSource.getLocation().clone();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location.clone()");
            Intrinsics.checkNotNullExpressionValue((Object)LocationUtilsKt.advance((Location)location, (BlockFace)it, (double)1.0).getBlock(), (String)"location.clone().advance(it, 1.0).block");
            if (newBlock.getType() != Material.WATER && newBlock.getType() != Material.BUBBLE_COLUMN || !BlockUtilsKt.isSourceFluid((Block)newBlock) || ++waterCount <= 1) continue;
            return true;
        }
        return false;
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        VisualRegion.INSTANCE.removeRegion(this.getUuid());
    }

    /*
     * WARNING - void declaration
     */
    public void saveData() {
        void key$iv;
        super.saveData();
        String string = "mode";
        PumpMode value$iv = this.mode;
        boolean global$iv = false;
        boolean $i$f$storeData = false;
        ((DataHolder)this).storeData(Reflection.typeOf(PumpMode.class), (String)key$iv, (Object)value$iv, global$iv);
    }

    public static final /* synthetic */ void access$setIdleTime$p(Pump $this, int n) {
        $this.idleTime = n;
    }

    public static final /* synthetic */ int access$getMaxIdleTime$p(Pump $this) {
        return $this.maxIdleTime;
    }

    @TileEntityMenuClass
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002:\u0001\rB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/world/Pump$PumpMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity$IndividualTileEntityMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "player", "Lorg/bukkit/entity/Player;", "(Lxyz/xenondevs/nova/machines/tileentity/world/Pump;Lorg/bukkit/entity/Player;)V", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "Lorg/jetbrains/annotations/NotNull;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "sideConfigGui", "Lxyz/xenondevs/nova/ui/config/side/SideConfigMenu;", "PumpModeItem", "machines"})
    public final class PumpMenu
    extends TileEntity.IndividualTileEntityMenu {
        @NotNull
        private final SideConfigMenu sideConfigGui;
        @NotNull
        private final Gui gui;

        public PumpMenu(Player player2) {
            Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
            super((TileEntity)Pump.this, player2, null, 2, null);
            this.sideConfigGui = new SideConfigMenu((NetworkEndPoint)Pump.this, null, CollectionsKt.listOf((Object)TuplesKt.to((Object)Pump.this.fluidTank, (Object)"container.nova.fluid_tank")), (Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((PumpMenu)((Object)this.receiver)).openWindow();
                }
            }, 2, null);
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s p # f # e M |", "| u n # f # e # |", "| v m # f # e # |", "3 - - - - - - - 4"};
            Gui gui2 = ((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)Gui.normal().setStructure(stringArray)).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGui))).addIngredient('u', (Item)new OpenUpgradesItem(Pump.this.getUpgradeHolder()))).addIngredient('v', (Item)Pump.this.region.createVisualizeRegionItem(player2))).addIngredient('p', (Item)Pump.this.region.getIncreaseSizeItem())).addIngredient('n', (Item)Pump.this.region.getDisplaySizeItem())).addIngredient('m', (Item)Pump.this.region.getDecreaseSizeItem())).addIngredient('M', (Item)new PumpModeItem())).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)Pump.this.getEnergyHolder()))).addIngredient('f', (Supplier)new FluidBar(3, (FluidHolder)Pump.this.getFluidHolder(), Pump.this.fluidTank))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"normal()\n            .se\u2026nk))\n            .build()");
            this.gui = gui2;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/world/Pump$PumpMenu$PumpModeItem;", "Lxyz/xenondevs/invui/item/impl/AbstractItem;", "(Lxyz/xenondevs/nova/machines/tileentity/world/Pump$PumpMenu;)V", "getItemProvider", "Lxyz/xenondevs/invui/item/ItemProvider;", "handleClick", "", "clickType", "Lorg/bukkit/event/inventory/ClickType;", "player", "Lorg/bukkit/entity/Player;", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "machines"})
        private final class PumpModeItem
        extends AbstractItem {
            @NotNull
            public ItemProvider getItemProvider() {
                return (Pump.this.mode == PumpMode.PUMP ? GuiMaterials.INSTANCE.getPUMP_MODE_BTN() : GuiMaterials.INSTANCE.getPUMP_REPLACE_MODE_BTN()).getClientsideProvider();
            }

            public void handleClick(@NotNull ClickType clickType, @NotNull Player player2, @NotNull InventoryClickEvent event) {
                Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
                Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Pump.this.mode = Pump.this.mode == PumpMode.PUMP ? PumpMode.REPLACE : PumpMode.PUMP;
                this.notifyWindows();
            }
        }
    }
}

