/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.processing.brewing;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.machines.recipe.ElectricBrewingStandRecipe;
import xyz.xenondevs.nova.machines.tileentity.processing.brewing.ElectricBrewingStand;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0000H\u0016R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u001e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lxyz/xenondevs/nova/machines/tileentity/processing/brewing/PotionEffectBuilder;", "", "type", "Lorg/bukkit/potion/PotionEffectType;", "durationLevel", "", "amplifierLevel", "(Lorg/bukkit/potion/PotionEffectType;II)V", "value", "getAmplifierLevel", "()I", "setAmplifierLevel", "(I)V", "getDurationLevel", "setDurationLevel", "<set-?>", "maxAmplifierLevel", "getMaxAmplifierLevel", "maxDurationLevel", "getMaxDurationLevel", "recipe", "Lxyz/xenondevs/nova/machines/recipe/ElectricBrewingStandRecipe;", "getRecipe", "()Lxyz/xenondevs/nova/machines/recipe/ElectricBrewingStandRecipe;", "getType", "()Lorg/bukkit/potion/PotionEffectType;", "setType", "(Lorg/bukkit/potion/PotionEffectType;)V", "build", "Lorg/bukkit/potion/PotionEffect;", "clone", "Companion", "machines"})
public final class PotionEffectBuilder
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PotionEffectType type;
    private int maxDurationLevel;
    private int maxAmplifierLevel;
    private int durationLevel;
    private int amplifierLevel;

    public PotionEffectBuilder(@Nullable PotionEffectType type, int durationLevel, int amplifierLevel) {
        this.type = type;
        this.durationLevel = durationLevel;
        this.amplifierLevel = amplifierLevel;
        if (type != null) {
            ElectricBrewingStandRecipe recipe = this.getRecipe();
            this.maxDurationLevel = recipe.getMaxDurationLevel();
            this.maxAmplifierLevel = recipe.getMaxAmplifierLevel();
        }
    }

    public /* synthetic */ PotionEffectBuilder(PotionEffectType potionEffectType, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            potionEffectType = null;
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(potionEffectType, n, n2);
    }

    @NotNull
    public final ElectricBrewingStandRecipe getRecipe() {
        ElectricBrewingStandRecipe electricBrewingStandRecipe = ElectricBrewingStand.Companion.getAVAILABLE_POTION_EFFECTS().get(this.type);
        Intrinsics.checkNotNull((Object)electricBrewingStandRecipe);
        return electricBrewingStandRecipe;
    }

    @Nullable
    public final PotionEffectType getType() {
        return this.type;
    }

    public final void setType(@Nullable PotionEffectType value) {
        this.type = value;
        if (value != null) {
            ElectricBrewingStandRecipe recipe = this.getRecipe();
            this.maxDurationLevel = recipe.getMaxDurationLevel();
            this.maxAmplifierLevel = recipe.getMaxAmplifierLevel();
        } else {
            this.maxDurationLevel = 0;
            this.maxAmplifierLevel = 0;
        }
    }

    public final int getMaxDurationLevel() {
        return this.maxDurationLevel;
    }

    public final int getMaxAmplifierLevel() {
        return this.maxAmplifierLevel;
    }

    public final int getDurationLevel() {
        return this.durationLevel;
    }

    public final void setDurationLevel(int value) {
        this.durationLevel = RangesKt.coerceIn((int)value, (ClosedRange)((ClosedRange)new IntRange(0, this.maxDurationLevel)));
    }

    public final int getAmplifierLevel() {
        return this.amplifierLevel;
    }

    public final void setAmplifierLevel(int value) {
        this.amplifierLevel = RangesKt.coerceIn((int)value, (ClosedRange)((ClosedRange)new IntRange(0, this.maxAmplifierLevel)));
    }

    @NotNull
    public final PotionEffect build() {
        PotionEffectType type = this.type;
        if (type == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        ElectricBrewingStandRecipe recipe = this.getRecipe();
        int defaultDuration = recipe.getDefaultTime();
        double duration = defaultDuration;
        if (this.durationLevel > 0) {
            duration *= (double)this.durationLevel * recipe.getRedstoneMultiplier();
        }
        return new PotionEffect(type, MathKt.roundToInt((double)(duration *= Math.pow(recipe.getGlowstoneMultiplier(), this.amplifierLevel))), this.amplifierLevel, false, true, true);
    }

    @NotNull
    public PotionEffectBuilder clone() {
        Object object = super.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type xyz.xenondevs.nova.machines.tileentity.processing.brewing.PotionEffectBuilder");
        return (PotionEffectBuilder)object;
    }

    public PotionEffectBuilder() {
        this(null, 0, 0, 7, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/processing/brewing/PotionEffectBuilder$Companion;", "", "()V", "of", "Lxyz/xenondevs/nova/machines/tileentity/processing/brewing/PotionEffectBuilder;", "effect", "Lorg/bukkit/potion/PotionEffect;", "machines"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PotionEffectBuilder of(@NotNull PotionEffect effect) {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            return new PotionEffectBuilder(effect.getType(), effect.getDuration(), effect.getAmplifier());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

