/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.energy;

import java.util.EnumMap;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nmsutils.particle.ParticleBuilder;
import xyz.xenondevs.nmsutils.particle.ParticleBuilderKt;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.machines.tileentity.energy.LavaGeneratorKt;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.TileEntityPacketTask;
import xyz.xenondevs.nova.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ProviderEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.FluidType;
import xyz.xenondevs.nova.tileentity.network.fluid.container.FluidContainer;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.FluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.FluidBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigMenu;
import xyz.xenondevs.nova.util.BlockFaceUtilsKt;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.MathUtilsKt;
import xyz.xenondevs.simpleupgrades.UpgradeFunctionsKt;
import xyz.xenondevs.simpleupgrades.registry.UpgradeTypes;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\"B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u001fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/LavaGenerator;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "burnProgress", "", "burnRate", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "energyPerTick", "", "fluidContainer", "Lxyz/xenondevs/nova/tileentity/network/fluid/container/FluidContainer;", "fluidHolder", "Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "getFluidHolder", "()Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "lavaParticleTask", "Lxyz/xenondevs/nova/tileentity/TileEntityPacketTask;", "on", "", "smokeParticleTask", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "handleTick", "", "reload", "updateModelState", "LavaGeneratorMenu", "machines"})
public final class LavaGenerator
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final FluidContainer fluidContainer;
    @NotNull
    private final NovaFluidHolder fluidHolder;
    @NotNull
    private final ProviderEnergyHolder energyHolder;
    private boolean on;
    private double burnRate;
    private double burnProgress;
    private long energyPerTick;
    @NotNull
    private final TileEntityPacketTask smokeParticleTask;
    @NotNull
    private final TileEntityPacketTask lavaParticleTask;

    public LavaGenerator(@NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        Object[] objectArray = new UpgradeType[]{UpgradeTypes.INSTANCE.getSPEED(), UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getENERGY(), UpgradeTypes.INSTANCE.getFLUID()};
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])objectArray);
        objectArray = new FluidType[]{FluidType.LAVA};
        this.fluidContainer = UpgradeFunctionsKt.getFluidContainer$default((TileEntity)((TileEntity)this), (String)"tank", (Set)SetsKt.hashSetOf((Object[])objectArray), (Provider)LavaGeneratorKt.access$getFLUID_CAPACITY$p(), (long)0L, null, (UpgradeHolder)this.getUpgradeHolder(), (boolean)false, (int)88, null);
        this.fluidHolder = NovaFluidHolderKt.NovaFluidHolder$default((DataHolder)((DataHolder)this), (Pair)TuplesKt.to((Object)this.fluidContainer, (Object)NetworkConnectionType.BUFFER), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ LavaGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }), (int)8, null);
        this.energyHolder = UpgradeFunctionsKt.ProviderEnergyHolder((NetworkedTileEntity)this, (Provider)LavaGeneratorKt.access$getENERGY_CAPACITY$p(), (UpgradeHolder)this.getUpgradeHolder(), (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ LavaGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        }));
        ParticleType particleType = Particles.ab;
        Intrinsics.checkNotNullExpressionValue((Object)particleType, (String)"SMOKE");
        this.smokeParticleTask = this.createPacketTask(CollectionsKt.listOf((Object)ParticleBuilderKt.particle((Particle)((Particle)particleType), (Function1)((Function1)new Function1<ParticleBuilder<ParticleType>, Unit>(this){
            final /* synthetic */ LavaGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ParticleBuilder<ParticleType> $this$particle) {
                void $this$invoke_u24lambda_u240;
                Location location;
                Intrinsics.checkNotNullParameter($this$particle, (String)"$this$particle");
                Location location2 = location = LocationUtilsKt.advance((Location)this.this$0.getCenterLocation(), (BlockFace)this.this$0.getFace(BlockSide.FRONT), (double)0.6);
                ParticleBuilder<ParticleType> particleBuilder = $this$particle;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setY($this$invoke_u24lambda_u240.getY() + 0.6);
                particleBuilder.location(location);
                $this$particle.offset(BlockFaceUtilsKt.getAxis((BlockFace)this.this$0.getFace(BlockSide.RIGHT)), 0.15f);
                $this$particle.offsetY(0.1f);
                $this$particle.speed(0.0f);
                $this$particle.amount(1);
            }
        }))), 3L);
        ParticleType particleType2 = Particles.V;
        Intrinsics.checkNotNullExpressionValue((Object)particleType2, (String)"LAVA");
        this.lavaParticleTask = this.createPacketTask(CollectionsKt.listOf((Object)ParticleBuilderKt.particle((Particle)((Particle)particleType2), (Function1)((Function1)new Function1<ParticleBuilder<ParticleType>, Unit>(this){
            final /* synthetic */ LavaGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ParticleBuilder<ParticleType> $this$particle) {
                void $this$invoke_u24lambda_u240;
                Location location;
                Intrinsics.checkNotNullParameter($this$particle, (String)"$this$particle");
                Location location2 = location = LocationUtilsKt.advance((Location)this.this$0.getCenterLocation(), (BlockFace)this.this$0.getFace(BlockSide.FRONT), (double)0.6);
                ParticleBuilder<ParticleType> particleBuilder = $this$particle;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setY($this$invoke_u24lambda_u240.getY() + 0.6);
                particleBuilder.location(location);
                $this$particle.offset(BlockFaceUtilsKt.getAxis((BlockFace)this.this$0.getFace(BlockSide.RIGHT)), 0.15f);
                $this$particle.offsetY(0.1f);
            }
        }))), 200L);
        this.reload();
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public NovaFluidHolder getFluidHolder() {
        return this.fluidHolder;
    }

    @NotNull
    public ProviderEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    public void reload() {
        super.reload();
        this.burnRate = LavaGeneratorKt.access$getBURN_RATE() * ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getSPEED())).doubleValue() / ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getEFFICIENCY())).doubleValue();
        this.energyPerTick = (long)(LavaGeneratorKt.access$getENERGY_PER_MB() * LavaGeneratorKt.access$getBURN_RATE() * ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getSPEED())).doubleValue());
    }

    private final void updateModelState() {
        this.getBlockState().getModelProvider().update(MathUtilsKt.getIntValue((boolean)this.on));
    }

    public void handleTick() {
        long lavaAmount;
        if (this.getEnergyHolder().getEnergy() == this.getEnergyHolder().getMaxEnergy() || this.fluidContainer.isEmpty()) {
            if (this.on) {
                this.on = false;
                this.updateModelState();
                this.smokeParticleTask.stop();
                this.lavaParticleTask.stop();
            }
            return;
        }
        if (!this.on) {
            this.on = true;
            this.updateModelState();
            this.smokeParticleTask.start();
            this.lavaParticleTask.start();
        }
        if ((double)(lavaAmount = this.fluidContainer.getAmount()) >= this.burnRate) {
            ProviderEnergyHolder providerEnergyHolder = this.getEnergyHolder();
            providerEnergyHolder.setEnergy(providerEnergyHolder.getEnergy() + this.energyPerTick);
            this.burnProgress += this.burnRate;
            if (this.burnProgress > 1.0) {
                long burnt = (long)this.burnProgress;
                this.burnProgress -= (double)burnt;
                this.fluidContainer.takeFluid(burnt);
            }
        } else {
            ProviderEnergyHolder providerEnergyHolder = this.getEnergyHolder();
            providerEnergyHolder.setEnergy(providerEnergyHolder.getEnergy() + (long)((double)lavaAmount * LavaGeneratorKt.access$getENERGY_PER_MB()));
            this.fluidContainer.clear();
        }
    }

    @TileEntityMenuClass
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/LavaGenerator$LavaGeneratorMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity$GlobalTileEntityMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/energy/LavaGenerator;)V", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "Lorg/jetbrains/annotations/NotNull;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "sideConfigGui", "Lxyz/xenondevs/nova/ui/config/side/SideConfigMenu;", "machines"})
    public final class LavaGeneratorMenu
    extends TileEntity.GlobalTileEntityMenu {
        @NotNull
        private final SideConfigMenu sideConfigGui;
        @NotNull
        private final Gui gui;

        public LavaGeneratorMenu() {
            super((TileEntity)LavaGenerator.this, null, 1, null);
            this.sideConfigGui = new SideConfigMenu((NetworkEndPoint)LavaGenerator.this, null, CollectionsKt.listOf((Object)TuplesKt.to((Object)LavaGenerator.this.fluidContainer, (Object)"container.nova.lava_tank")), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((LavaGeneratorMenu)((Object)this.receiver)).openWindow(p0);
                }
            }, 2, null);
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s # # # # f e |", "| u # # # # f e |", "| # # # # # f e |", "3 - - - - - - - 4"};
            Gui gui2 = ((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)Gui.normal().setStructure(stringArray)).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGui))).addIngredient('u', (Item)new OpenUpgradesItem(LavaGenerator.this.getUpgradeHolder()))).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)LavaGenerator.this.getEnergyHolder()))).addIngredient('f', (Supplier)new FluidBar(3, (FluidHolder)LavaGenerator.this.getFluidHolder(), LavaGenerator.this.fluidContainer))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"normal()\n            .se\u2026er))\n            .build()");
            this.gui = gui2;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }
}

