/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.agriculture;

import java.awt.Color;
import java.util.EnumMap;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.inventory.Inventory;
import xyz.xenondevs.invui.inventory.VirtualInventory;
import xyz.xenondevs.invui.inventory.event.ItemPreUpdateEvent;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nmsutils.particle.ParticleBuilder;
import xyz.xenondevs.nmsutils.particle.ParticleBuilderKt;
import xyz.xenondevs.nova.data.config.GlobalValues;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.item.NovaItem;
import xyz.xenondevs.nova.machines.registry.GuiMaterials;
import xyz.xenondevs.nova.machines.tileentity.agriculture.PlantConfiguration;
import xyz.xenondevs.nova.machines.tileentity.agriculture.TreeFactoryKt;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.StructureIngredientsKt;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigMenu;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeItemDisplay;
import xyz.xenondevs.nova.world.fakeentity.metadata.impl.ItemDisplayMetadata;
import xyz.xenondevs.simpleupgrades.UpgradeFunctionsKt;
import xyz.xenondevs.simpleupgrades.registry.UpgradeTypes;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001*B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020 H\u0016J\b\u0010(\u001a\u00020 H\u0016J\b\u0010)\u001a\u00020 H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006+"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/agriculture/TreeFactory;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "growthProgress", "", "idleTimeLeft", "", "inputInventory", "Lxyz/xenondevs/invui/inventory/VirtualInventory;", "itemHolder", "Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "getItemHolder", "()Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "maxIdleTime", "outputInventory", "plant", "Lxyz/xenondevs/nova/world/fakeentity/impl/FakeItemDisplay;", "plantType", "Lorg/bukkit/Material;", "progressPerTick", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "handleInputInventoryUpdate", "", "event", "Lxyz/xenondevs/invui/inventory/event/ItemPreUpdateEvent;", "handleOutputInventoryUpdate", "handleRemoved", "unload", "", "handleTick", "reload", "updatePlantArmorStand", "TreeFactoryMenu", "machines"})
@SourceDebugExtension(value={"SMAP\nTreeFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeFactory.kt\nxyz/xenondevs/nova/machines/tileentity/agriculture/TreeFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1#2:192\n*E\n"})
public final class TreeFactory
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final VirtualInventory inputInventory;
    @NotNull
    private final VirtualInventory outputInventory;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    @NotNull
    private final NovaItemHolder itemHolder;
    @Nullable
    private Material plantType;
    @NotNull
    private final FakeItemDisplay plant;
    private double progressPerTick;
    private int maxIdleTime;
    private double growthProgress;
    private int idleTimeLeft;

    public TreeFactory(@NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        Object[] objectArray = new int[]{1};
        this.inputInventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"input", (int)1, (int[])objectArray, (boolean)false, (Function1)((Function1)new Function1<ItemPreUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemPreUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                TreeFactory.access$handleInputInventoryUpdate((TreeFactory)((Object)this.receiver), p0);
            }
        }), null, (int)32, null);
        this.outputInventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"output", (int)9, (Function1)((Function1)new Function1<ItemPreUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemPreUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                TreeFactory.access$handleOutputInventoryUpdate((TreeFactory)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        objectArray = new UpgradeType[3];
        objectArray[0] = (int)UpgradeTypes.INSTANCE.getSPEED();
        objectArray[1] = (int)UpgradeTypes.INSTANCE.getEFFICIENCY();
        objectArray[2] = (int)UpgradeTypes.INSTANCE.getENERGY();
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])objectArray);
        this.energyHolder = UpgradeFunctionsKt.ConsumerEnergyHolder((NetworkedTileEntity)this, (Provider)TreeFactoryKt.access$getMAX_ENERGY$p(), (Provider)TreeFactoryKt.access$getENERGY_PER_TICK$p(), null, (UpgradeHolder)this.getUpgradeHolder(), (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ TreeFactory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.BOTTOM, BlockSide.BACK};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }));
        objectArray = new Pair[1];
        objectArray[0] = (int)TuplesKt.to((Object)this.inputInventory, (Object)NetworkConnectionType.INSERT);
        this.itemHolder = NovaItemHolderKt.NovaItemHolder$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.outputInventory, (Object)NetworkConnectionType.EXTRACT), (Pair[])objectArray, null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ TreeFactory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.BOTTOM, BlockSide.BACK};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.BUFFER, blockSideArray);
            }
        }), (int)8, null);
        ItemStack itemStack = this.inputInventory.getItem(0);
        this.plantType = itemStack != null ? itemStack.getType() : null;
        Location location = this.getLocation().clone().add(0.5, 0.0625, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location.clone().add(.5, 1.0 / 16.0, .5)");
        Location plantLocation = location;
        this.plant = new FakeItemDisplay(plantLocation, true, (Function2)1.INSTANCE);
        this.reload();
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    @NotNull
    public NovaItemHolder getItemHolder() {
        return this.itemHolder;
    }

    public void reload() {
        super.reload();
        this.progressPerTick = TreeFactoryKt.access$getPROGRESS_PER_TICK() * ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getSPEED())).doubleValue();
        this.maxIdleTime = (int)((double)TreeFactoryKt.access$getIDLE_TIME() / ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getSPEED())).doubleValue());
    }

    /*
     * WARNING - void declaration
     */
    public void handleTick() {
        if (this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getEnergyConsumption() && this.plantType != null) {
            Object v = TreeFactoryKt.access$getPLANTS$p().get(this.plantType);
            Intrinsics.checkNotNull(v);
            ItemStack plantLoot = ((PlantConfiguration)v).getLoot();
            if (!GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && !this.outputInventory.canHold(plantLoot, new ItemStack[0])) {
                return;
            }
            ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
            consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getEnergyConsumption());
            if (this.idleTimeLeft == 0) {
                if (this.plantType != null) {
                    this.growthProgress += this.progressPerTick;
                    if (this.growthProgress >= 1.0) {
                        this.idleTimeLeft = this.maxIdleTime;
                    }
                    this.updatePlantArmorStand();
                }
            } else {
                int n = this.idleTimeLeft;
                this.idleTimeLeft = n + -1;
                Particle particle = Particles.o;
                Intrinsics.checkNotNullExpressionValue((Object)particle, (String)"DUST");
                NMSUtilsKt.sendTo((Packet)((Packet)ParticleBuilderKt.particle((Particle)particle, (Function1)((Function1)new Function1<ParticleBuilder<ParticleParamRedstone>, Unit>(this){
                    final /* synthetic */ TreeFactory this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ParticleBuilder<ParticleParamRedstone> $this$particle) {
                        void $this$invoke_u24lambda_u240;
                        Location location;
                        Intrinsics.checkNotNullParameter($this$particle, (String)"$this$particle");
                        V v = TreeFactoryKt.access$getPLANTS$p().get(TreeFactory.access$getPlantType$p(this.this$0));
                        Intrinsics.checkNotNull(v);
                        ParticleBuilderKt.color($this$particle, (Color)((PlantConfiguration)v).getColor());
                        Location location2 = this.this$0.getLocation().clone();
                        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"location.clone()");
                        Location location3 = location = LocationUtilsKt.center((Location)location2);
                        ParticleBuilder<ParticleParamRedstone> particleBuilder = $this$particle;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setY($this$invoke_u24lambda_u240.getY() + 0.5);
                        particleBuilder.location(location);
                        $this$particle.offset(0.15, 0.15, 0.15);
                        $this$particle.speed(0.1f);
                        $this$particle.amount(5);
                    }
                }))), (Iterable)this.getViewers());
                if (this.idleTimeLeft == 0) {
                    this.growthProgress = 0.0;
                    int leftover = this.outputInventory.addItem(TileEntity.Companion.getSELF_UPDATE_REASON(), plantLoot);
                    if (GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && leftover > 0) {
                        void $this$handleTick_u24lambda_u240;
                        ItemStack itemStack;
                        ItemStack itemStack2 = itemStack = plantLoot.clone();
                        Location location = this.getCenterLocation();
                        boolean bl = false;
                        $this$handleTick_u24lambda_u240.setAmount(leftover);
                        ItemStack itemStack3 = itemStack;
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"plantLoot.clone().apply { amount = leftover }");
                        LocationUtilsKt.dropItem((Location)location, (ItemStack)itemStack3);
                    }
                }
            }
        }
    }

    private final void updatePlantArmorStand() {
        float size = (float)((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.growthProgress), (ClosedFloatingPointRange)RangesKt.rangeTo((double)0.0, (double)1.0)))).doubleValue();
        this.plant.updateEntityData(true, (Function1)new Function1<ItemDisplayMetadata, Unit>(this, size){
            final /* synthetic */ TreeFactory this$0;
            final /* synthetic */ float $size;
            {
                this.this$0 = $receiver;
                this.$size = $size;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ItemDisplayMetadata $this$updateEntityData) {
                ItemStack itemStack;
                Intrinsics.checkNotNullParameter((Object)$this$updateEntityData, (String)"$this$updateEntityData");
                ItemDisplayMetadata itemDisplayMetadata = $this$updateEntityData;
                Material material = TreeFactory.access$getPlantType$p(this.this$0);
                if (material != null) {
                    void it;
                    Material material2 = material;
                    ItemDisplayMetadata itemDisplayMetadata2 = itemDisplayMetadata;
                    boolean bl = false;
                    V v = TreeFactoryKt.access$getPLANTS$p().get(it);
                    Intrinsics.checkNotNull(v);
                    itemStack = ((PlantConfiguration)v).getMiniature().getClientsideProvider().get();
                    itemDisplayMetadata = itemDisplayMetadata2;
                } else {
                    itemStack = null;
                }
                itemDisplayMetadata.setItemStack(NMSUtilsKt.getNmsCopy(itemStack));
                $this$updateEntityData.setScale(new Vector3f(this.$size, this.$size, this.$size));
                $this$updateEntityData.setTranslation(new Vector3f(0.0f, 0.5f * this.$size, 0.0f));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void handleInputInventoryUpdate(ItemPreUpdateEvent event) {
        if (event.getNewItem() != null) {
            Set set = TreeFactoryKt.access$getPLANTS$p().keySet();
            ItemStack itemStack = event.getNewItem();
            Intrinsics.checkNotNull((Object)itemStack);
            if (!set.contains(itemStack.getType())) {
                event.setCancelled(true);
                return;
            }
        }
        ItemStack itemStack = event.getNewItem();
        this.plantType = itemStack != null ? itemStack.getType() : null;
        this.growthProgress = 0.0;
        this.updatePlantArmorStand();
    }

    private final void handleOutputInventoryUpdate(ItemPreUpdateEvent event) {
        event.setCancelled(!Intrinsics.areEqual((Object)event.getUpdateReason(), (Object)TileEntity.Companion.getSELF_UPDATE_REASON()) && !event.isRemove());
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        this.plant.remove();
    }

    public static final /* synthetic */ Material access$getPlantType$p(TreeFactory $this) {
        return $this.plantType;
    }

    public static final /* synthetic */ void access$handleInputInventoryUpdate(TreeFactory $this, ItemPreUpdateEvent event) {
        $this.handleInputInventoryUpdate(event);
    }

    public static final /* synthetic */ void access$handleOutputInventoryUpdate(TreeFactory $this, ItemPreUpdateEvent event) {
        $this.handleOutputInventoryUpdate(event);
    }

    @TileEntityMenuClass
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0083\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/agriculture/TreeFactory$TreeFactoryMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity$GlobalTileEntityMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/agriculture/TreeFactory;)V", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "Lorg/jetbrains/annotations/NotNull;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "sideConfigGui", "Lxyz/xenondevs/nova/ui/config/side/SideConfigMenu;", "machines"})
    private final class TreeFactoryMenu
    extends TileEntity.GlobalTileEntityMenu {
        @NotNull
        private final SideConfigMenu sideConfigGui;
        @NotNull
        private final Gui gui;

        public TreeFactoryMenu() {
            super((TileEntity)TreeFactory.this, null, 1, null);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TreeFactory.this.getItemHolder().getNetworkedInventory(TreeFactory.this.inputInventory), (Object)"inventory.nova.input"), TuplesKt.to((Object)TreeFactory.this.getItemHolder().getNetworkedInventory(TreeFactory.this.outputInventory), (Object)"inventory.nova.output")};
            this.sideConfigGui = new SideConfigMenu((NetworkEndPoint)TreeFactory.this, CollectionsKt.listOf((Object[])pairArray), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((TreeFactoryMenu)((Object)this.receiver)).openWindow(p0);
                }
            });
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s u # # # # e |", "| # # # o o o e |", "| # i # o o o e |", "| # # # o o o e |", "3 - - - - - - - 4"};
            Gui.Builder builder = Gui.normal().setStructure(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"normal()\n            .se\u2026     \"3 - - - - - - - 4\")");
            pairArray = ((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)StructureIngredientsKt.addIngredient((Gui.Builder)builder, (char)'i', (Inventory)((Inventory)TreeFactory.this.inputInventory), (NovaItem)GuiMaterials.INSTANCE.getSAPLING_PLACEHOLDER())).addIngredient('o', (Inventory)TreeFactory.this.outputInventory)).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGui))).addIngredient('u', (Item)new OpenUpgradesItem(TreeFactory.this.getUpgradeHolder()))).addIngredient('e', (Supplier)new EnergyBar(4, (NovaEnergyHolder)TreeFactory.this.getEnergyHolder()))).build();
            Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"normal()\n            .se\u2026er))\n            .build()");
            this.gui = pairArray;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }
}

