/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.agriculture;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.inventory.Inventory;
import xyz.xenondevs.invui.inventory.VirtualInventory;
import xyz.xenondevs.invui.inventory.event.ItemPreUpdateEvent;
import xyz.xenondevs.invui.inventory.event.UpdateReason;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nova.api.NovaEventFactory;
import xyz.xenondevs.nova.data.config.GlobalValues;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.integration.protection.ProtectionManager;
import xyz.xenondevs.nova.item.NovaItem;
import xyz.xenondevs.nova.item.tool.ToolCategory;
import xyz.xenondevs.nova.item.tool.VanillaToolCategories;
import xyz.xenondevs.nova.machines.registry.GuiMaterials;
import xyz.xenondevs.nova.machines.tileentity.agriculture.HarvestPriorityComparator;
import xyz.xenondevs.nova.machines.tileentity.agriculture.HarvesterKt;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.StructureIngredientsKt;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigMenu;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.InventoryUtilsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.item.DamageableUtils;
import xyz.xenondevs.nova.util.item.PlantUtils;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.block.context.BlockBreakContext;
import xyz.xenondevs.nova.world.region.Region;
import xyz.xenondevs.nova.world.region.UpgradableRegion;
import xyz.xenondevs.nova.world.region.VisualRegion;
import xyz.xenondevs.simpleupgrades.UpgradeFunctionsKt;
import xyz.xenondevs.simpleupgrades.registry.UpgradeTypes;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u00010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010,\u001a\u00020#H\u0016J\b\u0010-\u001a\u00020#H\u0002J\b\u0010.\u001a\u00020#H\u0002J\b\u0010/\u001a\u00020#H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00061"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/agriculture/Harvester;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "axeInventory", "Lxyz/xenondevs/invui/inventory/VirtualInventory;", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "hoeInventory", "inventory", "itemHolder", "Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "getItemHolder", "()Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "loadCooldown", "", "maxIdleTime", "queuedBlocks", "Ljava/util/LinkedList;", "Lkotlin/Pair;", "Lorg/bukkit/block/Block;", "Lorg/bukkit/Material;", "region", "Lxyz/xenondevs/nova/world/region/UpgradableRegion;", "shearInventory", "timePassed", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "handleAxeInventoryUpdate", "", "event", "Lxyz/xenondevs/invui/inventory/event/ItemPreUpdateEvent;", "handleHoeInventoryUpdate", "handleInventoryUpdate", "handleRemoved", "unload", "", "handleShearInventoryUpdate", "handleTick", "harvestNextBlock", "loadBlocks", "reload", "HarvesterMenu", "machines"})
@SourceDebugExtension(value={"SMAP\nHarvester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Harvester.kt\nxyz/xenondevs/nova/machines/tileentity/agriculture/Harvester\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,281:1\n766#2:282\n857#2,2:283\n1549#2:285\n1620#2,3:286\n*S KotlinDebug\n*F\n+ 1 Harvester.kt\nxyz/xenondevs/nova/machines/tileentity/agriculture/Harvester\n*L\n107#1:282\n107#1:283,2\n109#1:285\n109#1:286,3\n*E\n"})
public final class Harvester
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final VirtualInventory inventory;
    @NotNull
    private final VirtualInventory shearInventory;
    @NotNull
    private final VirtualInventory axeInventory;
    @NotNull
    private final VirtualInventory hoeInventory;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    @NotNull
    private final NovaItemHolder itemHolder;
    private int maxIdleTime;
    @NotNull
    private final UpgradableRegion region;
    @NotNull
    private final LinkedList<Pair<Block, Material>> queuedBlocks;
    private int timePassed;
    private int loadCooldown;

    public Harvester(@NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.inventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"harvest", (int)12, (Function1)((Function1)new Function1<ItemPreUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemPreUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Harvester.access$handleInventoryUpdate((Harvester)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        this.shearInventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"shears", (int)1, (Function1)((Function1)new Function1<ItemPreUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemPreUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Harvester.access$handleShearInventoryUpdate((Harvester)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        this.axeInventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"axe", (int)1, (Function1)((Function1)new Function1<ItemPreUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemPreUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Harvester.access$handleAxeInventoryUpdate((Harvester)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        this.hoeInventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"hoe", (int)1, (Function1)((Function1)new Function1<ItemPreUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemPreUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Harvester.access$handleHoeInventoryUpdate((Harvester)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        UpgradeType[] upgradeTypeArray = new UpgradeType[]{UpgradeTypes.INSTANCE.getSPEED(), UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getENERGY(), UpgradeTypes.INSTANCE.getRANGE()};
        this.upgradeHolder = this.getUpgradeHolder(upgradeTypeArray);
        this.energyHolder = UpgradeFunctionsKt.ConsumerEnergyHolder((NetworkedTileEntity)this, (Provider)HarvesterKt.access$getMAX_ENERGY$p(), (Provider)HarvesterKt.access$getENERGY_PER_TICK$p(), (Provider)HarvesterKt.access$getENERGY_PER_BREAK$p(), (UpgradeHolder)this.getUpgradeHolder(), (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ Harvester this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }));
        upgradeTypeArray = new Pair[]{TuplesKt.to((Object)this.shearInventory, (Object)NetworkConnectionType.INSERT), TuplesKt.to((Object)this.axeInventory, (Object)NetworkConnectionType.INSERT), TuplesKt.to((Object)this.hoeInventory, (Object)NetworkConnectionType.INSERT)};
        this.itemHolder = NovaItemHolderKt.NovaItemHolder$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.inventory, (Object)NetworkConnectionType.EXTRACT), (Pair[])upgradeTypeArray, null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ Harvester this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.BUFFER, blockSideArray);
            }
        }), (int)8, null);
        this.region = this.getUpgradableRegion(UpgradeTypes.INSTANCE.getRANGE(), HarvesterKt.access$getMIN_RANGE$p(), HarvesterKt.access$getMAX_RANGE$p(), HarvesterKt.access$getDEFAULT_RANGE(), (Function1)new Function1<Integer, Region>(this){
            final /* synthetic */ Harvester this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Region invoke(int it) {
                return this.this$0.getBlockFrontRegion(it, it, it * 2, 0);
            }
        });
        this.queuedBlocks = new LinkedList();
        this.reload();
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    @NotNull
    public NovaItemHolder getItemHolder() {
        return this.itemHolder;
    }

    public void reload() {
        super.reload();
        this.maxIdleTime = (int)((double)HarvesterKt.access$getIDLE_TIME() / ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getSPEED())).doubleValue());
        if (this.timePassed > this.maxIdleTime) {
            this.timePassed = this.maxIdleTime;
        }
    }

    public void handleTick() {
        if (this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getEnergyConsumption()) {
            ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
            consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getEnergyConsumption());
            if (this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getSpecialEnergyConsumption()) {
                int n = this.loadCooldown;
                this.loadCooldown = n + -1;
                n = this.timePassed;
                this.timePassed = n + 1;
                if (n >= this.maxIdleTime) {
                    this.timePassed = 0;
                    if (!GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && this.inventory.isFull()) {
                        return;
                    }
                    if (this.queuedBlocks.isEmpty()) {
                        this.loadBlocks();
                    }
                    this.harvestNextBlock();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadBlocks() {
        if (this.loadCooldown <= 0) {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            this.loadCooldown = 100;
            Collection collection = this.queuedBlocks;
            Iterable iterable = this.region.getBlocks();
            PlantUtils plantUtils = PlantUtils.INSTANCE;
            boolean $i$f$filter22 = false;
            void var5_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Block p0 = (Block)element$iv$iv;
                boolean bl = false;
                if (!plantUtils.isHarvestable(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)HarvestPriorityComparator.INSTANCE);
            boolean $i$f$map = false;
            Iterable $i$f$filter22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object element$iv$iv;
                element$iv$iv = (Block)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl = false;
                collection2.add(TuplesKt.to((Object)it, (Object)it.getType()));
            }
            iterable = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
    }

    private final void harvestNextBlock() {
        boolean tryAgain;
        do {
            tryAgain = false;
            if (!(!((Collection)this.queuedBlocks).isEmpty())) continue;
            Pair<Block, Material> pair = this.queuedBlocks.getFirst();
            Block block = (Block)pair.component1();
            Material expectedType = (Material)pair.component2();
            this.queuedBlocks.removeFirst();
            if (block.getType() == expectedType) {
                VirtualInventory toolInventory;
                VirtualInventory virtualInventory = toolInventory = Tag.LEAVES.isTagged((Keyed)expectedType) ? (this.shearInventory.isEmpty() ? this.hoeInventory : this.shearInventory) : (Tag.MINEABLE_AXE.isTagged((Keyed)expectedType) ? this.axeInventory : (Tag.MINEABLE_HOE.isTagged((Keyed)expectedType) ? this.hoeInventory : null));
                ItemStack tool = virtualInventory != null ? virtualInventory.getItem(0) : null;
                TileEntity tileEntity = (TileEntity)this;
                Location location = block.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"block.location");
                if (!((Boolean)ProtectionManager.INSTANCE.canBreak(tileEntity, tool, location).get()).booleanValue()) {
                    tryAgain = true;
                    continue;
                }
                BlockBreakContext ctx = new BlockBreakContext(BlockPosKt.getPos((Block)block), (Object)this, this.getLocation(), null, tool);
                List list = PlantUtils.INSTANCE.getHarvestDrops(ctx);
                Intrinsics.checkNotNull((Object)list);
                List drops = CollectionsKt.toMutableList((Collection)list);
                if (!GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && !this.inventory.canHold(drops)) {
                    tryAgain = true;
                    continue;
                }
                if (toolInventory != null) {
                    if (tool == null) {
                        tryAgain = true;
                        continue;
                    }
                    toolInventory.setItem(TileEntity.Companion.getSELF_UPDATE_REASON(), 0, DamageableUtils.damageItem$default((DamageableUtils)DamageableUtils.INSTANCE, (ItemStack)tool, (int)0, (int)2, null));
                }
                PlantUtils.INSTANCE.harvest(ctx, true);
                NovaEventFactory.INSTANCE.callTileEntityBlockBreakEvent((TileEntity)this, block, drops);
                if (this.inventory.canHold(drops)) {
                    InventoryUtilsKt.addAll((VirtualInventory)this.inventory, (UpdateReason)TileEntity.Companion.getSELF_UPDATE_REASON(), (List)drops);
                } else if (GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND()) {
                    World world = this.getWorld();
                    Location location2 = block.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"block.location");
                    LocationUtilsKt.dropItemsNaturally((World)world, (Location)location2, (Iterable)drops);
                }
                ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
                consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getSpecialEnergyConsumption());
                continue;
            }
            tryAgain = true;
        } while (tryAgain);
    }

    private final void handleInventoryUpdate(ItemPreUpdateEvent event) {
        event.setCancelled(!Intrinsics.areEqual((Object)event.getUpdateReason(), (Object)TileEntity.Companion.getSELF_UPDATE_REASON()) && event.isAdd());
    }

    /*
     * Unable to fully structure code
     */
    private final void handleShearInventoryUpdate(ItemPreUpdateEvent event) {
        if (event.getNewItem() == null) ** GOTO lbl-1000
        v0 = event.getNewItem();
        if ((v0 != null ? v0.getType() : null) != Material.SHEARS) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        event.setCancelled(v1);
    }

    private final void handleAxeInventoryUpdate(ItemPreUpdateEvent event) {
        event.setCancelled(event.getNewItem() != null && !Intrinsics.areEqual((Object)ToolCategory.Companion.ofItem(event.getNewItem()), (Object)VanillaToolCategories.INSTANCE.getAXE()));
    }

    private final void handleHoeInventoryUpdate(ItemPreUpdateEvent event) {
        event.setCancelled(event.getNewItem() != null && !Intrinsics.areEqual((Object)ToolCategory.Companion.ofItem(event.getNewItem()), (Object)VanillaToolCategories.INSTANCE.getHOE()));
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        VisualRegion.INSTANCE.removeRegion(this.getUuid());
    }

    public static final /* synthetic */ void access$handleInventoryUpdate(Harvester $this, ItemPreUpdateEvent event) {
        $this.handleInventoryUpdate(event);
    }

    public static final /* synthetic */ void access$handleShearInventoryUpdate(Harvester $this, ItemPreUpdateEvent event) {
        $this.handleShearInventoryUpdate(event);
    }

    public static final /* synthetic */ void access$handleAxeInventoryUpdate(Harvester $this, ItemPreUpdateEvent event) {
        $this.handleAxeInventoryUpdate(event);
    }

    public static final /* synthetic */ void access$handleHoeInventoryUpdate(Harvester $this, ItemPreUpdateEvent event) {
        $this.handleHoeInventoryUpdate(event);
    }

    @TileEntityMenuClass
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/agriculture/Harvester$HarvesterMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity$IndividualTileEntityMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "player", "Lorg/bukkit/entity/Player;", "(Lxyz/xenondevs/nova/machines/tileentity/agriculture/Harvester;Lorg/bukkit/entity/Player;)V", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "Lorg/jetbrains/annotations/NotNull;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "sideConfigGui", "Lxyz/xenondevs/nova/ui/config/side/SideConfigMenu;", "machines"})
    public final class HarvesterMenu
    extends TileEntity.IndividualTileEntityMenu {
        @NotNull
        private final SideConfigMenu sideConfigGui;
        @NotNull
        private final Gui gui;

        public HarvesterMenu(Player player2) {
            Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
            super((TileEntity)Harvester.this, player2, null, 2, null);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Harvester.this.getItemHolder().getNetworkedInventory(Harvester.this.inventory), (Object)"inventory.nova.output"), TuplesKt.to((Object)Harvester.this.getItemHolder().getNetworkedInventory(Harvester.this.shearInventory), (Object)"inventory.machines.shears"), TuplesKt.to((Object)Harvester.this.getItemHolder().getNetworkedInventory(Harvester.this.axeInventory), (Object)"inventory.machines.axes"), TuplesKt.to((Object)Harvester.this.getItemHolder().getNetworkedInventory(Harvester.this.hoeInventory), (Object)"inventory.machines.hoes")};
            this.sideConfigGui = new SideConfigMenu((NetworkEndPoint)Harvester.this, CollectionsKt.listOf((Object[])pairArray), (Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((HarvesterMenu)((Object)this.receiver)).openWindow();
                }
            });
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| c v u s a h e |", "| m n p # # # e |", "| i i i i i i e |", "| i i i i i i e |", "3 - - - - - - - 4"};
            Gui.Builder builder = ((Gui.Builder.Normal)((Gui.Builder.Normal)Gui.normal().setStructure(stringArray)).addIngredient('i', (Inventory)Harvester.this.inventory)).addIngredient('c', (Item)new OpenSideConfigItem(this.sideConfigGui));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"normal()\n            .se\u2026onfigItem(sideConfigGui))");
            Gui.Builder builder2 = StructureIngredientsKt.addIngredient((Gui.Builder)builder, (char)'s', (Inventory)((Inventory)Harvester.this.shearInventory), (NovaItem)GuiMaterials.INSTANCE.getSHEARS_PLACEHOLDER());
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"normal()\n            .se\u2026rials.SHEARS_PLACEHOLDER)");
            Gui.Builder builder3 = StructureIngredientsKt.addIngredient((Gui.Builder)builder2, (char)'a', (Inventory)((Inventory)Harvester.this.axeInventory), (NovaItem)GuiMaterials.INSTANCE.getAXE_PLACEHOLDER());
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"normal()\n            .se\u2026aterials.AXE_PLACEHOLDER)");
            pairArray = ((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)StructureIngredientsKt.addIngredient((Gui.Builder)builder3, (char)'h', (Inventory)((Inventory)Harvester.this.hoeInventory), (NovaItem)GuiMaterials.INSTANCE.getHOE_PLACEHOLDER())).addIngredient('v', (Item)Harvester.this.region.createVisualizeRegionItem(player2))).addIngredient('p', (Item)Harvester.this.region.getIncreaseSizeItem())).addIngredient('m', (Item)Harvester.this.region.getDecreaseSizeItem())).addIngredient('n', (Item)Harvester.this.region.getDisplaySizeItem())).addIngredient('u', (Item)new OpenUpgradesItem(Harvester.this.getUpgradeHolder()))).addIngredient('e', (Supplier)new EnergyBar(4, (NovaEnergyHolder)Harvester.this.getEnergyHolder()))).build();
            Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"normal()\n            .se\u2026er))\n            .build()");
            this.gui = pairArray;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }
}

