/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.addon.machines.tileentity.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nmsutils.particle.ParticleBuilderKt;
import xyz.xenondevs.nova.addon.machines.tileentity.world.Sprinkler;
import xyz.xenondevs.nova.addon.machines.tileentity.world.SprinklerKt;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeFunctionsKt;
import xyz.xenondevs.nova.addon.simpleupgrades.registry.UpgradeTypes;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.fluid.FluidType;
import xyz.xenondevs.nova.tileentity.network.fluid.container.FluidContainer;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.FluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.FluidBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigMenu;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.region.Region;
import xyz.xenondevs.nova.world.region.UpgradableRegion;
import xyz.xenondevs.nova.world.region.VisualRegion;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/world/Sprinkler;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "fluidHolder", "Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "getFluidHolder", "()Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "region", "Lxyz/xenondevs/nova/world/region/UpgradableRegion;", "tank", "Lxyz/xenondevs/nova/tileentity/network/fluid/container/FluidContainer;", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "waterPerMoistureLevel", "", "handleRemoved", "", "unload", "", "reload", "Companion", "SprinklerMenu", "machines"})
public final class Sprinkler
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final FluidContainer tank;
    @NotNull
    private final NovaFluidHolder fluidHolder;
    private long waterPerMoistureLevel;
    @NotNull
    private final UpgradableRegion region;
    @NotNull
    private static final ArrayList<Sprinkler> sprinklers = new ArrayList();

    public Sprinkler(@NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        Object[] objectArray = new UpgradeType[]{UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getFLUID(), UpgradeTypes.INSTANCE.getRANGE()};
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])objectArray);
        objectArray = new FluidType[]{FluidType.WATER};
        this.tank = UpgradeFunctionsKt.getFluidContainer$default((TileEntity)((TileEntity)this), (String)"tank", (Set)SetsKt.hashSetOf((Object[])objectArray), (Provider)SprinklerKt.access$getWATER_CAPACITY$p(), (long)0L, null, (UpgradeHolder)this.getUpgradeHolder(), (boolean)false, (int)88, null);
        this.fluidHolder = NovaFluidHolderKt.NovaFluidHolder$default((DataHolder)((DataHolder)this), (Pair)TuplesKt.to((Object)this.tank, (Object)NetworkConnectionType.BUFFER), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ Sprinkler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.BOTTOM};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }), (int)8, null);
        this.region = this.getUpgradableRegion(UpgradeTypes.INSTANCE.getRANGE(), SprinklerKt.access$getMIN_RANGE$p(), SprinklerKt.access$getMAX_RANGE$p(), SprinklerKt.access$getDEFAULT_RANGE(), (Function1)new Function1<Integer, Region>(this){
            final /* synthetic */ Sprinkler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Region invoke(int it) {
                double d = (double)it + 0.5;
                Location location = LocationUtilsKt.center((Location)this.this$0.getLocation()).add(-d, -1.0, -d);
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
                Location location2 = LocationUtilsKt.center((Location)this.this$0.getLocation()).add(d, 0.0, d);
                Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"add(...)");
                return new Region(location, location2);
            }
        });
        this.reload();
        ((Collection)sprinklers).add(this);
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public NovaFluidHolder getFluidHolder() {
        return this.fluidHolder;
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        ((Collection)sprinklers).remove((Object)this);
        VisualRegion.INSTANCE.removeRegion(this.getUuid());
    }

    public void reload() {
        super.reload();
        this.waterPerMoistureLevel = MathKt.roundToLong((double)((double)SprinklerKt.access$getWATER_PER_MOISTURE_LEVEL() / ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getEFFICIENCY())).doubleValue()));
    }

    static {
        EventUtilsKt.registerEvents((Listener)Companion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/world/Sprinkler$Companion;", "Lorg/bukkit/event/Listener;", "()V", "sprinklers", "Ljava/util/ArrayList;", "Lxyz/xenondevs/nova/addon/machines/tileentity/world/Sprinkler;", "Lkotlin/collections/ArrayList;", "handleBlockPhysics", "", "event", "Lorg/bukkit/event/block/BlockPhysicsEvent;", "showWaterParticles", "block", "Lorg/bukkit/block/Block;", "players", "", "Lorg/bukkit/entity/Player;", "machines"})
    @SourceDebugExtension(value={"SMAP\nSprinkler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sprinkler.kt\nxyz/xenondevs/nova/addon/machines/tileentity/world/Sprinkler$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
    public static final class Companion
    implements Listener {
        private Companion() {
        }

        @EventHandler
        public final void handleBlockPhysics(@NotNull BlockPhysicsEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getChangedType() == Material.FARMLAND && Intrinsics.areEqual((Object)event.getBlock(), (Object)event.getSourceBlock())) {
                Block block = event.getBlock();
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
                Block block2 = block;
                Location location = block2.getLocation().add(0.5, 0.5, 0.5);
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
                Location location2 = location;
                BlockData blockData = block2.getBlockData();
                Intrinsics.checkNotNull((Object)blockData, (String)"null cannot be cast to non-null type org.bukkit.block.data.type.Farmland");
                Farmland farmland = (Farmland)blockData;
                if (farmland.getMoisture() >= farmland.getMaximumMoisture()) {
                    return;
                }
                int requiredMoisture = farmland.getMaximumMoisture() - farmland.getMoisture();
                int addedMoisture = 0;
                for (Sprinkler sprinkler : sprinklers) {
                    Intrinsics.checkNotNull((Object)((Object)sprinkler));
                    if (!sprinkler.region.contains(location2)) continue;
                    int moistureFromSprinkler = Math.min(requiredMoisture - addedMoisture, (int)(sprinkler.tank.getAmount() / sprinkler.waterPerMoistureLevel));
                    sprinkler.tank.takeFluid((long)moistureFromSprinkler * sprinkler.waterPerMoistureLevel);
                    if ((addedMoisture += moistureFromSprinkler) != requiredMoisture) continue;
                }
                if (addedMoisture > 0) {
                    farmland.setMoisture(farmland.getMoisture() + addedMoisture);
                    block2.setBlockData((BlockData)farmland, false);
                    this.showWaterParticles(block2, ((Sprinkler)((Object)sprinklers.get(0))).getViewers());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void showWaterParticles(Block block, List<? extends Player> players) {
            void $this$showWaterParticles_u24lambda_u240;
            Location location;
            ParticleType particleType = Particles.aj;
            Intrinsics.checkNotNullExpressionValue((Object)particleType, (String)"SPLASH");
            Location location2 = location = block.getLocation();
            Particle particle = (Particle)particleType;
            boolean bl = false;
            $this$showWaterParticles_u24lambda_u240.add(0.5, 1.0, 0.5);
            Location location3 = location;
            Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"apply(...)");
            NMSUtilsKt.sendTo((Packet)((Packet)ParticleBuilderKt.particle((Particle)particle, (Location)location3, (Function1)showWaterParticles.2.INSTANCE)), (Iterable)players);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @TileEntityMenuClass
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/world/Sprinkler$SprinklerMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity$IndividualTileEntityMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "player", "Lorg/bukkit/entity/Player;", "(Lxyz/xenondevs/nova/addon/machines/tileentity/world/Sprinkler;Lorg/bukkit/entity/Player;)V", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "Lorg/jetbrains/annotations/NotNull;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "sideConfigGui", "Lxyz/xenondevs/nova/ui/config/side/SideConfigMenu;", "machines"})
    public final class SprinklerMenu
    extends TileEntity.IndividualTileEntityMenu {
        @NotNull
        private final SideConfigMenu sideConfigGui;
        @NotNull
        private final Gui gui;

        public SprinklerMenu(Player player2) {
            Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
            super((TileEntity)Sprinkler.this, player2, null, 2, null);
            this.sideConfigGui = new SideConfigMenu((NetworkEndPoint)Sprinkler.this, null, CollectionsKt.listOf((Object)TuplesKt.to((Object)Sprinkler.this.tank, (Object)"container.nova.fluid_tank")), (Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((SprinklerMenu)((Object)this.receiver)).openWindow();
                }
            }, 2, null);
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s # # f # # p |", "| u # # f # # d |", "| v # # f # # m |", "3 - - - - - - - 4"};
            Gui gui2 = ((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)Gui.normal().setStructure(stringArray)).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGui))).addIngredient('u', (Item)new OpenUpgradesItem(Sprinkler.this.getUpgradeHolder()))).addIngredient('v', (Item)Sprinkler.this.region.createVisualizeRegionItem(player2))).addIngredient('p', (Item)Sprinkler.this.region.getIncreaseSizeItem())).addIngredient('m', (Item)Sprinkler.this.region.getDecreaseSizeItem())).addIngredient('d', (Item)Sprinkler.this.region.getDisplaySizeItem())).addIngredient('f', (Supplier)new FluidBar(3, (FluidHolder)Sprinkler.this.getFluidHolder(), Sprinkler.this.tank))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"build(...)");
            this.gui = gui2;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }
}

