/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.addon.machines.tileentity.world;

import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.inventory.Inventory;
import xyz.xenondevs.invui.inventory.VirtualInventory;
import xyz.xenondevs.invui.inventory.event.ItemPreUpdateEvent;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nova.addon.machines.tileentity.world.BlockBreakerKt;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeFunctionsKt;
import xyz.xenondevs.nova.addon.simpleupgrades.registry.UpgradeTypes;
import xyz.xenondevs.nova.api.NovaEventFactory;
import xyz.xenondevs.nova.data.config.GlobalValues;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.integration.protection.ProtectionManager;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigMenu;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.BlockUtilsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.nova.util.item.ToolUtils;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.block.context.BlockBreakContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001&B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u001eH\u0016J\b\u0010%\u001a\u00020\u001eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006'"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/world/BlockBreaker;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "breakProgress", "", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "entityId", "", "inventory", "Lxyz/xenondevs/invui/inventory/VirtualInventory;", "itemHolder", "Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "getItemHolder", "()Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "lastType", "Lorg/bukkit/Material;", "targetBlock", "Lorg/bukkit/block/Block;", "Lorg/jetbrains/annotations/NotNull;", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "handleInventoryUpdate", "", "event", "Lxyz/xenondevs/invui/inventory/event/ItemPreUpdateEvent;", "handleRemoved", "unload", "", "handleTick", "saveData", "BlockBreakerMenu", "machines"})
@SourceDebugExtension(value={"SMAP\nBlockBreaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockBreaker.kt\nxyz/xenondevs/nova/addon/machines/tileentity/world/BlockBreaker\n+ 2 DataHolder.kt\nxyz/xenondevs/nova/data/serialization/DataHolder\n+ 3 Compound.kt\nxyz/xenondevs/cbf/Compound\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n30#2:156\n47#2:157\n73#2,3:159\n47#3:158\n1855#4,2:162\n*S KotlinDebug\n*F\n+ 1 BlockBreaker.kt\nxyz/xenondevs/nova/addon/machines/tileentity/world/BlockBreaker\n*L\n55#1:156\n55#1:157\n59#1:159,3\n55#1:158\n111#1:162,2\n*E\n"})
public final class BlockBreaker
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final VirtualInventory inventory;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    @NotNull
    private final NovaItemHolder itemHolder;
    private final int entityId;
    @NotNull
    private final Block targetBlock;
    @Nullable
    private Material lastType;
    private double breakProgress;

    /*
     * WARNING - void declaration
     */
    public BlockBreaker(@NotNull NovaTileEntityState blockState) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.inventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"inventory", (int)9, (Function1)((Function1)new Function1<ItemPreUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemPreUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                BlockBreaker.access$handleInventoryUpdate((BlockBreaker)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        DataHolder dataHolder = new DataHolder[]{UpgradeTypes.INSTANCE.getSPEED(), UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getENERGY()};
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])dataHolder);
        this.energyHolder = UpgradeFunctionsKt.ConsumerEnergyHolder((NetworkedTileEntity)this, (Provider)BlockBreakerKt.access$getMAX_ENERGY$p(), (Provider)BlockBreakerKt.access$getENERGY_PER_TICK$p(), null, (UpgradeHolder)this.getUpgradeHolder(), (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ BlockBreaker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }));
        this.itemHolder = NovaItemHolderKt.NovaItemHolder$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.inventory, (Object)NetworkConnectionType.EXTRACT), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ BlockBreaker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        }), (int)8, null);
        this.entityId = this.getUuid().hashCode();
        Location location = this.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
        Block block = LocationUtilsKt.advance$default((Location)location, (BlockFace)this.getFace(BlockSide.FRONT), (double)0.0, (int)2, null).getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        this.targetBlock = block;
        BlockBreaker blockBreaker = this;
        dataHolder = (DataHolder)this;
        String key$iv = "breakProgress";
        boolean $i$f$retrieveData = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$retrieveDataOrNull = false;
        Compound this_$iv$iv$iv = this_$iv$iv.getData();
        boolean $i$f$get = false;
        Object object = this_$iv$iv$iv.get(Reflection.typeOf(Double.TYPE), key$iv);
        if (object == null) {
            this_$iv$iv$iv = this_$iv$iv.getGlobalData();
            $i$f$get = false;
            object = this_$iv$iv$iv.get(Reflection.typeOf(Double.TYPE), key$iv);
        }
        Object object2 = object;
        if (object == null) {
            BlockBreaker blockBreaker2 = blockBreaker;
            boolean bl = false;
            object2 = 0.0;
            blockBreaker = blockBreaker2;
        }
        blockBreaker.breakProgress = ((Number)object2).doubleValue();
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    @NotNull
    public NovaItemHolder getItemHolder() {
        return this.itemHolder;
    }

    /*
     * WARNING - void declaration
     */
    public void saveData() {
        void key$iv;
        super.saveData();
        String string = "breakProgress";
        Double value$iv = this.breakProgress;
        boolean global$iv = false;
        boolean $i$f$storeData = false;
        ((DataHolder)this).storeData(Reflection.typeOf(Double.TYPE), (String)key$iv, (Object)value$iv, global$iv);
    }

    private final void handleInventoryUpdate(ItemPreUpdateEvent event) {
        if (event.isAdd() && !Intrinsics.areEqual((Object)event.getUpdateReason(), (Object)TileEntity.Companion.getSELF_UPDATE_REASON())) {
            event.setCancelled(true);
        }
    }

    public void handleTick() {
        Material material = this.targetBlock.getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
        Material type = material;
        if (this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getEnergyConsumption() && !MaterialUtilsKt.isTraversable((Material)type) && BlockUtilsKt.getHardness((Block)this.targetBlock) >= 0.0) {
            TileEntity tileEntity = (TileEntity)this;
            Location location = this.targetBlock.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
            Object t = ProtectionManager.INSTANCE.canBreak(tileEntity, null, location).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            if (((Boolean)t).booleanValue()) {
                ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
                consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getEnergyConsumption());
                if (this.lastType != null && type != this.lastType) {
                    this.breakProgress = 0.0;
                }
                this.lastType = type;
                double damage = RangesKt.coerceAtMost((double)ToolUtils.INSTANCE.calculateDamage(BlockUtilsKt.getHardness((Block)this.targetBlock), true, true, BlockBreakerKt.access$getBREAK_SPEED_MULTIPLIER() * ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getSPEED())).doubleValue(), 0, true, false, 0, 0), (double)BlockBreakerKt.access$getBREAK_SPEED_CLAMP());
                this.breakProgress = Math.min(1.0, this.breakProgress + damage);
                if (this.breakProgress >= 1.0) {
                    BlockBreakContext ctx = new BlockBreakContext(BlockPosKt.getPos((Block)this.targetBlock), (Object)this, this.getLocation(), null, null, 24, null);
                    List drops = CollectionsKt.toMutableList((Collection)BlockUtilsKt.getAllDrops((Block)this.targetBlock, (BlockBreakContext)ctx));
                    NovaEventFactory.INSTANCE.callTileEntityBlockBreakEvent((TileEntity)this, this.targetBlock, drops);
                    if (!GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && !this.inventory.canHold(drops)) {
                        return;
                    }
                    this.breakProgress = 0.0;
                    BlockUtilsKt.setBreakStage((Block)this.targetBlock, (int)this.entityId, (int)-1);
                    BlockUtilsKt.remove$default((Block)this.targetBlock, (BlockBreakContext)ctx, (boolean)false, (int)2, null);
                    Iterable $this$forEach$iv = drops;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ItemStack drop = (ItemStack)element$iv;
                        boolean bl = false;
                        int amountLeft = this.inventory.addItem(TileEntity.Companion.getSELF_UPDATE_REASON(), drop);
                        if (!GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() || amountLeft == 0) continue;
                        drop.setAmount(amountLeft);
                        World world = this.getWorld();
                        Location location2 = this.targetBlock.getLocation();
                        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"getLocation(...)");
                        world.dropItemNaturally(LocationUtilsKt.center((Location)location2), drop);
                    }
                } else {
                    BlockUtilsKt.setBreakStage((Block)this.targetBlock, (int)this.entityId, (int)MathKt.roundToInt((double)(this.breakProgress * (double)9)));
                }
            }
        }
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        if (!unload) {
            BlockUtilsKt.setBreakStage((Block)this.targetBlock, (int)this.entityId, (int)-1);
        }
    }

    public static final /* synthetic */ void access$handleInventoryUpdate(BlockBreaker $this, ItemPreUpdateEvent event) {
        $this.handleInventoryUpdate(event);
    }

    @TileEntityMenuClass
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/world/BlockBreaker$BlockBreakerMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity$GlobalTileEntityMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/addon/machines/tileentity/world/BlockBreaker;)V", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "Lorg/jetbrains/annotations/NotNull;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "sideConfigGui", "Lxyz/xenondevs/nova/ui/config/side/SideConfigMenu;", "machines"})
    public final class BlockBreakerMenu
    extends TileEntity.GlobalTileEntityMenu {
        @NotNull
        private final SideConfigMenu sideConfigGui;
        @NotNull
        private final Gui gui;

        public BlockBreakerMenu() {
            super((TileEntity)BlockBreaker.this, null, 1, null);
            this.sideConfigGui = new SideConfigMenu((NetworkEndPoint)BlockBreaker.this, CollectionsKt.listOf((Object)new Pair((Object)BlockBreaker.this.getItemHolder().getNetworkedInventory(BlockBreaker.this.inventory), (Object)"inventory.nova.default")), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((BlockBreakerMenu)((Object)this.receiver)).openWindow(p0);
                }
            });
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s # i i i # e |", "| u # i i i # e |", "| # # i i i # e |", "3 - - - - - - - 4"};
            Gui gui2 = ((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)Gui.normal().setStructure(stringArray)).addIngredient('i', (Inventory)BlockBreaker.this.inventory)).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGui))).addIngredient('u', (Item)new OpenUpgradesItem(BlockBreaker.this.getUpgradeHolder()))).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)BlockBreaker.this.getEnergyHolder()))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"build(...)");
            this.gui = gui2;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }
}

