/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.addon.machines.tileentity.processing;

import java.util.EnumMap;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.inventory.Inventory;
import xyz.xenondevs.invui.inventory.VirtualInventory;
import xyz.xenondevs.invui.inventory.event.ItemPreUpdateEvent;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.invui.item.impl.AbstractItem;
import xyz.xenondevs.nmsutils.particle.ParticleBuilder;
import xyz.xenondevs.nmsutils.particle.ParticleBuilderKt;
import xyz.xenondevs.nova.addon.machines.gui.LeftRightFluidProgressItem;
import xyz.xenondevs.nova.addon.machines.registry.GuiMaterials;
import xyz.xenondevs.nova.addon.machines.registry.Models;
import xyz.xenondevs.nova.addon.machines.tileentity.processing.CobblestoneGenerator;
import xyz.xenondevs.nova.addon.machines.tileentity.processing.CobblestoneGenerator$handleTick$;
import xyz.xenondevs.nova.addon.machines.tileentity.processing.CobblestoneGeneratorKt;
import xyz.xenondevs.nova.addon.simpleupgrades.UpgradeFunctionsKt;
import xyz.xenondevs.nova.addon.simpleupgrades.registry.UpgradeTypes;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.item.NovaItem;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.menu.MenuContainer;
import xyz.xenondevs.nova.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.FluidType;
import xyz.xenondevs.nova.tileentity.network.fluid.container.FluidContainer;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.FluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolderKt;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.FluidBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigMenu;
import xyz.xenondevs.nova.util.BlockFaceUtilsKt;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeItemDisplay;
import xyz.xenondevs.nova.world.fakeentity.metadata.impl.ItemDisplayMetadata;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u000256B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0019H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020*H\u0016J\b\u00101\u001a\u00020*H\u0016J\b\u00102\u001a\u00020*H\u0016J\b\u00103\u001a\u00020*H\u0002J\b\u00104\u001a\u00020*H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/processing/CobblestoneGenerator;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "currentMode", "Lxyz/xenondevs/nova/addon/machines/tileentity/processing/CobblestoneGenerator$Mode;", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "fluidHolder", "Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "getFluidHolder", "()Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "inventory", "Lxyz/xenondevs/invui/inventory/VirtualInventory;", "itemHolder", "Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "getItemHolder", "()Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "lavaLevel", "Lxyz/xenondevs/nova/world/fakeentity/impl/FakeItemDisplay;", "lavaTank", "Lxyz/xenondevs/nova/tileentity/network/fluid/container/FluidContainer;", "mbPerTick", "", "mbUsed", "mode", "particleEffect", "Lnet/minecraft/network/protocol/game/ClientboundLevelParticlesPacket;", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "waterLevel", "waterTank", "getFluidState", "", "container", "handleInventoryUpdate", "", "event", "Lxyz/xenondevs/invui/inventory/event/ItemPreUpdateEvent;", "handleRemoved", "unload", "", "handleTick", "reload", "saveData", "updateLavaLevel", "updateWaterLevel", "CobblestoneGeneratorMenu", "Mode", "machines"})
@SourceDebugExtension(value={"SMAP\nCobblestoneGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobblestoneGenerator.kt\nxyz/xenondevs/nova/addon/machines/tileentity/processing/CobblestoneGenerator\n+ 2 DataHolder.kt\nxyz/xenondevs/nova/data/serialization/DataHolder\n+ 3 Compound.kt\nxyz/xenondevs/cbf/Compound\n+ 4 MenuContainer.kt\nxyz/xenondevs/nova/tileentity/menu/MenuContainer\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,216:1\n30#2:217\n47#2:218\n73#2,3:226\n47#3:219\n33#4:220\n29#4:221\n34#4:225\n473#5:222\n1313#5,2:223\n*S KotlinDebug\n*F\n+ 1 CobblestoneGenerator.kt\nxyz/xenondevs/nova/addon/machines/tileentity/processing/CobblestoneGenerator\n*L\n71#1:217\n71#1:218\n159#1:226,3\n71#1:219\n143#1:220\n143#1:221\n143#1:225\n143#1:222\n143#1:223,2\n*E\n"})
public final class CobblestoneGenerator
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final VirtualInventory inventory;
    @NotNull
    private final FluidContainer waterTank;
    @NotNull
    private final FluidContainer lavaTank;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    @NotNull
    private final NovaItemHolder itemHolder;
    @NotNull
    private final NovaFluidHolder fluidHolder;
    @NotNull
    private Mode mode;
    private long mbPerTick;
    @NotNull
    private Mode currentMode;
    private long mbUsed;
    @NotNull
    private final FakeItemDisplay waterLevel;
    @NotNull
    private final FakeItemDisplay lavaLevel;
    @NotNull
    private final PacketPlayOutWorldParticles particleEffect;

    /*
     * WARNING - void declaration
     */
    public CobblestoneGenerator(@NotNull NovaTileEntityState blockState) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        Pair[] pairArray = new DataHolder[]{UpgradeTypes.INSTANCE.getSPEED(), UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getENERGY(), UpgradeTypes.INSTANCE.getFLUID()};
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])pairArray);
        this.inventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"inventory", (int)3, (Function1)((Function1)new Function1<ItemPreUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemPreUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                CobblestoneGenerator.access$handleInventoryUpdate((CobblestoneGenerator)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        this.waterTank = UpgradeFunctionsKt.getFluidContainer$default((TileEntity)((TileEntity)this), (String)"water", (Set)SetsKt.setOf((Object)FluidType.WATER), (Provider)CobblestoneGeneratorKt.access$getWATER_CAPACITY$p(), (long)0L, (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                CobblestoneGenerator.access$updateWaterLevel((CobblestoneGenerator)((Object)this.receiver));
            }
        }), (UpgradeHolder)this.getUpgradeHolder(), (boolean)false, (int)64, null);
        this.lavaTank = UpgradeFunctionsKt.getFluidContainer$default((TileEntity)((TileEntity)this), (String)"lava", (Set)SetsKt.setOf((Object)FluidType.LAVA), (Provider)CobblestoneGeneratorKt.access$getLAVA_CAPACITY$p(), (long)0L, (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                CobblestoneGenerator.access$updateLavaLevel((CobblestoneGenerator)((Object)this.receiver));
            }
        }), (UpgradeHolder)this.getUpgradeHolder(), (boolean)false, (int)64, null);
        this.energyHolder = UpgradeFunctionsKt.ConsumerEnergyHolder((NetworkedTileEntity)this, (Provider)CobblestoneGeneratorKt.access$getENERGY_CAPACITY$p(), (Provider)CobblestoneGeneratorKt.access$getENERGY_PER_TICK$p(), null, (UpgradeHolder)this.getUpgradeHolder(), (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ CobblestoneGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }));
        this.itemHolder = NovaItemHolderKt.NovaItemHolder$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.inventory, (Object)NetworkConnectionType.EXTRACT), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ CobblestoneGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        }), (int)8, null);
        pairArray = new Pair[]{TuplesKt.to((Object)this.lavaTank, (Object)NetworkConnectionType.BUFFER)};
        this.fluidHolder = NovaFluidHolderKt.NovaFluidHolder$default((DataHolder)((DataHolder)this), (Pair)TuplesKt.to((Object)this.waterTank, (Object)NetworkConnectionType.BUFFER), (Pair[])pairArray, null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ CobblestoneGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }), (int)8, null);
        CobblestoneGenerator cobblestoneGenerator = this;
        pairArray = (Pair[])this;
        String key$iv = "mode";
        boolean $i$f$retrieveData = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$retrieveDataOrNull = false;
        Compound this_$iv$iv$iv = this_$iv$iv.getData();
        boolean $i$f$get = false;
        Object object = this_$iv$iv$iv.get(Reflection.typeOf(Mode.class), key$iv);
        if (object == null) {
            this_$iv$iv$iv = this_$iv$iv.getGlobalData();
            $i$f$get = false;
            object = this_$iv$iv$iv.get(Reflection.typeOf(Mode.class), key$iv);
        }
        Object object2 = object;
        if (object == null) {
            CobblestoneGenerator cobblestoneGenerator2 = cobblestoneGenerator;
            boolean bl = false;
            object2 = Mode.COBBLESTONE;
            cobblestoneGenerator = cobblestoneGenerator2;
        }
        cobblestoneGenerator.mode = (Mode)((Object)object2);
        this.currentMode = this.mode;
        Location location = this.getLocation().add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        this.waterLevel = new FakeItemDisplay(location, false, (Function2)waterLevel.1.INSTANCE, 2, null);
        Location location2 = this.getLocation().add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"add(...)");
        this.lavaLevel = new FakeItemDisplay(location2, false, (Function2)lavaLevel.1.INSTANCE, 2, null);
        ParticleType particleType = Particles.U;
        Intrinsics.checkNotNullExpressionValue((Object)particleType, (String)"LARGE_SMOKE");
        this.particleEffect = ParticleBuilderKt.particle((Particle)((Particle)particleType), (Function1)((Function1)new Function1<ParticleBuilder<ParticleType>, Unit>(this){
            final /* synthetic */ CobblestoneGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ParticleBuilder<ParticleType> $this$particle) {
                void $this$invoke_u24lambda_u240;
                Location location;
                Intrinsics.checkNotNullParameter($this$particle, (String)"$this$particle");
                Location location2 = location = LocationUtilsKt.advance((Location)this.this$0.getCenterLocation(), (BlockFace)this.this$0.getFace(BlockSide.FRONT), (double)0.6);
                ParticleBuilder<ParticleType> particleBuilder = $this$particle;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setY($this$invoke_u24lambda_u240.getY() + 0.6);
                particleBuilder.location(location);
                $this$particle.offset(BlockFaceUtilsKt.getAxis((BlockFace)this.this$0.getFace(BlockSide.RIGHT)), 0.15f);
                $this$particle.amount(5);
                $this$particle.speed(0.03f);
            }
        }));
        this.reload();
        this.updateWaterLevel();
        this.updateLavaLevel();
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    @NotNull
    public NovaItemHolder getItemHolder() {
        return this.itemHolder;
    }

    @NotNull
    public NovaFluidHolder getFluidHolder() {
        return this.fluidHolder;
    }

    public void reload() {
        super.reload();
        this.mbPerTick = MathKt.roundToLong((double)((double)CobblestoneGeneratorKt.access$getMB_PER_TICK() * ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getSPEED())).doubleValue()));
    }

    private final void updateWaterLevel() {
        ItemStack itemStack;
        if (!this.waterTank.isEmpty()) {
            int state = this.getFluidState(this.waterTank);
            itemStack = ((ItemProvider)Models.INSTANCE.getCOBBLESTONE_GENERATOR_WATER_LEVELS().getClientsideProviders().get(state)).get();
        } else {
            itemStack = null;
        }
        ItemStack item = itemStack;
        this.waterLevel.updateEntityData(true, (Function1)new Function1<ItemDisplayMetadata, Unit>(item){
            final /* synthetic */ ItemStack $item;
            {
                this.$item = $item;
                super(1);
            }

            public final void invoke(@NotNull ItemDisplayMetadata $this$updateEntityData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateEntityData, (String)"$this$updateEntityData");
                $this$updateEntityData.setItemStack(NMSUtilsKt.getNmsCopy((ItemStack)this.$item));
            }
        });
    }

    private final void updateLavaLevel() {
        ItemStack itemStack;
        if (!this.lavaTank.isEmpty()) {
            int state = this.getFluidState(this.lavaTank);
            itemStack = ((ItemProvider)Models.INSTANCE.getCOBBLESTONE_GENERATOR_LAVA_LEVELS().getClientsideProviders().get(state)).get();
        } else {
            itemStack = null;
        }
        ItemStack item = itemStack;
        this.lavaLevel.updateEntityData(true, (Function1)new Function1<ItemDisplayMetadata, Unit>(item){
            final /* synthetic */ ItemStack $item;
            {
                this.$item = $item;
                super(1);
            }

            public final void invoke(@NotNull ItemDisplayMetadata $this$updateEntityData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateEntityData, (String)"$this$updateEntityData");
                $this$updateEntityData.setItemStack(NMSUtilsKt.getNmsCopy((ItemStack)this.$item));
            }
        });
    }

    private final int getFluidState(FluidContainer container) {
        return RangesKt.coerceIn((int)MathKt.roundToInt((double)((double)container.getAmount() / (double)container.getCapacity() * 99.0)), (ClosedRange)((ClosedRange)new IntRange(0, 99)));
    }

    /*
     * WARNING - void declaration
     */
    public void handleTick() {
        long mbToTake = Math.min(this.mbPerTick, (long)1000 - this.mbUsed);
        if (this.waterTank.getAmount() >= mbToTake && this.lavaTank.getAmount() >= mbToTake && this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getEnergyConsumption() && this.inventory.canHold(this.currentMode.getProduct(), new ItemStack[0])) {
            void $this$forEach$iv$iv;
            ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
            consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getEnergyConsumption());
            this.mbUsed += mbToTake;
            Object object = this.currentMode.getTakeLava() ? this.lavaTank : (consumerEnergyHolder = this.currentMode.getTakeWater() ? this.waterTank : null);
            if (consumerEnergyHolder != null) {
                consumerEnergyHolder.takeFluid(mbToTake);
            }
            if (this.mbUsed >= 1000L) {
                this.mbUsed = 0L;
                this.inventory.addItem(TileEntity.Companion.getSELF_UPDATE_REASON(), this.currentMode.getProduct());
                this.currentMode = this.mode;
                this.playSoundEffect(Sound.BLOCK_LAVA_EXTINGUISH, 0.1f, (float)Random.Default.nextDouble(0.5, 1.95));
                NMSUtilsKt.sendTo((Packet)((Packet)this.particleEffect), (Iterable)this.getViewers());
            }
            MenuContainer this_$iv = this.getMenuContainer();
            boolean $i$f$forEachMenu = false;
            MenuContainer this_$iv$iv = this_$iv;
            boolean $i$f$getMenus = false;
            Sequence $this$filterIsInstance$iv$iv$iv = this_$iv$iv.getMenusInternal();
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv$iv, (Function1)handleTick$$inlined$forEachMenu$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            this_$iv$iv = sequence;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                CobblestoneGeneratorMenu it = (CobblestoneGeneratorMenu)((Object)element$iv$iv);
                boolean bl = false;
                it.getProgressItem().setPercentage((double)this.mbUsed / 1000.0);
            }
        }
    }

    private final void handleInventoryUpdate(ItemPreUpdateEvent event) {
        event.setCancelled(!event.isRemove() && !Intrinsics.areEqual((Object)event.getUpdateReason(), (Object)TileEntity.Companion.getSELF_UPDATE_REASON()));
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        this.waterLevel.remove();
        this.lavaLevel.remove();
    }

    /*
     * WARNING - void declaration
     */
    public void saveData() {
        void key$iv;
        super.saveData();
        String string = "mode";
        Mode value$iv = this.mode;
        boolean global$iv = false;
        boolean $i$f$storeData = false;
        ((DataHolder)this).storeData(Reflection.typeOf(Mode.class), (String)key$iv, (Object)value$iv, global$iv);
    }

    public static final /* synthetic */ void access$handleInventoryUpdate(CobblestoneGenerator $this, ItemPreUpdateEvent event) {
        $this.handleInventoryUpdate(event);
    }

    public static final /* synthetic */ void access$updateWaterLevel(CobblestoneGenerator $this) {
        $this.updateWaterLevel();
    }

    public static final /* synthetic */ void access$updateLavaLevel(CobblestoneGenerator $this) {
        $this.updateLavaLevel();
    }

    @TileEntityMenuClass
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/processing/CobblestoneGenerator$CobblestoneGeneratorMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity$GlobalTileEntityMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/addon/machines/tileentity/processing/CobblestoneGenerator;)V", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "Lorg/jetbrains/annotations/NotNull;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "progressItem", "Lxyz/xenondevs/nova/addon/machines/gui/LeftRightFluidProgressItem;", "getProgressItem", "()Lxyz/xenondevs/nova/addon/machines/gui/LeftRightFluidProgressItem;", "sideConfigGui", "Lxyz/xenondevs/nova/ui/config/side/SideConfigMenu;", "ChangeModeItem", "machines"})
    public final class CobblestoneGeneratorMenu
    extends TileEntity.GlobalTileEntityMenu {
        @NotNull
        private final SideConfigMenu sideConfigGui;
        @NotNull
        private final LeftRightFluidProgressItem progressItem;
        @NotNull
        private final Gui gui;

        public CobblestoneGeneratorMenu() {
            super((TileEntity)CobblestoneGenerator.this, null, 1, null);
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)CobblestoneGenerator.this.waterTank, (Object)"container.nova.water_tank"), TuplesKt.to((Object)CobblestoneGenerator.this.lavaTank, (Object)"container.nova.lava_tank")};
            this.sideConfigGui = new SideConfigMenu((NetworkEndPoint)CobblestoneGenerator.this, CollectionsKt.listOf((Object)TuplesKt.to((Object)CobblestoneGenerator.this.getItemHolder().getNetworkedInventory(CobblestoneGenerator.this.inventory), (Object)"inventory.nova.output")), CollectionsKt.listOf((Object[])objectArray), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((CobblestoneGeneratorMenu)((Object)this.receiver)).openWindow(p0);
                }
            });
            this.progressItem = new LeftRightFluidProgressItem();
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| w l # i # s e |", "| w l > i # u e |", "| w l # i # m e |", "3 - - - - - - - 4"};
            Gui gui2 = ((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)Gui.normal().setStructure(stringArray)).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGui))).addIngredient('u', (Item)new OpenUpgradesItem(CobblestoneGenerator.this.getUpgradeHolder()))).addIngredient('m', (Item)new ChangeModeItem())).addIngredient('i', (Inventory)CobblestoneGenerator.this.inventory)).addIngredient('>', (Item)this.progressItem)).addIngredient('w', (Supplier)new FluidBar(3, (FluidHolder)CobblestoneGenerator.this.getFluidHolder(), CobblestoneGenerator.this.waterTank))).addIngredient('l', (Supplier)new FluidBar(3, (FluidHolder)CobblestoneGenerator.this.getFluidHolder(), CobblestoneGenerator.this.lavaTank))).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)CobblestoneGenerator.this.getEnergyHolder()))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"build(...)");
            this.gui = gui2;
        }

        @NotNull
        public final LeftRightFluidProgressItem getProgressItem() {
            return this.progressItem;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/processing/CobblestoneGenerator$CobblestoneGeneratorMenu$ChangeModeItem;", "Lxyz/xenondevs/invui/item/impl/AbstractItem;", "(Lxyz/xenondevs/nova/addon/machines/tileentity/processing/CobblestoneGenerator$CobblestoneGeneratorMenu;)V", "getItemProvider", "Lxyz/xenondevs/invui/item/ItemProvider;", "handleClick", "", "clickType", "Lorg/bukkit/event/inventory/ClickType;", "player", "Lorg/bukkit/entity/Player;", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "machines"})
        private final class ChangeModeItem
        extends AbstractItem {
            @NotNull
            public ItemProvider getItemProvider() {
                return CobblestoneGenerator.this.mode.getUiItem().getClientsideProvider();
            }

            public void handleClick(@NotNull ClickType clickType, @NotNull Player player2, @NotNull InventoryClickEvent event) {
                Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
                Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (clickType == ClickType.LEFT || clickType == ClickType.RIGHT) {
                    int direction = clickType == ClickType.LEFT ? 1 : -1;
                    int n = CobblestoneGenerator.this.mode.ordinal() + direction;
                    int n2 = Mode.getEntries().size();
                    int n3 = n % n2;
                    CobblestoneGenerator.this.mode = (Mode)((Object)Mode.getEntries().get(n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31)));
                    player2.playSound(player2.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    this.notifyWindows();
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/addon/machines/tileentity/processing/CobblestoneGenerator$Mode;", "", "takeWater", "", "takeLava", "product", "Lorg/bukkit/inventory/ItemStack;", "uiItem", "Lxyz/xenondevs/nova/item/NovaItem;", "(Ljava/lang/String;IZZLorg/bukkit/inventory/ItemStack;Lxyz/xenondevs/nova/item/NovaItem;)V", "getProduct", "()Lorg/bukkit/inventory/ItemStack;", "getTakeLava", "()Z", "getTakeWater", "getUiItem", "()Lxyz/xenondevs/nova/item/NovaItem;", "COBBLESTONE", "STONE", "OBSIDIAN", "machines"})
    public static final class Mode
    extends Enum<Mode> {
        private final boolean takeWater;
        private final boolean takeLava;
        @NotNull
        private final ItemStack product;
        @NotNull
        private final NovaItem uiItem;
        public static final /* enum */ Mode COBBLESTONE = new Mode(false, false, new ItemStack(Material.COBBLESTONE), GuiMaterials.INSTANCE.getCOBBLESTONE_MODE_BTN());
        public static final /* enum */ Mode STONE = new Mode(true, false, new ItemStack(Material.STONE), GuiMaterials.INSTANCE.getSTONE_MODE_BTN());
        public static final /* enum */ Mode OBSIDIAN = new Mode(false, true, new ItemStack(Material.OBSIDIAN), GuiMaterials.INSTANCE.getOBSIDIAN_MODE_BTN());
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Mode(boolean takeWater, boolean takeLava, ItemStack product, NovaItem uiItem) {
            this.takeWater = takeWater;
            this.takeLava = takeLava;
            this.product = product;
            this.uiItem = uiItem;
        }

        public final boolean getTakeWater() {
            return this.takeWater;
        }

        public final boolean getTakeLava() {
            return this.takeLava;
        }

        @NotNull
        public final ItemStack getProduct() {
            return this.product;
        }

        @NotNull
        public final NovaItem getUiItem() {
            return this.uiItem;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.COBBLESTONE, Mode.STONE, Mode.OBSIDIAN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

