/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.energy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nova.data.resources.model.data.BlockModelData;
import xyz.xenondevs.nova.data.resources.model.data.DisplayEntityBlockModelData;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.integration.protection.ProtectionManager;
import xyz.xenondevs.nova.machines.tileentity.energy.WindTurbineKt;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ProviderEnergyHolder;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.concurrent.CombinedBooleanFuture;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.fakeentity.metadata.impl.ItemDisplayMetadata;
import xyz.xenondevs.nova.world.model.Model;
import xyz.xenondevs.nova.world.model.MovableMultiModel;
import xyz.xenondevs.simpleupgrades.UpgradeFunctionsKt;
import xyz.xenondevs.simpleupgrades.registry.UpgradeTypes;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0002\u001d\u001eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/WindTurbine;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "altitude", "", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "energyPerTick", "", "rotationPerTick", "turbineModel", "Lxyz/xenondevs/nova/world/model/MovableMultiModel;", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "handleAsyncTick", "", "handleRemoved", "unload", "", "handleTick", "reload", "spawnModels", "Companion", "WindTurbineMenu", "machines"})
public final class WindTurbine
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ProviderEnergyHolder energyHolder;
    @NotNull
    private final MovableMultiModel turbineModel;
    private final double altitude;
    private final double rotationPerTick;
    private int energyPerTick;

    public WindTurbine(@NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        UpgradeType[] upgradeTypeArray = new UpgradeType[]{UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getENERGY()};
        this.upgradeHolder = this.getUpgradeHolder(upgradeTypeArray);
        this.energyHolder = UpgradeFunctionsKt.ProviderEnergyHolder((NetworkedTileEntity)this, (Provider)WindTurbineKt.access$getMAX_ENERGY$p(), (Provider)WindTurbineKt.access$getENERGY_PER_TICK$p(), (UpgradeHolder)this.getUpgradeHolder(), (UpgradeType)UpgradeTypes.INSTANCE.getEFFICIENCY(), (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ WindTurbine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT, BlockSide.BOTTOM};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        }));
        this.turbineModel = new MovableMultiModel();
        this.altitude = (this.getLocation().getY() + (double)Math.abs(this.getWorld().getMinHeight())) / (double)(this.getWorld().getMaxHeight() - 1 + Math.abs(this.getWorld().getMinHeight()));
        this.rotationPerTick = this.altitude * (double)15;
        this.reload();
        this.spawnModels();
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ProviderEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    public void reload() {
        super.reload();
        this.energyPerTick = (int)(this.altitude * (double)this.getEnergyHolder().getEnergyGeneration());
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        this.turbineModel.close();
    }

    private final void spawnModels() {
        Location location = this.getLocation().add(0.5, 3.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location.add(0.5, 3.5, 0.5)");
        Location location2 = location;
        BlockModelData blockModelData = this.getBlock().getModel();
        Intrinsics.checkNotNull((Object)blockModelData, (String)"null cannot be cast to non-null type xyz.xenondevs.nova.data.resources.model.data.DisplayEntityBlockModelData");
        ItemStack itemStack = ((DisplayEntityBlockModelData)blockModelData).get(4).get();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"(block.model as DisplayE\u2026yBlockModelData)[4].get()");
        this.turbineModel.add(new Model(itemStack, location2, null, null, null, null, null, null, 0.0f, 0.0f, 0, 2044, null));
        for (int blade = 0; blade < 3; ++blade) {
            BlockModelData blockModelData2 = this.getBlock().getModel();
            Intrinsics.checkNotNull((Object)blockModelData2, (String)"null cannot be cast to non-null type xyz.xenondevs.nova.data.resources.model.data.DisplayEntityBlockModelData");
            ItemStack itemStack2 = ((DisplayEntityBlockModelData)blockModelData2).get(5).get();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"(block.model as DisplayE\u2026yBlockModelData)[5].get()");
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((float)(2.0943951023931953 * (double)blade), 0.0f, 0.0f, 1.0f);
            Intrinsics.checkNotNullExpressionValue((Object)quaternionf, (String)"Quaternionf().setAngleAx\u2026 0f, 1f\n                )");
            this.turbineModel.add(new Model(itemStack2, location2, null, null, null, null, quaternionf, null, 0.0f, 0.0f, 0, 1980, null));
        }
    }

    public void handleTick() {
        ProviderEnergyHolder providerEnergyHolder = this.getEnergyHolder();
        providerEnergyHolder.setEnergy(providerEnergyHolder.getEnergy() + (long)this.energyPerTick);
    }

    public void handleAsyncTick() {
        if (WindTurbineKt.access$getPLAY_ANIMATION()) {
            MovableMultiModel.useMetadata$default((MovableMultiModel)this.turbineModel, (boolean)false, (Function1)((Function1)new Function1<ItemDisplayMetadata, Unit>(this){
                final /* synthetic */ WindTurbine this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ItemDisplayMetadata it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Quaternionf quaternionf = it.getLeftRotation().rotateAxis((float)Math.toRadians(WindTurbine.access$getRotationPerTick$p(this.this$0)), 0.0f, 0.0f, 1.0f);
                    Intrinsics.checkNotNullExpressionValue((Object)quaternionf, (String)"it.leftRotation.rotateAx\u2026 0f, 1f\n                )");
                    it.setLeftRotation(quaternionf);
                }
            }), (int)1, null);
        }
    }

    public static final /* synthetic */ double access$getRotationPerTick$p(WindTurbine $this) {
        return $this.rotationPerTick;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/WindTurbine$Companion;", "", "()V", "canPlace", "Ljava/util/concurrent/CompletableFuture;", "", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/bukkit/inventory/ItemStack;", "location", "Lorg/bukkit/Location;", "loadMultiBlock", "", "Lxyz/xenondevs/nova/world/BlockPos;", "pos", "machines"})
    @SourceDebugExtension(value={"SMAP\nWindTurbine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindTurbine.kt\nxyz/xenondevs/nova/machines/tileentity/energy/WindTurbine$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1549#2:135\n1620#2,3:136\n*S KotlinDebug\n*F\n+ 1 WindTurbine.kt\nxyz/xenondevs/nova/machines/tileentity/energy/WindTurbine$Companion\n*L\n101#1:135\n101#1:136,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CompletableFuture<Boolean> canPlace(@NotNull Player player2, @NotNull ItemStack item, @NotNull Location location) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Iterable $this$map$iv = this.loadMultiBlock(BlockPosKt.getPos((Location)location));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BlockPos blockPos = (BlockPos)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Material material = it.getBlock().getType();
                Intrinsics.checkNotNullExpressionValue((Object)material, (String)"it.block.type");
                if (!MaterialUtilsKt.isReplaceable((Material)material)) {
                    CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(false)");
                    return completableFuture;
                }
                collection.add(ProtectionManager.INSTANCE.canPlace((OfflinePlayer)player2, item, it.getLocation()));
            }
            List list = (List)destination$iv$iv;
            return (CompletableFuture)new CombinedBooleanFuture(list);
        }

        @NotNull
        public final List<BlockPos> loadMultiBlock(@NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Object[] objectArray = new BlockPos[]{BlockPos.copy$default((BlockPos)pos, null, (int)0, (int)(pos.getY() + 1), (int)0, (int)11, null), BlockPos.copy$default((BlockPos)pos, null, (int)0, (int)(pos.getY() + 2), (int)0, (int)11, null), BlockPos.copy$default((BlockPos)pos, null, (int)0, (int)(pos.getY() + 3), (int)0, (int)11, null)};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @TileEntityMenuClass
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/WindTurbine$WindTurbineMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity$GlobalTileEntityMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/energy/WindTurbine;)V", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "Lorg/jetbrains/annotations/NotNull;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "machines"})
    public final class WindTurbineMenu
    extends TileEntity.GlobalTileEntityMenu {
        @NotNull
        private final Gui gui;

        public WindTurbineMenu() {
            super((TileEntity)WindTurbine.this, null, 1, null);
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| u # # e # # # |", "| # # # e # # # |", "| # # # e # # # |", "3 - - - - - - - 4"};
            Gui gui2 = ((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)Gui.normal().setStructure(stringArray)).addIngredient('u', (Item)new OpenUpgradesItem(WindTurbine.this.getUpgradeHolder()))).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)WindTurbine.this.getEnergyHolder()))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"normal()\n            .se\u2026er))\n            .build()");
            this.gui = gui2;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }
}

