/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.energy;

import java.util.EnumMap;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.machines.tileentity.energy.LightningExchangerKt;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.TileEntityManager;
import xyz.xenondevs.nova.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ProviderEnergyHolder;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.simpleupgrades.UpgradeFunctionsKt;
import xyz.xenondevs.simpleupgrades.registry.UpgradeTypes;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/LightningExchanger;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "maxBurst", "", "minBurst", "toCharge", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "addEnergyBurst", "", "handleTick", "reload", "LightningExchangerMenu", "LightningHandler", "machines"})
public final class LightningExchanger
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private static final LightningHandler LightningHandler = new LightningHandler(null);
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ProviderEnergyHolder energyHolder;
    private long minBurst;
    private long maxBurst;
    private long toCharge;

    public LightningExchanger(@NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        UpgradeType[] upgradeTypeArray = new UpgradeType[]{UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getENERGY()};
        this.upgradeHolder = this.getUpgradeHolder(upgradeTypeArray);
        this.energyHolder = UpgradeFunctionsKt.ProviderEnergyHolder((NetworkedTileEntity)this, (Provider)LightningExchangerKt.access$getMAX_ENERGY$p(), (UpgradeHolder)this.getUpgradeHolder(), (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ LightningExchanger this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.BOTTOM};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        }));
        this.reload();
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ProviderEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    public void reload() {
        super.reload();
        this.minBurst = (long)((double)LightningExchangerKt.access$getMIN_BURST() * ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getEFFICIENCY())).doubleValue());
        this.maxBurst = (long)((double)LightningExchangerKt.access$getMAX_BURST() * ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getEFFICIENCY())).doubleValue());
    }

    public void handleTick() {
        long charge = Math.min(LightningExchangerKt.access$getCONVERSION_RATE(), this.toCharge);
        ProviderEnergyHolder providerEnergyHolder = this.getEnergyHolder();
        providerEnergyHolder.setEnergy(providerEnergyHolder.getEnergy() + charge);
        this.toCharge -= charge;
    }

    public final void addEnergyBurst() {
        long leeway = this.getEnergyHolder().getMaxEnergy() - this.getEnergyHolder().getEnergy() - this.toCharge;
        this.toCharge += leeway <= this.maxBurst ? leeway : Random.Default.nextLong(this.minBurst, this.maxBurst);
    }

    static {
        EventUtilsKt.registerEvents((Listener)LightningHandler);
    }

    @TileEntityMenuClass
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/LightningExchanger$LightningExchangerMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity$GlobalTileEntityMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/energy/LightningExchanger;)V", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "Lorg/jetbrains/annotations/NotNull;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "machines"})
    public final class LightningExchangerMenu
    extends TileEntity.GlobalTileEntityMenu {
        @NotNull
        private final Gui gui;

        public LightningExchangerMenu() {
            super((TileEntity)LightningExchanger.this, null, 1, null);
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| u # # e # # # |", "| # # # e # # # |", "| # # # e # # # |", "3 - - - - - - - 4"};
            Gui gui2 = ((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)Gui.normal().setStructure(stringArray)).addIngredient('u', (Item)new OpenUpgradesItem(LightningExchanger.this.getUpgradeHolder()))).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)LightningExchanger.this.getEnergyHolder()))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"normal()\n            .se\u2026er))\n            .build()");
            this.gui = gui2;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/LightningExchanger$LightningHandler;", "Lorg/bukkit/event/Listener;", "()V", "handleLightning", "", "event", "Lorg/bukkit/event/weather/LightningStrikeEvent;", "machines"})
    private static final class LightningHandler
    implements Listener {
        private LightningHandler() {
        }

        @EventHandler
        public final void handleLightning(@NotNull LightningStrikeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Location location = event.getLightning().getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"event.lightning.location");
            Block block = LocationUtilsKt.advance$default((Location)location, (BlockFace)BlockFace.DOWN, (double)0.0, (int)2, null).getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"event.lightning.location\u2026nce(BlockFace.DOWN).block");
            Block struckBlock = block;
            if (event.getCause() != LightningStrikeEvent.Cause.WEATHER || struckBlock.getType() != Material.LIGHTNING_ROD) {
                return;
            }
            Location location2 = struckBlock.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"struckBlock.location");
            TileEntity tile = TileEntityManager.INSTANCE.getTileEntity(LocationUtilsKt.advance$default((Location)location2, (BlockFace)BlockFace.DOWN, (double)0.0, (int)2, null), false);
            if (!(tile instanceof LightningExchanger)) {
                return;
            }
            ((LightningExchanger)tile).addEnergyBurst();
        }

        public /* synthetic */ LightningHandler(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

