/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.agriculture;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.inventory.Inventory;
import xyz.xenondevs.invui.inventory.VirtualInventory;
import xyz.xenondevs.invui.inventory.event.ItemPreUpdateEvent;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.integration.protection.ProtectionManager;
import xyz.xenondevs.nova.machines.tileentity.agriculture.FertilizerKt;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigMenu;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.item.PlantUtils;
import xyz.xenondevs.nova.util.item.PlantUtilsKt;
import xyz.xenondevs.nova.world.region.Region;
import xyz.xenondevs.nova.world.region.UpgradableRegion;
import xyz.xenondevs.nova.world.region.VisualRegion;
import xyz.xenondevs.simpleupgrades.UpgradeFunctionsKt;
import xyz.xenondevs.simpleupgrades.registry.UpgradeTypes;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001%B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001aH\u0016J\b\u0010$\u001a\u00020\u001aH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/agriculture/Fertilizer;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "fertilizerInventory", "Lxyz/xenondevs/invui/inventory/VirtualInventory;", "itemHolder", "Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "getItemHolder", "()Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "maxIdleTime", "", "region", "Lxyz/xenondevs/nova/world/region/UpgradableRegion;", "timePassed", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "fertilizeNextPlant", "", "getNextPlant", "Lorg/bukkit/block/Block;", "handleFertilizerUpdate", "event", "Lxyz/xenondevs/invui/inventory/event/ItemPreUpdateEvent;", "handleRemoved", "unload", "", "handleTick", "reload", "FertilizerMenu", "machines"})
@SourceDebugExtension(value={"SMAP\nFertilizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fertilizer.kt\nxyz/xenondevs/nova/machines/tileentity/agriculture/Fertilizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n288#2,2:132\n*S KotlinDebug\n*F\n+ 1 Fertilizer.kt\nxyz/xenondevs/nova/machines/tileentity/agriculture/Fertilizer\n*L\n87#1:132,2\n*E\n"})
public final class Fertilizer
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final VirtualInventory fertilizerInventory;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    @NotNull
    private final NovaItemHolder itemHolder;
    private int maxIdleTime;
    private int timePassed;
    @NotNull
    private final UpgradableRegion region;

    public Fertilizer(@NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.fertilizerInventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"fertilizer", (int)12, (Function1)((Function1)new Function1<ItemPreUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemPreUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Fertilizer.access$handleFertilizerUpdate((Fertilizer)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        UpgradeType[] upgradeTypeArray = new UpgradeType[]{UpgradeTypes.INSTANCE.getSPEED(), UpgradeTypes.INSTANCE.getEFFICIENCY(), UpgradeTypes.INSTANCE.getENERGY(), UpgradeTypes.INSTANCE.getRANGE()};
        this.upgradeHolder = this.getUpgradeHolder(upgradeTypeArray);
        this.energyHolder = UpgradeFunctionsKt.ConsumerEnergyHolder((NetworkedTileEntity)this, (Provider)FertilizerKt.access$getMAX_ENERGY$p(), (Provider)FertilizerKt.access$getENERGY_PER_TICK$p(), (Provider)FertilizerKt.access$getENERGY_PER_FERTILIZE$p(), (UpgradeHolder)this.getUpgradeHolder(), (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ Fertilizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }));
        this.itemHolder = NovaItemHolderKt.NovaItemHolder$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.fertilizerInventory, (Object)NetworkConnectionType.INSERT), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ Fertilizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }), (int)8, null);
        this.region = this.getUpgradableRegion(UpgradeTypes.INSTANCE.getRANGE(), FertilizerKt.access$getMIN_RANGE$p(), FertilizerKt.access$getMAX_RANGE$p(), FertilizerKt.access$getDEFAULT_RANGE(), (Function1)new Function1<Integer, Region>(this){
            final /* synthetic */ Fertilizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Region invoke(int it) {
                return this.this$0.getBlockFrontRegion(it, it, 1, 0);
            }
        });
        this.reload();
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    @NotNull
    public NovaItemHolder getItemHolder() {
        return this.itemHolder;
    }

    public void reload() {
        super.reload();
        this.maxIdleTime = (int)((double)FertilizerKt.access$getIDLE_TIME() / ((Number)this.getUpgradeHolder().getValue(UpgradeTypes.INSTANCE.getSPEED())).doubleValue());
        if (this.timePassed > this.maxIdleTime) {
            this.timePassed = this.maxIdleTime;
        }
    }

    public void handleTick() {
        if (this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getEnergyConsumption()) {
            ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
            consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getEnergyConsumption());
            if (this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getSpecialEnergyConsumption()) {
                int n = this.timePassed;
                this.timePassed = n + 1;
                if (n >= this.maxIdleTime) {
                    this.timePassed = 0;
                    if (!this.fertilizerInventory.isEmpty()) {
                        this.fertilizeNextPlant();
                    }
                }
            }
        }
    }

    private final void fertilizeNextPlant() {
        ItemStack[] itemStackArray = this.fertilizerInventory.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"fertilizerInventory.items");
        ItemStack[] itemStackArray2 = itemStackArray;
        int n = itemStackArray2.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            ItemStack item = itemStackArray2[i];
            if (item == null) continue;
            Block block = this.getNextPlant();
            if (block == null) {
                return;
            }
            Block plant = block;
            PlantUtils.INSTANCE.fertilize(plant);
            ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
            consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getSpecialEnergyConsumption());
            this.fertilizerInventory.addItemAmount(TileEntity.Companion.getSELF_UPDATE_REASON(), index, -1);
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Block getNextPlant() {
        Object element$iv;
        Object v0;
        boolean bl;
        Iterable $this$firstOrNull$iv = this.region.getBlocks();
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v0 = null;
                return v0;
            }
            element$iv = iterator.next();
            Block it = (Block)element$iv;
            boolean bl2 = false;
            if (it.getBlockData() instanceof Ageable && !PlantUtilsKt.isFullyAged((Block)it)) {
                TileEntity tileEntity = (TileEntity)this;
                ItemStack itemStack = new ItemStack(Material.BONE_MEAL);
                Location location = it.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"it.location");
                Object t = ProtectionManager.INSTANCE.canUseBlock(tileEntity, itemStack, location).get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"ProtectionManager.canUse\u2026MEAL), it.location).get()");
                if (((Boolean)t).booleanValue()) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return v0;
    }

    private final void handleFertilizerUpdate(ItemPreUpdateEvent event) {
        if (event.isAdd() || event.isSwap()) {
            ItemStack itemStack = event.getNewItem();
            if ((itemStack != null ? itemStack.getType() : null) != Material.BONE_MEAL) {
                event.setCancelled(true);
            }
        }
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        VisualRegion.INSTANCE.removeRegion(this.getUuid());
    }

    public static final /* synthetic */ void access$handleFertilizerUpdate(Fertilizer $this, ItemPreUpdateEvent event) {
        $this.handleFertilizerUpdate(event);
    }

    @TileEntityMenuClass
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/agriculture/Fertilizer$FertilizerMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity$IndividualTileEntityMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "player", "Lorg/bukkit/entity/Player;", "(Lxyz/xenondevs/nova/machines/tileentity/agriculture/Fertilizer;Lorg/bukkit/entity/Player;)V", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "Lorg/jetbrains/annotations/NotNull;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "sideConfigGui", "Lxyz/xenondevs/nova/ui/config/side/SideConfigMenu;", "machines"})
    public final class FertilizerMenu
    extends TileEntity.IndividualTileEntityMenu {
        @NotNull
        private final SideConfigMenu sideConfigGui;
        @NotNull
        private final Gui gui;

        public FertilizerMenu(Player player2) {
            Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
            super((TileEntity)Fertilizer.this, player2, null, 2, null);
            this.sideConfigGui = new SideConfigMenu((NetworkEndPoint)Fertilizer.this, CollectionsKt.listOf((Object)TuplesKt.to((Object)Fertilizer.this.getItemHolder().getNetworkedInventory(Fertilizer.this.fertilizerInventory), (Object)"inventory.machines.fertilizer")), (Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((FertilizerMenu)((Object)this.receiver)).openWindow();
                }
            });
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s p i i i i e |", "| v n i i i i e |", "| u m i i i i e |", "3 - - - - - - - 4"};
            Gui gui2 = ((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)Gui.normal().setStructure(stringArray)).addIngredient('i', (Inventory)Fertilizer.this.fertilizerInventory)).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGui))).addIngredient('u', (Item)new OpenUpgradesItem(Fertilizer.this.getUpgradeHolder()))).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)Fertilizer.this.getEnergyHolder()))).addIngredient('v', (Item)Fertilizer.this.region.createVisualizeRegionItem(player2))).addIngredient('p', (Item)Fertilizer.this.region.getIncreaseSizeItem())).addIngredient('m', (Item)Fertilizer.this.region.getDecreaseSizeItem())).addIngredient('n', (Item)Fertilizer.this.region.getDisplaySizeItem())).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui2, (String)"normal()\n            .se\u2026tem)\n            .build()");
            this.gui = gui2;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }
}

