/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.world;

import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.builder.GUIBuilder;
import de.studiocode.invui.gui.builder.guitype.GUIType;
import de.studiocode.invui.item.Item;
import de.studiocode.invui.item.builder.ItemBuilder;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import de.studiocode.invui.virtualinventory.event.ItemUpdateEvent;
import java.awt.Color;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.world.entity.EnumItemSlot;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.data.config.GlobalValues;
import xyz.xenondevs.nova.data.resources.model.data.ArmorStandBlockModelData;
import xyz.xenondevs.nova.data.resources.model.data.BlockModelData;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.machines.registry.Items;
import xyz.xenondevs.nova.machines.tileentity.world.StarCollector;
import xyz.xenondevs.nova.machines.tileentity.world.StarCollectorKt;
import xyz.xenondevs.nova.material.CoreGUIMaterial;
import xyz.xenondevs.nova.material.ItemNovaMaterial;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.TileEntityParticleTask;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.VerticalBar;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigGUI;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.InventoryUtilsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.ParticlePacketBuilder;
import xyz.xenondevs.nova.util.ParticlePacketBuilderKt;
import xyz.xenondevs.nova.util.data.ComponentUtilsKt;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeArmorStand;
import xyz.xenondevs.nova.world.fakeentity.metadata.impl.ArmorStandMetadata;
import xyz.xenondevs.particle.ParticleEffect;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u00013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020'H\u0002J\u0010\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020'H\u0016J\b\u00102\u001a\u00020'H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\f\u0012\b\u0012\u00060\fR\u00020\u00000\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00064"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/world/StarCollector;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "gui", "Lkotlin/Lazy;", "Lxyz/xenondevs/nova/machines/tileentity/world/StarCollector$StarCollectorGUI;", "getGui", "()Lkotlin/Lazy;", "inventory", "Lde/studiocode/invui/virtualinventory/VirtualInventory;", "itemHolder", "Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "getItemHolder", "()Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "maxCollectionTime", "", "maxIdleTime", "particleTask", "Lxyz/xenondevs/nova/tileentity/TileEntityParticleTask;", "particleVector", "Lorg/bukkit/util/Vector;", "rod", "Lxyz/xenondevs/nova/world/fakeentity/impl/FakeArmorStand;", "rodLocation", "Lorg/bukkit/Location;", "timeSpentCollecting", "timeSpentIdle", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "handleCollectionTick", "", "handleDayTick", "handleIdleTick", "handleInventoryUpdate", "event", "Lde/studiocode/invui/virtualinventory/event/ItemUpdateEvent;", "handleNightTick", "handleRemoved", "unload", "", "handleTick", "reload", "StarCollectorGUI", "machines"})
public final class StarCollector
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final VirtualInventory inventory;
    @NotNull
    private final Lazy<StarCollectorGUI> gui;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final NovaItemHolder itemHolder;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    private int maxIdleTime;
    private int maxCollectionTime;
    private int timeSpentIdle;
    private int timeSpentCollecting;
    private Vector particleVector;
    @NotNull
    private final Location rodLocation;
    @NotNull
    private final FakeArmorStand rod;
    @NotNull
    private final TileEntityParticleTask particleTask;

    /*
     * WARNING - void declaration
     */
    public StarCollector(@NotNull NovaTileEntityState blockState) {
        void $this$rod_u24lambda_u241;
        Location $this$rodLocation_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.inventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"inventory", (int)1, (Function1)((Function1)new Function1<ItemUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                StarCollector.access$handleInventoryUpdate((StarCollector)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        this.gui = LazyKt.lazy((Function0)((Function0)new Function0<StarCollectorGUI>((Object)this){

            @NotNull
            public final StarCollectorGUI invoke() {
                return (StarCollector)((Object)this.receiver).new StarCollectorGUI();
            }
        }));
        Location location = new Location[]{UpgradeType.Companion.getSPEED(), UpgradeType.Companion.getEFFICIENCY(), UpgradeType.Companion.getENERGY()};
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])location);
        this.itemHolder = NovaItemHolderKt.NovaItemHolder$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.inventory, (Object)NetworkConnectionType.EXTRACT), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ StarCollector this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.BOTTOM};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        }), (int)8, null);
        this.energyHolder = new ConsumerEnergyHolder((NetworkedTileEntity)this, StarCollectorKt.access$getMAX_ENERGY$p(), StarCollectorKt.access$getIDLE_ENERGY_PER_TICK$p(), StarCollectorKt.access$getCOLLECTING_ENERGY_PER_TICK$p(), this.getUpgradeHolder(), (Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ StarCollector this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.BOTTOM};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        });
        this.timeSpentCollecting = -1;
        Location location2 = this.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"location.clone()");
        Location location3 = location = LocationUtilsKt.center((Location)location2);
        StarCollector starCollector = this;
        boolean bl = false;
        $this$rodLocation_u24lambda_u240.setY($this$rodLocation_u24lambda_u240.getY() + 0.7);
        starCollector.rodLocation = location;
        Location location4 = this.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue((Object)location4, (String)"location.clone()");
        $this$rodLocation_u24lambda_u240 = location = LocationUtilsKt.center((Location)location4);
        starCollector = this;
        boolean bl2 = false;
        $this$rod_u24lambda_u241.setY($this$rod_u24lambda_u241.getY() - 1.0);
        Function2 function2 = (Function2)new Function2<FakeArmorStand, ArmorStandMetadata, Unit>(this){
            final /* synthetic */ StarCollector this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull FakeArmorStand ast, @NotNull ArmorStandMetadata data) {
                Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                data.setMarker(true);
                data.setInvisible(true);
                BlockModelData blockModelData = this.this$0.getMaterial().getBlock();
                Intrinsics.checkNotNull((Object)blockModelData, (String)"null cannot be cast to non-null type xyz.xenondevs.nova.data.resources.model.data.ArmorStandBlockModelData");
                ast.setEquipment(EnumItemSlot.f, ((ArmorStandBlockModelData)blockModelData).get(1).get(), false);
            }
        };
        boolean bl3 = true;
        Location location5 = location;
        starCollector.rod = new FakeArmorStand(location5, bl3, function2);
        this.particleTask = this.createParticleTask(CollectionsKt.listOf((Object)ParticlePacketBuilderKt.particle((ParticleEffect)ParticleEffect.DUST_COLOR_TRANSITION, (Function1)((Function1)new Function1<ParticlePacketBuilder, Unit>(this){
            final /* synthetic */ StarCollector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ParticlePacketBuilder $this$particle) {
                void $this$invoke_u24lambda_u240;
                Location location;
                Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
                Location location2 = this.this$0.getLocation().clone();
                Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"location.clone()");
                Location location3 = location = LocationUtilsKt.center((Location)location2);
                ParticlePacketBuilder particlePacketBuilder = $this$particle;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setY($this$invoke_u24lambda_u240.getY() + 0.2);
                particlePacketBuilder.location(location);
                $this$particle.dustFade(new Color(132, 0, 245), new Color(196, 128, 217), 1.0f);
                $this$particle.offset(0.25, 0.1, 0.25);
                $this$particle.amount(3);
            }
        }))), 1);
        this.reload();
    }

    @NotNull
    public Lazy<StarCollectorGUI> getGui() {
        return this.gui;
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public NovaItemHolder getItemHolder() {
        return this.itemHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    public void reload() {
        super.reload();
        this.maxIdleTime = (int)((double)StarCollectorKt.access$getIDLE_TIME() / ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getSPEED())).doubleValue());
        this.maxCollectionTime = (int)((double)StarCollectorKt.access$getCOLLECTION_TIME() / ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getSPEED())).doubleValue());
    }

    public void handleTick() {
        long l = this.getWorld().getTime();
        boolean bl = 13000L <= l ? l < 23001L : false;
        if (bl || this.timeSpentCollecting != -1) {
            this.handleNightTick();
        } else {
            this.handleDayTick();
        }
    }

    private final void handleNightTick() {
        if (this.timeSpentCollecting != -1) {
            if (!GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && InventoryUtilsKt.isFull((VirtualInventory)this.inventory)) {
                return;
            }
            if (this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getSpecialEnergyConsumption()) {
                ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
                consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getSpecialEnergyConsumption());
                this.handleCollectionTick();
            }
        } else if (this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getEnergyConsumption()) {
            ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
            consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getEnergyConsumption());
            this.handleIdleTick();
        }
    }

    private final void handleCollectionTick() {
        int n = this.timeSpentCollecting;
        this.timeSpentCollecting = n + 1;
        if (this.timeSpentCollecting >= this.maxCollectionTime) {
            this.timeSpentIdle = 0;
            this.timeSpentCollecting = -1;
            ItemStack item = ItemNovaMaterial.createItemStack$default((ItemNovaMaterial)Items.INSTANCE.getSTAR_DUST(), (int)0, (int)1, null);
            int leftOver = this.inventory.addItem(TileEntity.Companion.getSELF_UPDATE_REASON(), item);
            if (GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && leftOver != 0) {
                LocationUtilsKt.dropItem((Location)this.getLocation(), (ItemStack)item);
            }
            this.particleTask.stop();
            BlockModelData blockModelData = this.getMaterial().getBlock();
            Intrinsics.checkNotNull((Object)blockModelData, (String)"null cannot be cast to non-null type xyz.xenondevs.nova.data.resources.model.data.ArmorStandBlockModelData");
            this.rod.setEquipment(EnumItemSlot.f, ((ArmorStandBlockModelData)blockModelData).get(1).get(), true);
        } else {
            double percentageCollected = (double)(this.maxCollectionTime - this.timeSpentCollecting) / (double)this.maxCollectionTime;
            double particleDistance = percentageCollected * (0.75 * (double)this.maxCollectionTime);
            Location location = this.rodLocation.clone();
            Vector vector = this.particleVector;
            if (vector == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"particleVector");
                vector = null;
            }
            Location location2 = location.add(vector.clone().multiply(particleDistance));
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"rodLocation.clone().add(\u2026ltiply(particleDistance))");
            Location particleLocation = location2;
            ParticlePacketBuilderKt.particleBuilder$default((ParticleEffect)ParticleEffect.REDSTONE, null, (Function1)((Function1)new Function1<ParticlePacketBuilder, Unit>(particleLocation){
                final /* synthetic */ Location $particleLocation;
                {
                    this.$particleLocation = $particleLocation;
                    super(1);
                }

                public final void invoke(@NotNull ParticlePacketBuilder $this$particleBuilder) {
                    Intrinsics.checkNotNullParameter((Object)$this$particleBuilder, (String)"$this$particleBuilder");
                    $this$particleBuilder.location(this.$particleLocation);
                    $this$particleBuilder.color(new Color(255, 255, 255));
                }
            }), (int)2, null).display((Collection)this.getViewers());
        }
        if (this.getGui().isInitialized()) {
            ((StarCollectorGUI)((Object)this.getGui().getValue())).getCollectionBar().setPercentage((double)this.timeSpentCollecting / (double)this.maxCollectionTime);
        }
    }

    private final void handleIdleTick() {
        int n = this.timeSpentIdle;
        this.timeSpentIdle = n + 1;
        if (this.timeSpentIdle >= this.maxIdleTime) {
            this.timeSpentCollecting = 0;
            this.particleTask.start();
            BlockModelData blockModelData = this.getMaterial().getBlock();
            Intrinsics.checkNotNull((Object)blockModelData, (String)"null cannot be cast to non-null type xyz.xenondevs.nova.data.resources.model.data.ArmorStandBlockModelData");
            this.rod.setEquipment(EnumItemSlot.f, ((ArmorStandBlockModelData)blockModelData).get(2).get(), true);
            this.rodLocation.setYaw(this.rod.getLocation().getYaw());
            this.particleVector = LocationUtilsKt.Vector((float)this.rod.getLocation().getYaw(), (float)-65.0f);
        } else {
            this.rod.teleport((Function1)handleIdleTick.1.INSTANCE);
        }
        if (this.getGui().isInitialized()) {
            ((StarCollectorGUI)((Object)this.getGui().getValue())).getIdleBar().setPercentage((double)this.timeSpentIdle / (double)this.maxIdleTime);
        }
    }

    private final void handleDayTick() {
        double distance;
        Object v1;
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers()");
        Sequence $this$minByOrNull$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<Player, Boolean>(this){
            final /* synthetic */ StarCollector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Player it) {
                return Intrinsics.areEqual((Object)it.getLocation().getWorld(), (Object)this.this$0.getWorld());
            }
        }));
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                Player it = (Player)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.getLocation().distanceSquared(this.rodLocation);
                do {
                    Object e$iv = iterator$iv.next();
                    Player it2 = (Player)e$iv;
                    $i$a$-minByOrNull-StarCollector$handleDayTick$player$2 = false;
                    double v$iv = it2.getLocation().distanceSquared(this.rodLocation);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        Player player2 = v1;
        if (player2 != null && (distance = this.rodLocation.distance(player2.getLocation())) <= 5.0) {
            Vector vector = player2.getLocation().subtract(this.rodLocation).toVector();
            Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"player.location.subtract(rodLocation).toVector()");
            Vector vector2 = vector;
            float yaw = LocationUtilsKt.calculateYaw((Vector)vector2);
            this.rod.teleport((Function1)new Function1<Location, Unit>(yaw){
                final /* synthetic */ float $yaw;
                {
                    this.$yaw = $yaw;
                    super(1);
                }

                public final void invoke(@NotNull Location $this$teleport) {
                    Intrinsics.checkNotNullParameter((Object)$this$teleport, (String)"$this$teleport");
                    $this$teleport.setYaw(this.$yaw);
                }
            });
        }
    }

    private final void handleInventoryUpdate(ItemUpdateEvent event) {
        event.setCancelled(!Intrinsics.areEqual((Object)event.getUpdateReason(), (Object)TileEntity.Companion.getSELF_UPDATE_REASON()) && !event.isRemove());
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        this.rod.remove();
    }

    public static final /* synthetic */ int access$getTimeSpentCollecting$p(StarCollector $this) {
        return $this.timeSpentCollecting;
    }

    public static final /* synthetic */ void access$handleInventoryUpdate(StarCollector $this, ItemUpdateEvent event) {
        $this.handleInventoryUpdate(event);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/world/StarCollector$StarCollectorGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity$TileEntityGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/world/StarCollector;)V", "collectionBar", "Lxyz/xenondevs/nova/ui/VerticalBar;", "getCollectionBar", "()Lxyz/xenondevs/nova/ui/VerticalBar;", "gui", "Lde/studiocode/invui/gui/GUI;", "getGui", "()Lde/studiocode/invui/gui/GUI;", "idleBar", "getIdleBar", "sideConfigGUI", "Lxyz/xenondevs/nova/ui/config/side/SideConfigGUI;", "machines"})
    public final class StarCollectorGUI
    extends TileEntity.TileEntityGUI {
        @NotNull
        private final SideConfigGUI sideConfigGUI;
        @NotNull
        private final VerticalBar collectionBar;
        @NotNull
        private final VerticalBar idleBar;
        @NotNull
        private final GUI gui;

        public StarCollectorGUI() {
            super((TileEntity)StarCollector.this, null, 1, null);
            this.sideConfigGUI = new SideConfigGUI((NetworkEndPoint)StarCollector.this, CollectionsKt.listOf((Object)TuplesKt.to((Object)StarCollector.this.getItemHolder().getNetworkedInventory(StarCollector.this.inventory), (Object)"inventory.nova.output")), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((StarCollectorGUI)((Object)this.receiver)).openWindow(p0);
                }
            });
            this.collectionBar = new VerticalBar(StarCollector.this){
                @NotNull
                private final ItemNovaMaterial barMaterial;
                final /* synthetic */ StarCollector this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                    this.barMaterial = CoreGUIMaterial.INSTANCE.getBAR_GREEN();
                }

                @NotNull
                public ItemNovaMaterial getBarMaterial() {
                    return this.barMaterial;
                }

                @NotNull
                protected ItemBuilder modifyItemBuilder(@NotNull ItemBuilder itemBuilder) {
                    Intrinsics.checkNotNullParameter((Object)itemBuilder, (String)"itemBuilder");
                    if (StarCollector.access$getTimeSpentCollecting$p(this.this$0) != -1) {
                        BaseComponent[] baseComponentArray = new BaseComponent[1];
                        ChatColor chatColor = ChatColor.GRAY;
                        Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"GRAY");
                        baseComponentArray[0] = (BaseComponent)ComponentUtilsKt.localized((ChatColor)chatColor, (String)"menu.machines.star_collector.collection", (Object[])new Object[0]);
                        itemBuilder.setDisplayName(baseComponentArray);
                    }
                    return itemBuilder;
                }
            };
            this.idleBar = new VerticalBar(){
                @NotNull
                private final ItemNovaMaterial barMaterial;
                {
                    this.barMaterial = CoreGUIMaterial.INSTANCE.getBAR_GREEN();
                }

                @NotNull
                public ItemNovaMaterial getBarMaterial() {
                    return this.barMaterial;
                }

                protected ItemBuilder modifyItemBuilder(@NotNull ItemBuilder itemBuilder) {
                    Intrinsics.checkNotNullParameter((Object)itemBuilder, (String)"itemBuilder");
                    BaseComponent[] baseComponentArray = new BaseComponent[1];
                    ChatColor chatColor = ChatColor.GRAY;
                    Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"GRAY");
                    baseComponentArray[0] = (BaseComponent)ComponentUtilsKt.localized((ChatColor)chatColor, (String)"menu.machines.star_collector.idle", (Object[])new Object[0]);
                    return (ItemBuilder)itemBuilder.setDisplayName(baseComponentArray);
                }
            };
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s # # # c p e |", "| u # i # c p e |", "| # # # # c p e |", "3 - - - - - - - 4"};
            GUI gUI = new GUIBuilder(GUIType.NORMAL).setStructure(stringArray).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGUI)).addIngredient('u', (Item)new OpenUpgradesItem(StarCollector.this.getUpgradeHolder())).addIngredient('i', StarCollector.this.inventory).addIngredient('c', (Supplier)this.collectionBar).addIngredient('p', (Supplier)this.idleBar).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)StarCollector.this.getEnergyHolder())).build();
            Intrinsics.checkNotNullExpressionValue((Object)gUI, (String)"GUIBuilder(GUIType.NORMA\u2026er))\n            .build()");
            this.gui = gUI;
        }

        @NotNull
        public final VerticalBar getCollectionBar() {
            return this.collectionBar;
        }

        @NotNull
        public final VerticalBar getIdleBar() {
            return this.idleBar;
        }

        @NotNull
        public GUI getGui() {
            return this.gui;
        }
    }
}

