/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.world;

import com.google.gson.reflect.TypeToken;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.builder.GUIBuilder;
import de.studiocode.invui.gui.builder.guitype.GUIType;
import de.studiocode.invui.item.Item;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Chunk;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.data.world.legacy.impl.v0_10.cbf.LegacyCompound;
import xyz.xenondevs.nova.machines.tileentity.world.ChunkLoader;
import xyz.xenondevs.nova.machines.tileentity.world.ChunkLoaderKt;
import xyz.xenondevs.nova.tileentity.ChunkLoadManager;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigGUI;
import xyz.xenondevs.nova.ui.item.AddNumberItem;
import xyz.xenondevs.nova.ui.item.DisplayNumberItem;
import xyz.xenondevs.nova.ui.item.RemoveNumberItem;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.world.ChunkPosKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002:\u0001$B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u00000\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/world/ChunkLoader;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "active", "", "chunks", "", "Lorg/bukkit/Chunk;", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "energyPerTick", "", "gui", "Lkotlin/Lazy;", "Lxyz/xenondevs/nova/machines/tileentity/world/ChunkLoader$ChunkLoaderGUI;", "getGui", "()Lkotlin/Lazy;", "range", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "handleRemoved", "", "unload", "handleTick", "reload", "saveData", "setChunksForceLoaded", "state", "setRange", "ChunkLoaderGUI", "machines"})
public final class ChunkLoader
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final Lazy<ChunkLoaderGUI> gui;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    private int range;
    @NotNull
    private List<? extends Chunk> chunks;
    private boolean active;
    private int energyPerTick;

    /*
     * WARNING - void declaration
     */
    public ChunkLoader(@NotNull NovaTileEntityState blockState) {
        Object object;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.gui = LazyKt.lazy((Function0)((Function0)new Function0<ChunkLoaderGUI>(this){
            final /* synthetic */ ChunkLoader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ChunkLoaderGUI invoke() {
                return this.this$0.new ChunkLoaderGUI();
            }
        }));
        DataHolder dataHolder = new DataHolder[]{UpgradeType.Companion.getENERGY(), UpgradeType.Companion.getEFFICIENCY()};
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])dataHolder);
        this.energyHolder = new ConsumerEnergyHolder((NetworkedTileEntity)this, ChunkLoaderKt.access$getMAX_ENERGY$p(), null, null, this.getUpgradeHolder(), (Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ ChunkLoader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, new BlockSide[0]);
            }
        });
        ChunkLoader chunkLoader = this;
        dataHolder = (DataHolder)this;
        String key$iv = "range";
        boolean $i$f$retrieveData = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$retrieveDataOrNull = false;
        if (this_$iv$iv.getLegacyData() != null) {
            LegacyCompound legacyCompound = this_$iv$iv.getLegacyData();
            Intrinsics.checkNotNull((Object)legacyCompound);
            LegacyCompound this_$iv$iv$iv = legacyCompound;
            boolean $i$f$get = false;
            boolean $i$f$type = false;
            Type type = new TypeToken<Integer>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"object : TypeToken<T>() {}.type");
            object = this_$iv$iv$iv.get(type, key$iv);
            if (object == null) {
                this_$iv$iv$iv = this_$iv$iv.getLegacyGlobalData();
                $i$f$get = false;
                $i$f$type = false;
                Type type2 = new TypeToken<Integer>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<T>() {}.type");
                object = this_$iv$iv$iv.get(type2, key$iv);
            }
        } else {
            Compound this_$iv$iv$iv = this_$iv$iv.getData();
            boolean $i$f$get = false;
            boolean $i$f$type = false;
            Type type = new TypeToken<Integer>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"object : TypeToken<T>() {}.type");
            object = this_$iv$iv$iv.get(type, key$iv);
            if (object == null) {
                this_$iv$iv$iv = this_$iv$iv.getGlobalData();
                $i$f$get = false;
                $i$f$type = false;
                Type type3 = new TypeToken<Integer>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"object : TypeToken<T>() {}.type");
                object = this_$iv$iv$iv.get(type3, key$iv);
            }
        }
        Object object2 = object;
        if (object == null) {
            ChunkLoader chunkLoader2 = chunkLoader;
            boolean bl = false;
            object2 = 0;
            chunkLoader = chunkLoader2;
        }
        chunkLoader.range = ((Number)object2).intValue();
        this.chunks = LocationUtilsKt.getSurroundingChunks$default((Chunk)this.getChunk(), (int)this.range, (boolean)true, (boolean)false, (int)4, null);
        this.reload();
    }

    @NotNull
    public Lazy<ChunkLoaderGUI> getGui() {
        return this.gui;
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    public void reload() {
        super.reload();
        this.energyPerTick = (int)((double)(ChunkLoaderKt.access$getENERGY_PER_CHUNK() * (long)this.chunks.size()) / ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getEFFICIENCY())).doubleValue());
    }

    public void saveData() {
        super.saveData();
        DataHolder.storeData$default((DataHolder)((DataHolder)this), (String)"range", (Object)this.range, (boolean)false, (int)4, null);
    }

    public void handleTick() {
        if (this.getEnergyHolder().getEnergy() >= (long)this.energyPerTick) {
            ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
            consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - (long)this.energyPerTick);
            if (!this.active) {
                this.setChunksForceLoaded(true);
                this.active = true;
            }
        } else if (this.active) {
            this.setChunksForceLoaded(false);
            this.active = false;
        }
    }

    private final void setChunksForceLoaded(boolean state) {
        Iterable $this$forEach$iv = this.chunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Chunk it = (Chunk)element$iv;
            boolean bl = false;
            if (state) {
                ChunkLoadManager.INSTANCE.submitChunkLoadRequest(ChunkPosKt.getPos((Chunk)it), this.getUuid());
                continue;
            }
            ChunkLoadManager.INSTANCE.revokeChunkLoadRequest(ChunkPosKt.getPos((Chunk)it), this.getUuid());
        }
    }

    private final void setRange(int range) {
        this.range = range;
        this.setChunksForceLoaded(false);
        this.chunks = LocationUtilsKt.getSurroundingChunks$default((Chunk)this.getChunk(), (int)range, (boolean)true, (boolean)false, (int)4, null);
        this.active = false;
        this.reload();
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        if (!unload) {
            this.setChunksForceLoaded(false);
        }
    }

    public static final /* synthetic */ int access$getRange$p(ChunkLoader $this) {
        return $this.range;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/world/ChunkLoader$ChunkLoaderGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity$TileEntityGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/world/ChunkLoader;)V", "gui", "Lde/studiocode/invui/gui/GUI;", "getGui", "()Lde/studiocode/invui/gui/GUI;", "rangeItems", "Ljava/util/ArrayList;", "Lde/studiocode/invui/item/Item;", "Lkotlin/collections/ArrayList;", "sideConfigGUI", "Lxyz/xenondevs/nova/ui/config/side/SideConfigGUI;", "setRange", "", "range", "", "machines"})
    public final class ChunkLoaderGUI
    extends TileEntity.TileEntityGUI {
        @NotNull
        private final SideConfigGUI sideConfigGUI;
        @NotNull
        private final ArrayList<Item> rangeItems;
        @NotNull
        private final GUI gui;

        public ChunkLoaderGUI() {
            Item p0;
            super((TileEntity)ChunkLoader.this, null, 1, null);
            this.sideConfigGUI = new SideConfigGUI((NetworkEndPoint)ChunkLoader.this, (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((ChunkLoaderGUI)((Object)this.receiver)).openWindow(p0);
                }
            });
            this.rangeItems = new ArrayList();
            String[] stringArray = new String[]{"1 - - - - - - 2 e", "| u # m n p # | e", "3 - - - - - - 4 e"};
            GUIBuilder gUIBuilder = new GUIBuilder(GUIType.NORMAL).setStructure(stringArray).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGUI));
            stringArray = new AddNumberItem((Function0)gui.1.INSTANCE, (Function0)new Function0<Integer>(ChunkLoader.this){
                final /* synthetic */ ChunkLoader this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    return ChunkLoader.access$getRange$p(this.this$0);
                }
            }, (Function1)new Function1<Integer, Unit>((Object)this){

                public final void invoke(int p0) {
                    ChunkLoaderGUI.access$setRange((ChunkLoaderGUI)((Object)this.receiver), p0);
                }
            }, null, 8, null);
            ArrayList<Item> arrayList = this.rangeItems;
            Item item = (Item)stringArray;
            char c = 'p';
            GUIBuilder gUIBuilder2 = gUIBuilder;
            ChunkLoaderGUI chunkLoaderGUI = this;
            boolean bl = false;
            arrayList.add(p0);
            Unit unit = Unit.INSTANCE;
            GUIBuilder gUIBuilder3 = gUIBuilder2.addIngredient(c, (Item)stringArray);
            stringArray = new RemoveNumberItem((Function0)gui.5.INSTANCE, (Function0)new Function0<Integer>(ChunkLoader.this){
                final /* synthetic */ ChunkLoader this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    return ChunkLoader.access$getRange$p(this.this$0);
                }
            }, (Function1)new Function1<Integer, Unit>((Object)this){

                public final void invoke(int p0) {
                    ChunkLoaderGUI.access$setRange((ChunkLoaderGUI)((Object)this.receiver), p0);
                }
            }, null, 8, null);
            arrayList = this.rangeItems;
            p0 = (Item)stringArray;
            c = 'm';
            gUIBuilder2 = gUIBuilder3;
            boolean bl2 = false;
            arrayList.add(p0);
            unit = Unit.INSTANCE;
            GUIBuilder gUIBuilder4 = gUIBuilder2.addIngredient(c, (Item)stringArray);
            stringArray = new DisplayNumberItem((Function0)new Function0<Integer>(ChunkLoader.this){
                final /* synthetic */ ChunkLoader this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    return ChunkLoader.access$getRange$p(this.this$0) + 1;
                }
            });
            arrayList = this.rangeItems;
            p0 = (Item)stringArray;
            c = 'n';
            gUIBuilder2 = gUIBuilder4;
            boolean bl3 = false;
            arrayList.add(p0);
            unit = Unit.INSTANCE;
            GUI gUI = gUIBuilder2.addIngredient(c, (Item)stringArray).addIngredient('u', (Item)new OpenUpgradesItem(ChunkLoader.this.getUpgradeHolder())).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)ChunkLoader.this.getEnergyHolder())).build();
            Intrinsics.checkNotNullExpressionValue((Object)gUI, (String)"GUIBuilder(GUIType.NORMA\u2026er))\n            .build()");
            chunkLoaderGUI.gui = gUI;
        }

        @NotNull
        public GUI getGui() {
            return this.gui;
        }

        private final void setRange(int range) {
            ChunkLoader.this.setRange(range);
            Iterable $this$forEach$iv = this.rangeItems;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Item p0 = (Item)element$iv;
                boolean bl = false;
                p0.notifyWindows();
            }
        }

        public static final /* synthetic */ void access$setRange(ChunkLoaderGUI $this, int range) {
            $this.setRange(range);
        }
    }
}

