/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.world;

import com.google.gson.reflect.TypeToken;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.builder.GUIBuilder;
import de.studiocode.invui.gui.builder.guitype.GUIType;
import de.studiocode.invui.item.Item;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import de.studiocode.invui.virtualinventory.event.ItemUpdateEvent;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.nova.api.event.tileentity.TileEntityBreakBlockEvent;
import xyz.xenondevs.nova.api.tileentity.TileEntity;
import xyz.xenondevs.nova.data.config.GlobalValues;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.data.world.legacy.impl.v0_10.cbf.LegacyCompound;
import xyz.xenondevs.nova.integration.protection.ProtectionManager;
import xyz.xenondevs.nova.machines.tileentity.world.BlockBreakerKt;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigGUI;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.BlockUtilsKt;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.nova.util.item.ToolUtils;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.block.context.BlockBreakContext;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001*B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\"H\u0016J\b\u0010)\u001a\u00020\"H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0012R\u00020\u00000\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006+"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/world/BlockBreaker;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "block", "Lorg/bukkit/block/Block;", "breakProgress", "", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "entityId", "", "gui", "Lkotlin/Lazy;", "Lxyz/xenondevs/nova/machines/tileentity/world/BlockBreaker$BlockBreakerGUI;", "getGui", "()Lkotlin/Lazy;", "inventory", "Lde/studiocode/invui/virtualinventory/VirtualInventory;", "itemHolder", "Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "getItemHolder", "()Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "lastType", "Lorg/bukkit/Material;", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "handleInventoryUpdate", "", "event", "Lde/studiocode/invui/virtualinventory/event/ItemUpdateEvent;", "handleRemoved", "unload", "", "handleTick", "saveData", "BlockBreakerGUI", "machines"})
public final class BlockBreaker
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final VirtualInventory inventory;
    @NotNull
    private final Lazy<BlockBreakerGUI> gui;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    @NotNull
    private final NovaItemHolder itemHolder;
    private final int entityId;
    @NotNull
    private final Block block;
    @Nullable
    private Material lastType;
    private double breakProgress;

    /*
     * WARNING - void declaration
     */
    public BlockBreaker(@NotNull NovaTileEntityState blockState) {
        Object object;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.inventory = xyz.xenondevs.nova.tileentity.TileEntity.getInventory$default((xyz.xenondevs.nova.tileentity.TileEntity)((xyz.xenondevs.nova.tileentity.TileEntity)this), (String)"inventory", (int)9, (Function1)((Function1)new Function1<ItemUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                BlockBreaker.access$handleInventoryUpdate((BlockBreaker)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        this.gui = LazyKt.lazy((Function0)((Function0)new Function0<BlockBreakerGUI>(this){
            final /* synthetic */ BlockBreaker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BlockBreakerGUI invoke() {
                return this.this$0.new BlockBreakerGUI();
            }
        }));
        DataHolder dataHolder = new DataHolder[]{UpgradeType.Companion.getSPEED(), UpgradeType.Companion.getEFFICIENCY(), UpgradeType.Companion.getENERGY()};
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])dataHolder);
        this.energyHolder = new ConsumerEnergyHolder((NetworkedTileEntity)this, BlockBreakerKt.access$getMAX_ENERGY$p(), BlockBreakerKt.access$getENERGY_PER_TICK$p(), null, this.getUpgradeHolder(), (Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ BlockBreaker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        });
        this.itemHolder = NovaItemHolderKt.NovaItemHolder$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.inventory, (Object)NetworkConnectionType.EXTRACT), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ BlockBreaker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        }), (int)8, null);
        this.entityId = this.getUuid().hashCode();
        Location location = this.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location.clone()");
        Block block = LocationUtilsKt.advance$default((Location)location, (BlockFace)this.getFace(BlockSide.FRONT), (double)0.0, (int)2, null).getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"location.clone().advance\u2026e(BlockSide.FRONT)).block");
        this.block = block;
        BlockBreaker blockBreaker = this;
        dataHolder = (DataHolder)this;
        String key$iv = "breakProgress";
        boolean $i$f$retrieveData = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$retrieveDataOrNull = false;
        if (this_$iv$iv.getLegacyData() != null) {
            LegacyCompound legacyCompound = this_$iv$iv.getLegacyData();
            Intrinsics.checkNotNull((Object)legacyCompound);
            LegacyCompound this_$iv$iv$iv = legacyCompound;
            boolean $i$f$get = false;
            boolean $i$f$type = false;
            Type type = new TypeToken<Double>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"object : TypeToken<T>() {}.type");
            object = this_$iv$iv$iv.get(type, key$iv);
            if (object == null) {
                this_$iv$iv$iv = this_$iv$iv.getLegacyGlobalData();
                $i$f$get = false;
                $i$f$type = false;
                Type type2 = new TypeToken<Double>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<T>() {}.type");
                object = this_$iv$iv$iv.get(type2, key$iv);
            }
        } else {
            Compound this_$iv$iv$iv = this_$iv$iv.getData();
            boolean $i$f$get = false;
            boolean $i$f$type = false;
            Type type = new TypeToken<Double>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"object : TypeToken<T>() {}.type");
            object = this_$iv$iv$iv.get(type, key$iv);
            if (object == null) {
                this_$iv$iv$iv = this_$iv$iv.getGlobalData();
                $i$f$get = false;
                $i$f$type = false;
                Type type3 = new TypeToken<Double>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"object : TypeToken<T>() {}.type");
                object = this_$iv$iv$iv.get(type3, key$iv);
            }
        }
        Object object2 = object;
        if (object == null) {
            BlockBreaker blockBreaker2 = blockBreaker;
            boolean bl = false;
            object2 = 0.0;
            blockBreaker = blockBreaker2;
        }
        blockBreaker.breakProgress = ((Number)object2).doubleValue();
    }

    @NotNull
    public Lazy<BlockBreakerGUI> getGui() {
        return this.gui;
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    @NotNull
    public NovaItemHolder getItemHolder() {
        return this.itemHolder;
    }

    public void saveData() {
        super.saveData();
        DataHolder.storeData$default((DataHolder)((DataHolder)this), (String)"breakProgress", (Object)this.breakProgress, (boolean)false, (int)4, null);
    }

    private final void handleInventoryUpdate(ItemUpdateEvent event) {
        if (event.isAdd() && !Intrinsics.areEqual((Object)event.getUpdateReason(), (Object)xyz.xenondevs.nova.tileentity.TileEntity.Companion.getSELF_UPDATE_REASON())) {
            event.setCancelled(true);
        }
    }

    public void handleTick() {
        Material material = this.block.getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"block.type");
        Material type = material;
        if (this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getEnergyConsumption() && !MaterialUtilsKt.isTraversable((Material)type) && BlockUtilsKt.getHardness((Block)this.block) >= 0.0) {
            xyz.xenondevs.nova.tileentity.TileEntity tileEntity = (xyz.xenondevs.nova.tileentity.TileEntity)this;
            Location location = this.block.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"block.location");
            Object t = ProtectionManager.INSTANCE.canBreak(tileEntity, null, location).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"ProtectionManager.canBre\u2026ll, block.location).get()");
            if (((Boolean)t).booleanValue()) {
                ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
                consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getEnergyConsumption());
                if (this.lastType != null && type != this.lastType) {
                    this.breakProgress = 0.0;
                }
                this.lastType = type;
                double damage = RangesKt.coerceAtMost((double)ToolUtils.INSTANCE.calculateDamage(BlockUtilsKt.getHardness((Block)this.block), true, true, BlockBreakerKt.access$getBREAK_SPEED_MULTIPLIER() * ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getSPEED())).doubleValue(), 0, true, false, 0, 0), (double)BlockBreakerKt.access$getBREAK_SPEED_CLAMP());
                this.breakProgress = Math.min(1.0, this.breakProgress + damage);
                if (this.breakProgress >= 1.0) {
                    BlockBreakContext ctx = new BlockBreakContext(BlockPosKt.getPos((Block)this.block), (Object)this, this.getLocation(), null, null, 24, null);
                    List drops = CollectionsKt.toMutableList((Collection)BlockUtilsKt.getAllDrops((Block)this.block, (BlockBreakContext)ctx));
                    TileEntityBreakBlockEvent tileEntityBreakBlockEvent = new TileEntityBreakBlockEvent((TileEntity)this, this.block, drops);
                    Event p0 = (Event)tileEntityBreakBlockEvent;
                    boolean bl = false;
                    EventUtilsKt.callEvent((Event)p0);
                    drops = tileEntityBreakBlockEvent.getDrops();
                    if (!GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && !this.inventory.canHold(drops)) {
                        return;
                    }
                    this.breakProgress = 0.0;
                    BlockUtilsKt.setBreakStage((Block)this.block, (int)this.entityId, (int)-1);
                    BlockUtilsKt.remove$default((Block)this.block, (BlockBreakContext)ctx, (boolean)false, (boolean)false, (int)6, null);
                    Iterable $this$forEach$iv = drops;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ItemStack drop = (ItemStack)element$iv;
                        boolean bl2 = false;
                        int amountLeft = this.inventory.addItem(xyz.xenondevs.nova.tileentity.TileEntity.Companion.getSELF_UPDATE_REASON(), drop);
                        if (!GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() || amountLeft == 0) continue;
                        drop.setAmount(amountLeft);
                        World world = this.getWorld();
                        Location location2 = this.block.getLocation();
                        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"block.location");
                        world.dropItemNaturally(LocationUtilsKt.center((Location)location2), drop);
                    }
                } else {
                    BlockUtilsKt.setBreakStage((Block)this.block, (int)this.entityId, (int)MathKt.roundToInt((double)(this.breakProgress * (double)9)));
                }
            }
        }
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        if (!unload) {
            BlockUtilsKt.setBreakStage((Block)this.block, (int)this.entityId, (int)-1);
        }
    }

    public static final /* synthetic */ void access$handleInventoryUpdate(BlockBreaker $this, ItemUpdateEvent event) {
        $this.handleInventoryUpdate(event);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/world/BlockBreaker$BlockBreakerGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity$TileEntityGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/world/BlockBreaker;)V", "gui", "Lde/studiocode/invui/gui/GUI;", "getGui", "()Lde/studiocode/invui/gui/GUI;", "sideConfigGUI", "Lxyz/xenondevs/nova/ui/config/side/SideConfigGUI;", "machines"})
    public final class BlockBreakerGUI
    extends TileEntity.TileEntityGUI {
        @NotNull
        private final SideConfigGUI sideConfigGUI;
        @NotNull
        private final GUI gui;

        public BlockBreakerGUI() {
            super((xyz.xenondevs.nova.tileentity.TileEntity)BlockBreaker.this, null, 1, null);
            this.sideConfigGUI = new SideConfigGUI((NetworkEndPoint)BlockBreaker.this, CollectionsKt.listOf((Object)new Pair((Object)BlockBreaker.this.getItemHolder().getNetworkedInventory(BlockBreaker.this.inventory), (Object)"inventory.nova.default")), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((BlockBreakerGUI)((Object)this.receiver)).openWindow(p0);
                }
            });
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s # i i i # e |", "| u # i i i # e |", "| # # i i i # e |", "3 - - - - - - - 4"};
            GUI gUI = new GUIBuilder(GUIType.NORMAL).setStructure(stringArray).addIngredient('i', BlockBreaker.this.inventory).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGUI)).addIngredient('u', (Item)new OpenUpgradesItem(BlockBreaker.this.getUpgradeHolder())).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)BlockBreaker.this.getEnergyHolder())).build();
            Intrinsics.checkNotNullExpressionValue((Object)gUI, (String)"GUIBuilder(GUIType.NORMA\u2026er))\n            .build()");
            this.gui = gUI;
        }

        @NotNull
        public GUI getGui() {
            return this.gui;
        }
    }
}

