/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.processing;

import com.google.gson.reflect.TypeToken;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.builder.GUIBuilder;
import de.studiocode.invui.gui.builder.guitype.GUIType;
import de.studiocode.invui.item.Item;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.item.impl.BaseItem;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import de.studiocode.invui.virtualinventory.event.ItemUpdateEvent;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.nova.data.provider.Provider;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.data.world.legacy.impl.v0_10.cbf.LegacyCompound;
import xyz.xenondevs.nova.machines.gui.LeftRightFluidProgressItem;
import xyz.xenondevs.nova.machines.registry.GUIMaterials;
import xyz.xenondevs.nova.machines.tileentity.processing.FreezerKt;
import xyz.xenondevs.nova.material.ItemNovaMaterial;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.FluidType;
import xyz.xenondevs.nova.tileentity.network.fluid.container.FluidContainer;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.FluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolderKt;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.FluidBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigGUI;
import xyz.xenondevs.nova.util.BlockSide;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0002-.B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020'H\u0016J\b\u0010+\u001a\u00020'H\u0016J\b\u0010,\u001a\u00020'H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/processing/Freezer;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "fluidHolder", "Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "getFluidHolder", "()Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "gui", "Lkotlin/Lazy;", "Lxyz/xenondevs/nova/machines/tileentity/processing/Freezer$FreezerGUI;", "getGui", "()Lkotlin/Lazy;", "inventory", "Lde/studiocode/invui/virtualinventory/VirtualInventory;", "itemHolder", "Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "getItemHolder", "()Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "mbPerTick", "", "mbUsed", "mode", "Lxyz/xenondevs/nova/machines/tileentity/processing/Freezer$Mode;", "snowSpawnBlock", "Lorg/bukkit/block/Block;", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "waterTank", "Lxyz/xenondevs/nova/tileentity/network/fluid/container/FluidContainer;", "handleInventoryUpdate", "", "event", "Lde/studiocode/invui/virtualinventory/event/ItemUpdateEvent;", "handleTick", "reload", "saveData", "FreezerGUI", "Mode", "machines"})
public final class Freezer
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final Lazy<FreezerGUI> gui;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final VirtualInventory inventory;
    @NotNull
    private final FluidContainer waterTank;
    @NotNull
    private final NovaFluidHolder fluidHolder;
    @NotNull
    private final NovaItemHolder itemHolder;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    @NotNull
    private final Block snowSpawnBlock;
    private long mbPerTick;
    private long mbUsed;
    @NotNull
    private Mode mode;

    /*
     * WARNING - void declaration
     */
    public Freezer(@NotNull NovaTileEntityState blockState) {
        Object object;
        void this_$iv;
        void $this$snowSpawnBlock_u24lambda_u240;
        Location location;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.gui = LazyKt.lazy((Function0)((Function0)new Function0<FreezerGUI>((Object)this){

            @NotNull
            public final FreezerGUI invoke() {
                return (Freezer)((Object)this.receiver).new FreezerGUI();
            }
        }));
        DataHolder dataHolder = new DataHolder[]{UpgradeType.Companion.getSPEED(), UpgradeType.Companion.getEFFICIENCY(), UpgradeType.Companion.getENERGY(), UpgradeType.Companion.getFLUID()};
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])dataHolder);
        this.inventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"inventory", (int)6, (Function1)((Function1)new Function1<ItemUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Freezer.access$handleInventoryUpdate((Freezer)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        this.waterTank = TileEntity.getFluidContainer$default((TileEntity)((TileEntity)this), (String)"water", (Set)SetsKt.setOf((Object)FluidType.WATER), (Provider)FreezerKt.access$getWATER_CAPACITY$p(), (long)0L, null, (UpgradeHolder)this.getUpgradeHolder(), (boolean)false, (int)80, null);
        this.fluidHolder = NovaFluidHolderKt.NovaFluidHolder$default((DataHolder)((DataHolder)this), (Pair)TuplesKt.to((Object)this.waterTank, (Object)NetworkConnectionType.BUFFER), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ Freezer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }), (int)8, null);
        this.itemHolder = NovaItemHolderKt.NovaItemHolder$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.inventory, (Object)NetworkConnectionType.EXTRACT), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ Freezer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        }), (int)8, null);
        this.energyHolder = new ConsumerEnergyHolder((NetworkedTileEntity)this, FreezerKt.access$getENERGY_CAPACITY$p(), FreezerKt.access$getENERGY_PER_TICK$p(), null, this.getUpgradeHolder(), (Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ Freezer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        });
        Location location2 = location = this.getLocation().clone();
        Freezer freezer = this;
        boolean bl = false;
        $this$snowSpawnBlock_u24lambda_u240.setY($this$snowSpawnBlock_u24lambda_u240.getY() + 1.0);
        Block block = location.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"location.clone().apply { y += 1 }.block");
        freezer.snowSpawnBlock = block;
        Freezer freezer2 = this;
        dataHolder = (DataHolder)this;
        String key$iv = "mode";
        boolean $i$f$retrieveData = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$retrieveDataOrNull = false;
        if (this_$iv$iv.getLegacyData() != null) {
            LegacyCompound legacyCompound = this_$iv$iv.getLegacyData();
            Intrinsics.checkNotNull((Object)legacyCompound);
            LegacyCompound this_$iv$iv$iv = legacyCompound;
            boolean $i$f$get = false;
            boolean $i$f$type = false;
            Type type = new TypeToken<Mode>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"object : TypeToken<T>() {}.type");
            object = this_$iv$iv$iv.get(type, key$iv);
            if (object == null) {
                this_$iv$iv$iv = this_$iv$iv.getLegacyGlobalData();
                $i$f$get = false;
                $i$f$type = false;
                Type type2 = new TypeToken<Mode>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<T>() {}.type");
                object = this_$iv$iv$iv.get(type2, key$iv);
            }
        } else {
            Compound this_$iv$iv$iv = this_$iv$iv.getData();
            boolean $i$f$get = false;
            boolean $i$f$type = false;
            Type type = new TypeToken<Mode>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"object : TypeToken<T>() {}.type");
            object = this_$iv$iv$iv.get(type, key$iv);
            if (object == null) {
                this_$iv$iv$iv = this_$iv$iv.getGlobalData();
                $i$f$get = false;
                $i$f$type = false;
                Type type3 = new TypeToken<Mode>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"object : TypeToken<T>() {}.type");
                object = this_$iv$iv$iv.get(type3, key$iv);
            }
        }
        Object object2 = object;
        if (object == null) {
            freezer = freezer2;
            boolean bl2 = false;
            object2 = Mode.ICE;
            freezer2 = freezer;
        }
        freezer2.mode = (Mode)((Object)object2);
        this.reload();
    }

    @NotNull
    public Lazy<FreezerGUI> getGui() {
        return this.gui;
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public NovaFluidHolder getFluidHolder() {
        return this.fluidHolder;
    }

    @NotNull
    public NovaItemHolder getItemHolder() {
        return this.itemHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    public void reload() {
        super.reload();
        this.mbPerTick = MathKt.roundToLong((double)((double)FreezerKt.access$getMB_PER_TICK() * ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getSPEED())).doubleValue()));
    }

    private final void handleInventoryUpdate(ItemUpdateEvent event) {
        event.setCancelled(!event.isRemove() && !Intrinsics.areEqual((Object)event.getUpdateReason(), (Object)TileEntity.Companion.getSELF_UPDATE_REASON()));
    }

    public void handleTick() {
        int compensationCount;
        ItemStack compensationItems;
        int mbMaxPerOperation = 1000 * this.mode.getMaxCostMultiplier();
        if (this.mbUsed > (long)mbMaxPerOperation && this.inventory.canHold(this.mode.getProduct(), new ItemStack[0]) && this.inventory.canHold(compensationItems = new ItemStack(Material.ICE, compensationCount = MathKt.roundToInt((double)((double)this.mbUsed / (double)mbMaxPerOperation))), new ItemStack[0])) {
            this.inventory.addItem(TileEntity.Companion.getSELF_UPDATE_REASON(), compensationItems);
            this.mbUsed -= (long)(compensationCount * mbMaxPerOperation);
        }
        long mbToTake = Long.min(this.mbPerTick, (long)mbMaxPerOperation - this.mbUsed);
        if (this.waterTank.getAmount() >= mbToTake && this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getEnergyConsumption() && this.inventory.canHold(this.mode.getProduct(), new ItemStack[0])) {
            if (this.snowSpawnBlock.getType().isAir()) {
                this.snowSpawnBlock.setType(Material.SNOW);
            }
            ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
            consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getEnergyConsumption());
            this.mbUsed += mbToTake;
            this.waterTank.takeFluid(mbToTake);
            if (this.mbUsed >= (long)mbMaxPerOperation) {
                this.mbUsed = 0L;
                this.inventory.addItem(TileEntity.Companion.getSELF_UPDATE_REASON(), this.mode.getProduct());
            }
            if (this.getGui().isInitialized()) {
                ((FreezerGUI)((Object)this.getGui().getValue())).updateProgress();
            }
        }
    }

    public void saveData() {
        super.saveData();
        DataHolder.storeData$default((DataHolder)((DataHolder)this), (String)"mode", (Object)((Object)this.mode), (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ void access$handleInventoryUpdate(Freezer $this, ItemUpdateEvent event) {
        $this.handleInventoryUpdate(event);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/processing/Freezer$FreezerGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity$TileEntityGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/processing/Freezer;)V", "gui", "Lde/studiocode/invui/gui/GUI;", "getGui", "()Lde/studiocode/invui/gui/GUI;", "progressItem", "Lxyz/xenondevs/nova/machines/gui/LeftRightFluidProgressItem;", "sideConfigGUI", "Lxyz/xenondevs/nova/ui/config/side/SideConfigGUI;", "updateProgress", "", "ChangeModeItem", "machines"})
    public final class FreezerGUI
    extends TileEntity.TileEntityGUI {
        @NotNull
        private final LeftRightFluidProgressItem progressItem;
        @NotNull
        private final SideConfigGUI sideConfigGUI;
        @NotNull
        private final GUI gui;

        public FreezerGUI() {
            super((TileEntity)Freezer.this, null, 1, null);
            this.progressItem = new LeftRightFluidProgressItem();
            this.sideConfigGUI = new SideConfigGUI((NetworkEndPoint)Freezer.this, CollectionsKt.listOf((Object)TuplesKt.to((Object)Freezer.this.getItemHolder().getNetworkedInventory(Freezer.this.inventory), (Object)"inventory.nova.output")), CollectionsKt.listOf((Object)TuplesKt.to((Object)Freezer.this.waterTank, (Object)"container.nova.water_tank")), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((FreezerGUI)((Object)this.receiver)).openWindow(p0);
                }
            });
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| w # i i # s e |", "| w > i i # u e |", "| w # i i # m e |", "3 - - - - - - - 4"};
            GUI gUI = new GUIBuilder(GUIType.NORMAL).setStructure(stringArray).addIngredient('i', Freezer.this.inventory).addIngredient('>', (Item)this.progressItem).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGUI)).addIngredient('u', (Item)new OpenUpgradesItem(Freezer.this.getUpgradeHolder())).addIngredient('m', (Item)new ChangeModeItem()).addIngredient('w', (Supplier)new FluidBar(3, (FluidHolder)Freezer.this.getFluidHolder(), Freezer.this.waterTank)).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)Freezer.this.getEnergyHolder())).build();
            Intrinsics.checkNotNullExpressionValue((Object)gUI, (String)"GUIBuilder(GUIType.NORMA\u2026er))\n            .build()");
            this.gui = gUI;
        }

        @NotNull
        public GUI getGui() {
            return this.gui;
        }

        public final void updateProgress() {
            this.progressItem.setPercentage((double)Freezer.this.mbUsed / (double)(1000 * Freezer.this.mode.getMaxCostMultiplier()));
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/processing/Freezer$FreezerGUI$ChangeModeItem;", "Lde/studiocode/invui/item/impl/BaseItem;", "(Lxyz/xenondevs/nova/machines/tileentity/processing/Freezer$FreezerGUI;)V", "getItemProvider", "Lde/studiocode/invui/item/ItemProvider;", "handleClick", "", "clickType", "Lorg/bukkit/event/inventory/ClickType;", "player", "Lorg/bukkit/entity/Player;", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "machines"})
        private final class ChangeModeItem
        extends BaseItem {
            @NotNull
            public ItemProvider getItemProvider() {
                return Freezer.this.mode.getUiItem().getClientsideProvider();
            }

            public void handleClick(@NotNull ClickType clickType, @NotNull Player player2, @NotNull InventoryClickEvent event) {
                Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
                Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (clickType == ClickType.LEFT || clickType == ClickType.RIGHT) {
                    int direction = clickType == ClickType.LEFT ? 1 : -1;
                    int n = Freezer.this.mode.ordinal() + direction;
                    int n2 = Mode.values().length;
                    int n3 = n % n2;
                    Freezer.this.mode = Mode.values()[n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31)];
                    player2.playSound(player2.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    this.notifyWindows();
                }
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/processing/Freezer$Mode;", "", "product", "Lorg/bukkit/inventory/ItemStack;", "uiItem", "Lxyz/xenondevs/nova/material/ItemNovaMaterial;", "maxCostMultiplier", "", "(Ljava/lang/String;ILorg/bukkit/inventory/ItemStack;Lxyz/xenondevs/nova/material/ItemNovaMaterial;I)V", "getMaxCostMultiplier", "()I", "getProduct", "()Lorg/bukkit/inventory/ItemStack;", "getUiItem", "()Lxyz/xenondevs/nova/material/ItemNovaMaterial;", "ICE", "PACKED_ICE", "BLUE_ICE", "machines"})
    public static final class Mode
    extends Enum<Mode> {
        @NotNull
        private final ItemStack product;
        @NotNull
        private final ItemNovaMaterial uiItem;
        private final int maxCostMultiplier;
        public static final /* enum */ Mode ICE = new Mode(new ItemStack(Material.ICE), GUIMaterials.INSTANCE.getICE_MODE_BTN(), 1);
        public static final /* enum */ Mode PACKED_ICE = new Mode(new ItemStack(Material.PACKED_ICE), GUIMaterials.INSTANCE.getPACKED_ICE_MODE_BTN(), 9);
        public static final /* enum */ Mode BLUE_ICE = new Mode(new ItemStack(Material.BLUE_ICE), GUIMaterials.INSTANCE.getBLUE_ICE_MODE_BTN(), 81);
        private static final /* synthetic */ Mode[] $VALUES;

        private Mode(ItemStack product, ItemNovaMaterial uiItem, int maxCostMultiplier) {
            this.product = product;
            this.uiItem = uiItem;
            this.maxCostMultiplier = maxCostMultiplier;
        }

        @NotNull
        public final ItemStack getProduct() {
            return this.product;
        }

        @NotNull
        public final ItemNovaMaterial getUiItem() {
            return this.uiItem;
        }

        public final int getMaxCostMultiplier() {
            return this.maxCostMultiplier;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.ICE, Mode.PACKED_ICE, Mode.BLUE_ICE};
        }
    }
}

