/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.processing;

import com.google.gson.reflect.TypeToken;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.builder.GUIBuilder;
import de.studiocode.invui.gui.builder.guitype.GUIType;
import de.studiocode.invui.item.Item;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.item.impl.BaseItem;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import de.studiocode.invui.virtualinventory.event.ItemUpdateEvent;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.world.entity.EnumItemSlot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.nova.data.provider.Provider;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.data.world.legacy.impl.v0_10.cbf.LegacyCompound;
import xyz.xenondevs.nova.machines.gui.LeftRightFluidProgressItem;
import xyz.xenondevs.nova.machines.registry.Blocks;
import xyz.xenondevs.nova.machines.registry.GUIMaterials;
import xyz.xenondevs.nova.machines.tileentity.processing.CobblestoneGenerator;
import xyz.xenondevs.nova.machines.tileentity.processing.CobblestoneGeneratorKt;
import xyz.xenondevs.nova.material.ItemNovaMaterial;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.FluidType;
import xyz.xenondevs.nova.tileentity.network.fluid.container.FluidContainer;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.FluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolderKt;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.FluidBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigGUI;
import xyz.xenondevs.nova.util.BlockFaceUtilsKt;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.ParticlePacketBuilder;
import xyz.xenondevs.nova.util.ParticlePacketBuilderKt;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeArmorStand;
import xyz.xenondevs.particle.ParticleEffect;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0002:;B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001eH\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020/2\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020/H\u0016J\b\u00106\u001a\u00020/H\u0016J\b\u00107\u001a\u00020/H\u0016J\b\u00108\u001a\u00020/H\u0002J\b\u00109\u001a\u00020/H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0012R\u00020\u00000\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/processing/CobblestoneGenerator;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "currentMode", "Lxyz/xenondevs/nova/machines/tileentity/processing/CobblestoneGenerator$Mode;", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "fluidHolder", "Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "getFluidHolder", "()Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "gui", "Lkotlin/Lazy;", "Lxyz/xenondevs/nova/machines/tileentity/processing/CobblestoneGenerator$CobblestoneGeneratorGUI;", "getGui", "()Lkotlin/Lazy;", "inventory", "Lde/studiocode/invui/virtualinventory/VirtualInventory;", "itemHolder", "Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "getItemHolder", "()Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "lavaLevel", "Lxyz/xenondevs/nova/world/fakeentity/impl/FakeArmorStand;", "lavaTank", "Lxyz/xenondevs/nova/tileentity/network/fluid/container/FluidContainer;", "mbPerTick", "", "mbUsed", "mode", "particleEffect", "Lxyz/xenondevs/nova/util/ParticlePacketBuilder;", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "waterLevel", "waterTank", "getFluidState", "", "container", "handleInventoryUpdate", "", "event", "Lde/studiocode/invui/virtualinventory/event/ItemUpdateEvent;", "handleRemoved", "unload", "", "handleTick", "reload", "saveData", "updateLavaLevel", "updateWaterLevel", "CobblestoneGeneratorGUI", "Mode", "machines"})
public final class CobblestoneGenerator
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final Lazy<CobblestoneGeneratorGUI> gui;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final VirtualInventory inventory;
    @NotNull
    private final FluidContainer waterTank;
    @NotNull
    private final FluidContainer lavaTank;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    @NotNull
    private final NovaItemHolder itemHolder;
    @NotNull
    private final NovaFluidHolder fluidHolder;
    @NotNull
    private Mode mode;
    private long mbPerTick;
    @NotNull
    private Mode currentMode;
    private long mbUsed;
    @NotNull
    private final FakeArmorStand waterLevel;
    @NotNull
    private final FakeArmorStand lavaLevel;
    @NotNull
    private final ParticlePacketBuilder particleEffect;

    /*
     * WARNING - void declaration
     */
    public CobblestoneGenerator(@NotNull NovaTileEntityState blockState) {
        Object object;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.gui = LazyKt.lazy((Function0)((Function0)new Function0<CobblestoneGeneratorGUI>((Object)this){

            @NotNull
            public final CobblestoneGeneratorGUI invoke() {
                return (CobblestoneGenerator)((Object)this.receiver).new CobblestoneGeneratorGUI();
            }
        }));
        Pair[] pairArray = new DataHolder[]{UpgradeType.Companion.getSPEED(), UpgradeType.Companion.getEFFICIENCY(), UpgradeType.Companion.getENERGY(), UpgradeType.Companion.getFLUID()};
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])pairArray);
        this.inventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"inventory", (int)3, (Function1)((Function1)new Function1<ItemUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                CobblestoneGenerator.access$handleInventoryUpdate((CobblestoneGenerator)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        this.waterTank = TileEntity.getFluidContainer$default((TileEntity)((TileEntity)this), (String)"water", (Set)SetsKt.setOf((Object)FluidType.WATER), (Provider)CobblestoneGeneratorKt.access$getWATER_CAPACITY$p(), (long)0L, (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                CobblestoneGenerator.access$updateWaterLevel((CobblestoneGenerator)((Object)this.receiver));
            }
        }), (UpgradeHolder)this.getUpgradeHolder(), (boolean)false, (int)64, null);
        this.lavaTank = TileEntity.getFluidContainer$default((TileEntity)((TileEntity)this), (String)"lava", (Set)SetsKt.setOf((Object)FluidType.LAVA), (Provider)CobblestoneGeneratorKt.access$getLAVA_CAPACITY$p(), (long)0L, (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                CobblestoneGenerator.access$updateLavaLevel((CobblestoneGenerator)((Object)this.receiver));
            }
        }), (UpgradeHolder)this.getUpgradeHolder(), (boolean)false, (int)64, null);
        this.energyHolder = new ConsumerEnergyHolder((NetworkedTileEntity)this, CobblestoneGeneratorKt.access$getENERGY_CAPACITY$p(), CobblestoneGeneratorKt.access$getENERGY_PER_TICK$p(), null, this.getUpgradeHolder(), (Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ CobblestoneGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        });
        this.itemHolder = NovaItemHolderKt.NovaItemHolder$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.inventory, (Object)NetworkConnectionType.EXTRACT), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ CobblestoneGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        }), (int)8, null);
        pairArray = new Pair[]{TuplesKt.to((Object)this.lavaTank, (Object)NetworkConnectionType.BUFFER)};
        this.fluidHolder = NovaFluidHolderKt.NovaFluidHolder$default((DataHolder)((DataHolder)this), (Pair)TuplesKt.to((Object)this.waterTank, (Object)NetworkConnectionType.BUFFER), (Pair[])pairArray, null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ CobblestoneGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }), (int)8, null);
        CobblestoneGenerator cobblestoneGenerator = this;
        pairArray = (Pair[])this;
        String key$iv = "mode";
        boolean $i$f$retrieveData = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$retrieveDataOrNull = false;
        if (this_$iv$iv.getLegacyData() != null) {
            LegacyCompound legacyCompound = this_$iv$iv.getLegacyData();
            Intrinsics.checkNotNull((Object)legacyCompound);
            LegacyCompound this_$iv$iv$iv = legacyCompound;
            boolean $i$f$get = false;
            boolean $i$f$type = false;
            Type type = new TypeToken<Mode>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"object : TypeToken<T>() {}.type");
            object = this_$iv$iv$iv.get(type, key$iv);
            if (object == null) {
                this_$iv$iv$iv = this_$iv$iv.getLegacyGlobalData();
                $i$f$get = false;
                $i$f$type = false;
                Type type2 = new TypeToken<Mode>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<T>() {}.type");
                object = this_$iv$iv$iv.get(type2, key$iv);
            }
        } else {
            Compound this_$iv$iv$iv = this_$iv$iv.getData();
            boolean $i$f$get = false;
            boolean $i$f$type = false;
            Type type = new TypeToken<Mode>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"object : TypeToken<T>() {}.type");
            object = this_$iv$iv$iv.get(type, key$iv);
            if (object == null) {
                this_$iv$iv$iv = this_$iv$iv.getGlobalData();
                $i$f$get = false;
                $i$f$type = false;
                Type type3 = new TypeToken<Mode>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"object : TypeToken<T>() {}.type");
                object = this_$iv$iv$iv.get(type3, key$iv);
            }
        }
        Object object2 = object;
        if (object == null) {
            CobblestoneGenerator cobblestoneGenerator2 = cobblestoneGenerator;
            boolean bl = false;
            object2 = Mode.COBBLESTONE;
            cobblestoneGenerator = cobblestoneGenerator2;
        }
        cobblestoneGenerator.mode = (Mode)((Object)object2);
        this.currentMode = this.mode;
        this.waterLevel = new FakeArmorStand(this.getCenterLocation(), false, (Function2)waterLevel.1.INSTANCE, 2, null);
        this.lavaLevel = new FakeArmorStand(this.getCenterLocation(), false, (Function2)lavaLevel.1.INSTANCE, 2, null);
        this.particleEffect = ParticlePacketBuilderKt.particleBuilder$default((ParticleEffect)ParticleEffect.SMOKE_LARGE, null, (Function1)((Function1)new Function1<ParticlePacketBuilder, Unit>(this){
            final /* synthetic */ CobblestoneGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ParticlePacketBuilder $this$particleBuilder) {
                void $this$invoke_u24lambda_u240;
                Location location;
                Intrinsics.checkNotNullParameter((Object)$this$particleBuilder, (String)"$this$particleBuilder");
                Location location2 = location = LocationUtilsKt.advance((Location)this.this$0.getCenterLocation(), (BlockFace)this.this$0.getFace(BlockSide.FRONT), (double)0.6);
                ParticlePacketBuilder particlePacketBuilder = $this$particleBuilder;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setY($this$invoke_u24lambda_u240.getY() + 0.6);
                particlePacketBuilder.location(location);
                $this$particleBuilder.offset(BlockFaceUtilsKt.getAxis((BlockFace)this.this$0.getFace(BlockSide.RIGHT)), 0.15f);
                $this$particleBuilder.amount(5);
                $this$particleBuilder.speed(0.03f);
            }
        }), (int)2, null);
        this.reload();
        this.updateWaterLevel();
        this.updateLavaLevel();
    }

    @NotNull
    public Lazy<CobblestoneGeneratorGUI> getGui() {
        return this.gui;
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    @NotNull
    public NovaItemHolder getItemHolder() {
        return this.itemHolder;
    }

    @NotNull
    public NovaFluidHolder getFluidHolder() {
        return this.fluidHolder;
    }

    public void reload() {
        super.reload();
        this.mbPerTick = MathKt.roundToLong((double)((double)CobblestoneGeneratorKt.access$getMB_PER_TICK() * ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getSPEED())).doubleValue()));
    }

    private final void updateWaterLevel() {
        ItemStack itemStack;
        if (!this.waterTank.isEmpty()) {
            int state = this.getFluidState(this.waterTank);
            itemStack = ((ItemProvider)Blocks.INSTANCE.getCOBBLESTONE_GENERATOR_WATER_LEVELS().getClientsideProviders().get(state)).get();
        } else {
            itemStack = null;
        }
        ItemStack item = itemStack;
        this.waterLevel.setEquipment(EnumItemSlot.f, item, true);
    }

    private final void updateLavaLevel() {
        ItemStack itemStack;
        if (!this.lavaTank.isEmpty()) {
            int state = this.getFluidState(this.lavaTank);
            itemStack = ((ItemProvider)Blocks.INSTANCE.getCOBBLESTONE_GENERATOR_LAVA_LEVELS().getClientsideProviders().get(state)).get();
        } else {
            itemStack = null;
        }
        ItemStack item = itemStack;
        this.lavaLevel.setEquipment(EnumItemSlot.f, item, true);
    }

    private final int getFluidState(FluidContainer container) {
        return RangesKt.coerceIn((int)MathKt.roundToInt((double)((double)container.getAmount() / (double)container.getCapacity() * 99.0)), (ClosedRange)((ClosedRange)new IntRange(0, 99)));
    }

    public void handleTick() {
        long mbToTake = Math.min(this.mbPerTick, (long)1000 - this.mbUsed);
        if (this.waterTank.getAmount() >= mbToTake && this.lavaTank.getAmount() >= mbToTake && this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getEnergyConsumption() && this.inventory.canHold(this.currentMode.getProduct(), new ItemStack[0])) {
            ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
            consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getEnergyConsumption());
            this.mbUsed += mbToTake;
            Object object = this.currentMode.getTakeLava() ? this.lavaTank : (consumerEnergyHolder = this.currentMode.getTakeWater() ? this.waterTank : null);
            if (consumerEnergyHolder != null) {
                consumerEnergyHolder.takeFluid(mbToTake);
            }
            if (this.mbUsed >= 1000L) {
                this.mbUsed = 0L;
                this.inventory.addItem(TileEntity.Companion.getSELF_UPDATE_REASON(), this.currentMode.getProduct());
                this.currentMode = this.mode;
                this.playSoundEffect(Sound.BLOCK_LAVA_EXTINGUISH, 0.1f, (float)Random.Default.nextDouble(0.5, 1.95));
                this.particleEffect.display((Collection)this.getViewers());
            }
            if (this.getGui().isInitialized()) {
                ((CobblestoneGeneratorGUI)((Object)this.getGui().getValue())).getProgressItem().setPercentage((double)this.mbUsed / 1000.0);
            }
        }
    }

    private final void handleInventoryUpdate(ItemUpdateEvent event) {
        event.setCancelled(!event.isRemove() && !Intrinsics.areEqual((Object)event.getUpdateReason(), (Object)TileEntity.Companion.getSELF_UPDATE_REASON()));
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        this.waterLevel.remove();
        this.lavaLevel.remove();
    }

    public void saveData() {
        super.saveData();
        DataHolder.storeData$default((DataHolder)((DataHolder)this), (String)"mode", (Object)((Object)this.mode), (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ void access$handleInventoryUpdate(CobblestoneGenerator $this, ItemUpdateEvent event) {
        $this.handleInventoryUpdate(event);
    }

    public static final /* synthetic */ void access$updateWaterLevel(CobblestoneGenerator $this) {
        $this.updateWaterLevel();
    }

    public static final /* synthetic */ void access$updateLavaLevel(CobblestoneGenerator $this) {
        $this.updateLavaLevel();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/processing/CobblestoneGenerator$CobblestoneGeneratorGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity$TileEntityGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/processing/CobblestoneGenerator;)V", "gui", "Lde/studiocode/invui/gui/GUI;", "getGui", "()Lde/studiocode/invui/gui/GUI;", "progressItem", "Lxyz/xenondevs/nova/machines/gui/LeftRightFluidProgressItem;", "getProgressItem", "()Lxyz/xenondevs/nova/machines/gui/LeftRightFluidProgressItem;", "sideConfigGUI", "Lxyz/xenondevs/nova/ui/config/side/SideConfigGUI;", "ChangeModeItem", "machines"})
    public final class CobblestoneGeneratorGUI
    extends TileEntity.TileEntityGUI {
        @NotNull
        private final SideConfigGUI sideConfigGUI;
        @NotNull
        private final LeftRightFluidProgressItem progressItem;
        @NotNull
        private final GUI gui;

        public CobblestoneGeneratorGUI() {
            super((TileEntity)CobblestoneGenerator.this, null, 1, null);
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)CobblestoneGenerator.this.waterTank, (Object)"container.nova.water_tank"), TuplesKt.to((Object)CobblestoneGenerator.this.lavaTank, (Object)"container.nova.lava_tank")};
            this.sideConfigGUI = new SideConfigGUI((NetworkEndPoint)CobblestoneGenerator.this, CollectionsKt.listOf((Object)TuplesKt.to((Object)CobblestoneGenerator.this.getItemHolder().getNetworkedInventory(CobblestoneGenerator.this.inventory), (Object)"inventory.nova.output")), CollectionsKt.listOf((Object[])objectArray), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((CobblestoneGeneratorGUI)((Object)this.receiver)).openWindow(p0);
                }
            });
            this.progressItem = new LeftRightFluidProgressItem();
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| w l # i # s e |", "| w l > i # u e |", "| w l # i # m e |", "3 - - - - - - - 4"};
            GUI gUI = new GUIBuilder(GUIType.NORMAL).setStructure(stringArray).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGUI)).addIngredient('u', (Item)new OpenUpgradesItem(CobblestoneGenerator.this.getUpgradeHolder())).addIngredient('m', (Item)new ChangeModeItem()).addIngredient('i', CobblestoneGenerator.this.inventory).addIngredient('>', (Item)this.progressItem).addIngredient('w', (Supplier)new FluidBar(3, (FluidHolder)CobblestoneGenerator.this.getFluidHolder(), CobblestoneGenerator.this.waterTank)).addIngredient('l', (Supplier)new FluidBar(3, (FluidHolder)CobblestoneGenerator.this.getFluidHolder(), CobblestoneGenerator.this.lavaTank)).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)CobblestoneGenerator.this.getEnergyHolder())).build();
            Intrinsics.checkNotNullExpressionValue((Object)gUI, (String)"GUIBuilder(GUIType.NORMA\u2026er))\n            .build()");
            this.gui = gUI;
        }

        @NotNull
        public final LeftRightFluidProgressItem getProgressItem() {
            return this.progressItem;
        }

        @NotNull
        public GUI getGui() {
            return this.gui;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/processing/CobblestoneGenerator$CobblestoneGeneratorGUI$ChangeModeItem;", "Lde/studiocode/invui/item/impl/BaseItem;", "(Lxyz/xenondevs/nova/machines/tileentity/processing/CobblestoneGenerator$CobblestoneGeneratorGUI;)V", "getItemProvider", "Lde/studiocode/invui/item/ItemProvider;", "handleClick", "", "clickType", "Lorg/bukkit/event/inventory/ClickType;", "player", "Lorg/bukkit/entity/Player;", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "machines"})
        private final class ChangeModeItem
        extends BaseItem {
            @NotNull
            public ItemProvider getItemProvider() {
                return CobblestoneGenerator.this.mode.getUiItem().getClientsideProvider();
            }

            public void handleClick(@NotNull ClickType clickType, @NotNull Player player2, @NotNull InventoryClickEvent event) {
                Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
                Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (clickType == ClickType.LEFT || clickType == ClickType.RIGHT) {
                    int direction = clickType == ClickType.LEFT ? 1 : -1;
                    int n = CobblestoneGenerator.this.mode.ordinal() + direction;
                    int n2 = Mode.values().length;
                    int n3 = n % n2;
                    CobblestoneGenerator.this.mode = Mode.values()[n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31)];
                    player2.playSound(player2.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    this.notifyWindows();
                }
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/processing/CobblestoneGenerator$Mode;", "", "takeWater", "", "takeLava", "product", "Lorg/bukkit/inventory/ItemStack;", "uiItem", "Lxyz/xenondevs/nova/material/ItemNovaMaterial;", "(Ljava/lang/String;IZZLorg/bukkit/inventory/ItemStack;Lxyz/xenondevs/nova/material/ItemNovaMaterial;)V", "getProduct", "()Lorg/bukkit/inventory/ItemStack;", "getTakeLava", "()Z", "getTakeWater", "getUiItem", "()Lxyz/xenondevs/nova/material/ItemNovaMaterial;", "COBBLESTONE", "STONE", "OBSIDIAN", "machines"})
    public static final class Mode
    extends Enum<Mode> {
        private final boolean takeWater;
        private final boolean takeLava;
        @NotNull
        private final ItemStack product;
        @NotNull
        private final ItemNovaMaterial uiItem;
        public static final /* enum */ Mode COBBLESTONE = new Mode(false, false, new ItemStack(Material.COBBLESTONE), GUIMaterials.INSTANCE.getCOBBLESTONE_MODE_BTN());
        public static final /* enum */ Mode STONE = new Mode(true, false, new ItemStack(Material.STONE), GUIMaterials.INSTANCE.getSTONE_MODE_BTN());
        public static final /* enum */ Mode OBSIDIAN = new Mode(false, true, new ItemStack(Material.OBSIDIAN), GUIMaterials.INSTANCE.getOBSIDIAN_MODE_BTN());
        private static final /* synthetic */ Mode[] $VALUES;

        private Mode(boolean takeWater, boolean takeLava, ItemStack product, ItemNovaMaterial uiItem) {
            this.takeWater = takeWater;
            this.takeLava = takeLava;
            this.product = product;
            this.uiItem = uiItem;
        }

        public final boolean getTakeWater() {
            return this.takeWater;
        }

        public final boolean getTakeLava() {
            return this.takeLava;
        }

        @NotNull
        public final ItemStack getProduct() {
            return this.product;
        }

        @NotNull
        public final ItemNovaMaterial getUiItem() {
            return this.uiItem;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.COBBLESTONE, Mode.STONE, Mode.OBSIDIAN};
        }
    }
}

