/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.energy;

import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.builder.GUIBuilder;
import de.studiocode.invui.gui.builder.guitype.GUIType;
import de.studiocode.invui.item.Item;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Vector3f;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.data.resources.model.data.ArmorStandBlockModelData;
import xyz.xenondevs.nova.data.resources.model.data.BlockModelData;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.integration.protection.ProtectionManager;
import xyz.xenondevs.nova.machines.tileentity.energy.WindTurbineKt;
import xyz.xenondevs.nova.tileentity.Model;
import xyz.xenondevs.nova.tileentity.MultiModel;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ProviderEnergyHolder;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.concurrent.CombinedBooleanFuture;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeArmorStand;
import xyz.xenondevs.nova.world.fakeentity.metadata.impl.ArmorStandMetadata;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0002 !B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/WindTurbine;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "altitude", "", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "energyPerTick", "", "gui", "Lkotlin/Lazy;", "Lxyz/xenondevs/nova/machines/tileentity/energy/WindTurbine$WindTurbineGUI;", "getGui", "()Lkotlin/Lazy;", "rotationPerTick", "", "turbineModel", "Lxyz/xenondevs/nova/tileentity/MultiModel;", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "handleAsyncTick", "", "handleTick", "reload", "spawnModels", "Companion", "WindTurbineGUI", "machines"})
public final class WindTurbine
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy<WindTurbineGUI> gui;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ProviderEnergyHolder energyHolder;
    @NotNull
    private final MultiModel turbineModel;
    private final double altitude;
    private final float rotationPerTick;
    private int energyPerTick;

    public WindTurbine(@NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.gui = LazyKt.lazy((Function0)((Function0)new Function0<WindTurbineGUI>(this){
            final /* synthetic */ WindTurbine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final WindTurbineGUI invoke() {
                return this.this$0.new WindTurbineGUI();
            }
        }));
        UpgradeType[] upgradeTypeArray = new UpgradeType[]{UpgradeType.Companion.getEFFICIENCY(), UpgradeType.Companion.getENERGY()};
        this.upgradeHolder = this.getUpgradeHolder(upgradeTypeArray);
        this.energyHolder = new ProviderEnergyHolder((NetworkedTileEntity)this, WindTurbineKt.access$getMAX_ENERGY$p(), WindTurbineKt.access$getENERGY_PER_TICK$p(), this.getUpgradeHolder(), (Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ WindTurbine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT, BlockSide.BOTTOM};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        });
        this.turbineModel = this.createMultiModel();
        this.altitude = (this.getLocation().getY() + (double)Math.abs(this.getWorld().getMinHeight())) / (double)(this.getWorld().getMaxHeight() - 1 + Math.abs(this.getWorld().getMinHeight()));
        this.rotationPerTick = (float)this.altitude * (float)15;
        this.reload();
        this.spawnModels();
    }

    @NotNull
    public Lazy<WindTurbineGUI> getGui() {
        return this.gui;
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ProviderEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    public void reload() {
        super.reload();
        this.energyPerTick = (int)(this.altitude * (double)this.getEnergyHolder().getEnergyGeneration());
    }

    private final void spawnModels() {
        Location location = this.getCenterLocation().add(0.0, 2.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"centerLocation.add(0.0, 2.0, 0.0)");
        Location location2 = location;
        location2.setYaw(location2.getYaw() + (float)180);
        location2.setY(location2.getY() + 0.03125);
        Model[] modelArray = new Model[1];
        BlockModelData blockModelData = this.getMaterial().getBlock();
        Intrinsics.checkNotNull((Object)blockModelData, (String)"null cannot be cast to non-null type xyz.xenondevs.nova.data.resources.model.data.ArmorStandBlockModelData");
        ItemStack itemStack = ((ArmorStandBlockModelData)blockModelData).get(4).get();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"(material.block as Armor\u2026dBlockModelData)[4].get()");
        modelArray[0] = new Model(itemStack, location2, new Vector3f(90.0f, 0.0f, 0.0f));
        this.turbineModel.addModels(modelArray);
        for (int blade = 0; blade < 3; ++blade) {
            Model[] modelArray2 = new Model[1];
            BlockModelData blockModelData2 = this.getMaterial().getBlock();
            Intrinsics.checkNotNull((Object)blockModelData2, (String)"null cannot be cast to non-null type xyz.xenondevs.nova.data.resources.model.data.ArmorStandBlockModelData");
            ItemStack itemStack2 = ((ArmorStandBlockModelData)blockModelData2).get(5).get();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"(material.block as Armor\u2026dBlockModelData)[5].get()");
            modelArray2[0] = new Model(itemStack2, location2, new Vector3f(90.0f, 0.0f, (float)blade * 120.0f));
            this.turbineModel.addModels(modelArray2);
        }
    }

    public void handleTick() {
        ProviderEnergyHolder providerEnergyHolder = this.getEnergyHolder();
        providerEnergyHolder.setEnergy(providerEnergyHolder.getEnergy() + (long)this.energyPerTick);
    }

    public void handleAsyncTick() {
        if (WindTurbineKt.access$getPLAY_ANIMATION()) {
            this.turbineModel.useArmorStands((Function1)new Function1<FakeArmorStand, Unit>(this){
                final /* synthetic */ WindTurbine this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull FakeArmorStand it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.updateEntityData(true, (Function1)new Function1<ArmorStandMetadata, Unit>(this.this$0){
                        final /* synthetic */ WindTurbine this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull ArmorStandMetadata $this$updateEntityData) {
                            Intrinsics.checkNotNullParameter((Object)$this$updateEntityData, (String)"$this$updateEntityData");
                            Vector3f vector3f = $this$updateEntityData.getHeadRotation();
                            Intrinsics.checkNotNull((Object)vector3f);
                            $this$updateEntityData.setHeadRotation(NMSUtilsKt.add((Vector3f)vector3f, (float)0.0f, (float)0.0f, (float)WindTurbine.access$getRotationPerTick$p(this.this$0)));
                        }
                    });
                }
            });
        }
    }

    public static final /* synthetic */ float access$getRotationPerTick$p(WindTurbine $this) {
        return $this.rotationPerTick;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/WindTurbine$Companion;", "", "()V", "canPlace", "Ljava/util/concurrent/CompletableFuture;", "", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/bukkit/inventory/ItemStack;", "location", "Lorg/bukkit/Location;", "loadMultiBlock", "", "Lxyz/xenondevs/nova/world/BlockPos;", "pos", "machines"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CompletableFuture<Boolean> canPlace(@NotNull Player player2, @NotNull ItemStack item, @NotNull Location location) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Iterable $this$map$iv = this.loadMultiBlock(BlockPosKt.getPos((Location)location));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BlockPos blockPos = (BlockPos)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Material material = it.getBlock().getType();
                Intrinsics.checkNotNullExpressionValue((Object)material, (String)"it.block.type");
                if (!MaterialUtilsKt.isReplaceable((Material)material)) {
                    CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(false)");
                    return completableFuture;
                }
                collection.add(ProtectionManager.INSTANCE.canPlace((OfflinePlayer)player2, item, it.getLocation()));
            }
            List list = (List)destination$iv$iv;
            return (CompletableFuture)new CombinedBooleanFuture(list);
        }

        @NotNull
        public final List<BlockPos> loadMultiBlock(@NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Object[] objectArray = new BlockPos[]{BlockPos.copy$default((BlockPos)pos, null, (int)0, (int)(pos.getY() + 1), (int)0, (int)11, null), BlockPos.copy$default((BlockPos)pos, null, (int)0, (int)(pos.getY() + 2), (int)0, (int)11, null), BlockPos.copy$default((BlockPos)pos, null, (int)0, (int)(pos.getY() + 3), (int)0, (int)11, null)};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/WindTurbine$WindTurbineGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity$TileEntityGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/energy/WindTurbine;)V", "gui", "Lde/studiocode/invui/gui/GUI;", "getGui", "()Lde/studiocode/invui/gui/GUI;", "machines"})
    public final class WindTurbineGUI
    extends TileEntity.TileEntityGUI {
        @NotNull
        private final GUI gui;

        public WindTurbineGUI() {
            super((TileEntity)WindTurbine.this, null, 1, null);
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| u # # e # # # |", "| # # # e # # # |", "| # # # e # # # |", "3 - - - - - - - 4"};
            GUI gUI = new GUIBuilder(GUIType.NORMAL).setStructure(stringArray).addIngredient('u', (Item)new OpenUpgradesItem(WindTurbine.this.getUpgradeHolder())).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)WindTurbine.this.getEnergyHolder())).build();
            Intrinsics.checkNotNullExpressionValue((Object)gUI, (String)"GUIBuilder(GUIType.NORMA\u2026er))\n            .build()");
            this.gui = gUI;
        }

        @NotNull
        public GUI getGui() {
            return this.gui;
        }
    }
}

