/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.energy;

import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.builder.GUIBuilder;
import de.studiocode.invui.gui.builder.guitype.GUIType;
import de.studiocode.invui.item.Item;
import java.util.EnumMap;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.machines.tileentity.energy.SolarPanelKt;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ProviderEnergyHolder;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.SchedulerUtilsKt;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\f\u0012\b\u0012\u00060\fR\u00020\u00000\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/SolarPanel;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "gui", "Lkotlin/Lazy;", "Lxyz/xenondevs/nova/machines/tileentity/energy/SolarPanel$SolarPanelGUI;", "getGui", "()Lkotlin/Lazy;", "obstructed", "", "obstructionTask", "Lorg/bukkit/scheduler/BukkitTask;", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "calculateCurrentEnergyOutput", "", "checkSkyObstruction", "", "handleRemoved", "unload", "handleTick", "SolarPanelGUI", "machines"})
public final class SolarPanel
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final Lazy<SolarPanelGUI> gui;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ProviderEnergyHolder energyHolder;
    @NotNull
    private final BukkitTask obstructionTask;
    private boolean obstructed;

    public SolarPanel(@NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.gui = LazyKt.lazy((Function0)((Function0)new Function0<SolarPanelGUI>(this){
            final /* synthetic */ SolarPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SolarPanelGUI invoke() {
                return this.this$0.new SolarPanelGUI();
            }
        }));
        UpgradeType[] upgradeTypeArray = new UpgradeType[]{UpgradeType.Companion.getEFFICIENCY(), UpgradeType.Companion.getENERGY()};
        this.upgradeHolder = this.getUpgradeHolder(upgradeTypeArray);
        this.energyHolder = new ProviderEnergyHolder((NetworkedTileEntity)this, SolarPanelKt.access$getMAX_ENERGY$p(), SolarPanelKt.access$getENERGY_PER_TICK$p(), this.getUpgradeHolder(), (Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ SolarPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.BOTTOM};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        });
        this.obstructionTask = SchedulerUtilsKt.runTaskTimer((long)0L, (long)100L, (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                SolarPanel.access$checkSkyObstruction((SolarPanel)((Object)this.receiver));
            }
        }));
        this.obstructed = true;
    }

    @NotNull
    public Lazy<SolarPanelGUI> getGui() {
        return this.gui;
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ProviderEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    private final void checkSkyObstruction() {
        this.obstructed = false;
        LocationUtilsKt.untilHeightLimit((Location)this.getLocation(), (boolean)false, (Function1)((Function1)new Function1<Location, Boolean>(this){
            final /* synthetic */ SolarPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Location it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Material material = it.getBlock().getType();
                Intrinsics.checkNotNullExpressionValue((Object)material, (String)"it.block.type");
                Material material2 = material;
                if (material2 != Material.AIR && !MaterialUtilsKt.isGlass((Material)material2)) {
                    SolarPanel.access$setObstructed$p(this.this$0, true);
                    return false;
                }
                return true;
            }
        }));
    }

    public void handleTick() {
        ProviderEnergyHolder providerEnergyHolder = this.getEnergyHolder();
        providerEnergyHolder.setEnergy(providerEnergyHolder.getEnergy() + (long)this.calculateCurrentEnergyOutput());
    }

    private final int calculateCurrentEnergyOutput() {
        World world = this.getLocation().getWorld();
        Intrinsics.checkNotNull((Object)world);
        long time = world.getTime();
        if (!this.obstructed && time < 13000L) {
            int bestTime = 6500;
            double multiplier = (double)((long)bestTime - Math.abs((long)bestTime - time)) / (double)bestTime;
            return MathKt.roundToInt((double)((double)this.getEnergyHolder().getEnergyGeneration() * multiplier));
        }
        return 0;
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        this.obstructionTask.cancel();
    }

    public static final /* synthetic */ void access$setObstructed$p(SolarPanel $this, boolean bl) {
        $this.obstructed = bl;
    }

    public static final /* synthetic */ void access$checkSkyObstruction(SolarPanel $this) {
        $this.checkSkyObstruction();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/SolarPanel$SolarPanelGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity$TileEntityGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/energy/SolarPanel;)V", "gui", "Lde/studiocode/invui/gui/GUI;", "getGui", "()Lde/studiocode/invui/gui/GUI;", "machines"})
    public final class SolarPanelGUI
    extends TileEntity.TileEntityGUI {
        @NotNull
        private final GUI gui;

        public SolarPanelGUI() {
            super((TileEntity)SolarPanel.this, null, 1, null);
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| u # # e # # # |", "| # # # e # # # |", "| # # # e # # # |", "3 - - - - - - - 4"};
            GUI gUI = new GUIBuilder(GUIType.NORMAL).setStructure(stringArray).addIngredient('u', (Item)new OpenUpgradesItem(SolarPanel.this.getUpgradeHolder())).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)SolarPanel.this.getEnergyHolder())).build();
            Intrinsics.checkNotNullExpressionValue((Object)gUI, (String)"GUIBuilder(GUIType.NORMA\u2026er))\n            .build()");
            this.gui = gUI;
        }

        @NotNull
        public GUI getGui() {
            return this.gui;
        }
    }
}

