/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.energy;

import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.builder.GUIBuilder;
import de.studiocode.invui.gui.builder.guitype.GUIType;
import de.studiocode.invui.item.Item;
import java.util.EnumMap;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.data.provider.Provider;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.machines.tileentity.energy.LavaGeneratorKt;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.TileEntityParticleTask;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ProviderEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.FluidType;
import xyz.xenondevs.nova.tileentity.network.fluid.container.FluidContainer;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.FluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.FluidBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigGUI;
import xyz.xenondevs.nova.util.BlockFaceUtilsKt;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.MathUtilsKt;
import xyz.xenondevs.nova.util.ParticlePacketBuilder;
import xyz.xenondevs.nova.util.ParticlePacketBuilderKt;
import xyz.xenondevs.particle.ParticleEffect;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001'B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020$H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0017R\u00020\u00000\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006("}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/LavaGenerator;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "burnProgress", "", "burnRate", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "energyPerTick", "", "fluidContainer", "Lxyz/xenondevs/nova/tileentity/network/fluid/container/FluidContainer;", "fluidHolder", "Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "getFluidHolder", "()Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "gui", "Lkotlin/Lazy;", "Lxyz/xenondevs/nova/machines/tileentity/energy/LavaGenerator$LavaGeneratorGUI;", "getGui", "()Lkotlin/Lazy;", "lavaParticleTask", "Lxyz/xenondevs/nova/tileentity/TileEntityParticleTask;", "on", "", "smokeParticleTask", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "handleTick", "", "reload", "updateModelState", "LavaGeneratorGUI", "machines"})
public final class LavaGenerator
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final Lazy<LavaGeneratorGUI> gui;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final FluidContainer fluidContainer;
    @NotNull
    private final NovaFluidHolder fluidHolder;
    @NotNull
    private final ProviderEnergyHolder energyHolder;
    private boolean on;
    private double burnRate;
    private double burnProgress;
    private long energyPerTick;
    @NotNull
    private final TileEntityParticleTask smokeParticleTask;
    @NotNull
    private final TileEntityParticleTask lavaParticleTask;

    public LavaGenerator(@NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.gui = LazyKt.lazy((Function0)((Function0)new Function0<LavaGeneratorGUI>((Object)this){

            @NotNull
            public final LavaGeneratorGUI invoke() {
                return (LavaGenerator)((Object)this.receiver).new LavaGeneratorGUI();
            }
        }));
        Object[] objectArray = new UpgradeType[]{UpgradeType.Companion.getSPEED(), UpgradeType.Companion.getEFFICIENCY(), UpgradeType.Companion.getENERGY(), UpgradeType.Companion.getFLUID()};
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])objectArray);
        objectArray = new FluidType[]{FluidType.LAVA};
        this.fluidContainer = TileEntity.getFluidContainer$default((TileEntity)((TileEntity)this), (String)"tank", (Set)SetsKt.hashSetOf((Object[])objectArray), (Provider)LavaGeneratorKt.access$getFLUID_CAPACITY$p(), (long)0L, null, (UpgradeHolder)this.getUpgradeHolder(), (boolean)false, (int)88, null);
        this.fluidHolder = NovaFluidHolderKt.NovaFluidHolder$default((DataHolder)((DataHolder)this), (Pair)TuplesKt.to((Object)this.fluidContainer, (Object)NetworkConnectionType.BUFFER), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ LavaGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }), (int)8, null);
        this.energyHolder = new ProviderEnergyHolder((NetworkedTileEntity)this, LavaGeneratorKt.access$getENERGY_CAPACITY$p(), null, this.getUpgradeHolder(), (Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ LavaGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        });
        this.smokeParticleTask = this.createParticleTask(CollectionsKt.listOf((Object)ParticlePacketBuilderKt.particle((ParticleEffect)ParticleEffect.SMOKE_NORMAL, (Function1)((Function1)new Function1<ParticlePacketBuilder, Unit>(this){
            final /* synthetic */ LavaGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ParticlePacketBuilder $this$particle) {
                void $this$invoke_u24lambda_u240;
                Location location;
                Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
                Location location2 = location = LocationUtilsKt.advance((Location)this.this$0.getCenterLocation(), (BlockFace)this.this$0.getFace(BlockSide.FRONT), (double)0.6);
                ParticlePacketBuilder particlePacketBuilder = $this$particle;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setY($this$invoke_u24lambda_u240.getY() + 0.6);
                particlePacketBuilder.location(location);
                $this$particle.offset(BlockFaceUtilsKt.getAxis((BlockFace)this.this$0.getFace(BlockSide.RIGHT)), 0.15f);
                $this$particle.offsetY(0.1f);
                $this$particle.speed(0.0f);
                $this$particle.amount(1);
            }
        }))), 3);
        this.lavaParticleTask = this.createParticleTask(CollectionsKt.listOf((Object)ParticlePacketBuilderKt.particle((ParticleEffect)ParticleEffect.LAVA, (Function1)((Function1)new Function1<ParticlePacketBuilder, Unit>(this){
            final /* synthetic */ LavaGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ParticlePacketBuilder $this$particle) {
                void $this$invoke_u24lambda_u240;
                Location location;
                Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
                Location location2 = location = LocationUtilsKt.advance((Location)this.this$0.getCenterLocation(), (BlockFace)this.this$0.getFace(BlockSide.FRONT), (double)0.6);
                ParticlePacketBuilder particlePacketBuilder = $this$particle;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setY($this$invoke_u24lambda_u240.getY() + 0.6);
                particlePacketBuilder.location(location);
                $this$particle.offset(BlockFaceUtilsKt.getAxis((BlockFace)this.this$0.getFace(BlockSide.RIGHT)), 0.15f);
                $this$particle.offsetY(0.1f);
            }
        }))), 200);
        this.reload();
    }

    @NotNull
    public Lazy<LavaGeneratorGUI> getGui() {
        return this.gui;
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public NovaFluidHolder getFluidHolder() {
        return this.fluidHolder;
    }

    @NotNull
    public ProviderEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    public void reload() {
        super.reload();
        this.burnRate = LavaGeneratorKt.access$getBURN_RATE() * ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getSPEED())).doubleValue() / ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getEFFICIENCY())).doubleValue();
        this.energyPerTick = (long)(LavaGeneratorKt.access$getENERGY_PER_MB() * LavaGeneratorKt.access$getBURN_RATE() * ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getSPEED())).doubleValue());
    }

    private final void updateModelState() {
        this.getBlockState().getModelProvider().update(MathUtilsKt.getIntValue((boolean)this.on));
    }

    public void handleTick() {
        long lavaAmount;
        if (this.getEnergyHolder().getEnergy() == this.getEnergyHolder().getMaxEnergy() || this.fluidContainer.isEmpty()) {
            if (this.on) {
                this.on = false;
                this.updateModelState();
                this.smokeParticleTask.stop();
                this.lavaParticleTask.stop();
            }
            return;
        }
        if (!this.on) {
            this.on = true;
            this.updateModelState();
            this.smokeParticleTask.start();
            this.lavaParticleTask.start();
        }
        if ((double)(lavaAmount = this.fluidContainer.getAmount()) >= this.burnRate) {
            ProviderEnergyHolder providerEnergyHolder = this.getEnergyHolder();
            providerEnergyHolder.setEnergy(providerEnergyHolder.getEnergy() + this.energyPerTick);
            this.burnProgress += this.burnRate;
            if (this.burnProgress > 1.0) {
                long burnt = (long)this.burnProgress;
                this.burnProgress -= (double)burnt;
                this.fluidContainer.takeFluid(burnt);
            }
        } else {
            ProviderEnergyHolder providerEnergyHolder = this.getEnergyHolder();
            providerEnergyHolder.setEnergy(providerEnergyHolder.getEnergy() + (long)((double)lavaAmount * LavaGeneratorKt.access$getENERGY_PER_MB()));
            this.fluidContainer.clear();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/LavaGenerator$LavaGeneratorGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity$TileEntityGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/energy/LavaGenerator;)V", "gui", "Lde/studiocode/invui/gui/GUI;", "getGui", "()Lde/studiocode/invui/gui/GUI;", "sideConfigGUI", "Lxyz/xenondevs/nova/ui/config/side/SideConfigGUI;", "machines"})
    public final class LavaGeneratorGUI
    extends TileEntity.TileEntityGUI {
        @NotNull
        private final SideConfigGUI sideConfigGUI;
        @NotNull
        private final GUI gui;

        public LavaGeneratorGUI() {
            super((TileEntity)LavaGenerator.this, null, 1, null);
            this.sideConfigGUI = new SideConfigGUI((NetworkEndPoint)LavaGenerator.this, null, CollectionsKt.listOf((Object)TuplesKt.to((Object)LavaGenerator.this.fluidContainer, (Object)"container.nova.lava_tank")), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((LavaGeneratorGUI)((Object)this.receiver)).openWindow(p0);
                }
            }, 2, null);
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s # # # # f e |", "| u # # # # f e |", "| # # # # # f e |", "3 - - - - - - - 4"};
            GUI gUI = new GUIBuilder(GUIType.NORMAL).setStructure(stringArray).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGUI)).addIngredient('u', (Item)new OpenUpgradesItem(LavaGenerator.this.getUpgradeHolder())).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)LavaGenerator.this.getEnergyHolder())).addIngredient('f', (Supplier)new FluidBar(3, (FluidHolder)LavaGenerator.this.getFluidHolder(), LavaGenerator.this.fluidContainer)).build();
            Intrinsics.checkNotNullExpressionValue((Object)gUI, (String)"GUIBuilder(GUIType.NORMA\u2026er))\n            .build()");
            this.gui = gUI;
        }

        @NotNull
        public GUI getGui() {
            return this.gui;
        }
    }
}

