/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.energy;

import com.google.gson.reflect.TypeToken;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.builder.GUIBuilder;
import de.studiocode.invui.gui.builder.guitype.GUIType;
import de.studiocode.invui.item.Item;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import de.studiocode.invui.virtualinventory.event.ItemUpdateEvent;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.data.world.legacy.impl.v0_10.cbf.LegacyCompound;
import xyz.xenondevs.nova.machines.gui.EnergyProgressItem;
import xyz.xenondevs.nova.machines.tileentity.energy.FurnaceGeneratorKt;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.TileEntityParticleTask;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ProviderEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigGUI;
import xyz.xenondevs.nova.util.BlockFaceUtilsKt;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.MathUtilsKt;
import xyz.xenondevs.nova.util.ParticlePacketBuilder;
import xyz.xenondevs.nova.util.ParticlePacketBuilderKt;
import xyz.xenondevs.nova.util.item.Fuel;
import xyz.xenondevs.nova.util.item.FuelUtilsKt;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.particle.ParticleEffect;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001,B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020%H\u0016J\b\u0010*\u001a\u00020%H\u0016J\b\u0010+\u001a\u00020%H\u0016R\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006-"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/FurnaceGenerator;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "active", "", "setActive", "(Z)V", "burnTime", "", "burnTimeMultiplier", "", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ProviderEnergyHolder;", "gui", "Lkotlin/Lazy;", "Lxyz/xenondevs/nova/machines/tileentity/energy/FurnaceGenerator$FurnaceGeneratorGUI;", "getGui", "()Lkotlin/Lazy;", "inventory", "Lde/studiocode/invui/virtualinventory/VirtualInventory;", "itemHolder", "Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "getItemHolder", "()Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "particleTask", "Lxyz/xenondevs/nova/tileentity/TileEntityParticleTask;", "totalBurnTime", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "burnItem", "", "handleInventoryUpdate", "event", "Lde/studiocode/invui/virtualinventory/event/ItemUpdateEvent;", "handleTick", "reload", "saveData", "FurnaceGeneratorGUI", "machines"})
public final class FurnaceGenerator
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final Lazy<FurnaceGeneratorGUI> gui;
    @NotNull
    private final VirtualInventory inventory;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ProviderEnergyHolder energyHolder;
    @NotNull
    private final NovaItemHolder itemHolder;
    private double burnTimeMultiplier;
    private int burnTime;
    private int totalBurnTime;
    private boolean active;
    @NotNull
    private final TileEntityParticleTask particleTask;

    public FurnaceGenerator(@NotNull NovaTileEntityState blockState) {
        Object object;
        FurnaceGenerator furnaceGenerator;
        Object object2;
        boolean $i$f$type;
        boolean $i$f$get;
        Compound this_$iv$iv$iv;
        DataHolder this_$iv;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.gui = LazyKt.lazy((Function0)((Function0)new Function0<FurnaceGeneratorGUI>(this){
            final /* synthetic */ FurnaceGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FurnaceGeneratorGUI invoke() {
                return this.this$0.new FurnaceGeneratorGUI();
            }
        }));
        this.inventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"fuel", (int)1, (Function1)((Function1)new Function1<ItemUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                FurnaceGenerator.access$handleInventoryUpdate((FurnaceGenerator)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        DataHolder dataHolder = new DataHolder[]{UpgradeType.Companion.getSPEED(), UpgradeType.Companion.getEFFICIENCY(), UpgradeType.Companion.getENERGY()};
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])dataHolder);
        this.energyHolder = new ProviderEnergyHolder((NetworkedTileEntity)this, FurnaceGeneratorKt.access$getMAX_ENERGY$p(), FurnaceGeneratorKt.access$getENERGY_PER_TICK$p(), this.getUpgradeHolder(), (Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ FurnaceGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        });
        this.itemHolder = NovaItemHolderKt.NovaItemHolder$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.inventory, (Object)NetworkConnectionType.BUFFER), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ FurnaceGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.FRONT};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        }), (int)8, null);
        this.burnTimeMultiplier = FurnaceGeneratorKt.access$getBURN_TIME_MULTIPLIER();
        FurnaceGenerator furnaceGenerator2 = this;
        dataHolder = (DataHolder)this;
        String key$iv = "burnTime";
        boolean $i$f$retrieveData = false;
        DataHolder this_$iv$iv = this_$iv;
        boolean $i$f$retrieveDataOrNull = false;
        if (this_$iv$iv.getLegacyData() != null) {
            LegacyCompound legacyCompound = this_$iv$iv.getLegacyData();
            Intrinsics.checkNotNull((Object)legacyCompound);
            this_$iv$iv$iv = legacyCompound;
            $i$f$get = false;
            $i$f$type = false;
            Type type = new TypeToken<Integer>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"object : TypeToken<T>() {}.type");
            object2 = this_$iv$iv$iv.get(type, key$iv);
            if (object2 == null) {
                this_$iv$iv$iv = this_$iv$iv.getLegacyGlobalData();
                $i$f$get = false;
                $i$f$type = false;
                Type type2 = new TypeToken<Integer>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<T>() {}.type");
                object2 = this_$iv$iv$iv.get(type2, key$iv);
            }
        } else {
            this_$iv$iv$iv = this_$iv$iv.getData();
            $i$f$get = false;
            $i$f$type = false;
            Type type = new TypeToken<Integer>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"object : TypeToken<T>() {}.type");
            object2 = this_$iv$iv$iv.get(type, key$iv);
            if (object2 == null) {
                this_$iv$iv$iv = this_$iv$iv.getGlobalData();
                $i$f$get = false;
                $i$f$type = false;
                Type type3 = new TypeToken<Integer>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"object : TypeToken<T>() {}.type");
                object2 = this_$iv$iv$iv.get(type3, key$iv);
            }
        }
        Object object3 = object2;
        if (object2 == null) {
            furnaceGenerator = furnaceGenerator2;
            boolean bl = false;
            object3 = 0;
            furnaceGenerator2 = furnaceGenerator;
        }
        furnaceGenerator2.burnTime = ((Number)object3).intValue();
        FurnaceGenerator furnaceGenerator3 = this;
        this_$iv = (DataHolder)this;
        key$iv = "totalBurnTime";
        $i$f$retrieveData = false;
        this_$iv$iv = this_$iv;
        $i$f$retrieveDataOrNull = false;
        if (this_$iv$iv.getLegacyData() != null) {
            LegacyCompound legacyCompound = this_$iv$iv.getLegacyData();
            Intrinsics.checkNotNull((Object)legacyCompound);
            this_$iv$iv$iv = legacyCompound;
            $i$f$get = false;
            $i$f$type = false;
            Type type = new TypeToken<Integer>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"object : TypeToken<T>() {}.type");
            object = this_$iv$iv$iv.get(type, key$iv);
            if (object == null) {
                this_$iv$iv$iv = this_$iv$iv.getLegacyGlobalData();
                $i$f$get = false;
                $i$f$type = false;
                Type type4 = new TypeToken<Integer>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"object : TypeToken<T>() {}.type");
                object = this_$iv$iv$iv.get(type4, key$iv);
            }
        } else {
            this_$iv$iv$iv = this_$iv$iv.getData();
            $i$f$get = false;
            $i$f$type = false;
            Type type = new TypeToken<Integer>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"object : TypeToken<T>() {}.type");
            object = this_$iv$iv$iv.get(type, key$iv);
            if (object == null) {
                this_$iv$iv$iv = this_$iv$iv.getGlobalData();
                $i$f$get = false;
                $i$f$type = false;
                Type type5 = new TypeToken<Integer>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"object : TypeToken<T>() {}.type");
                object = this_$iv$iv$iv.get(type5, key$iv);
            }
        }
        Object object4 = object;
        if (object == null) {
            furnaceGenerator = furnaceGenerator3;
            boolean bl = false;
            object4 = 0;
            furnaceGenerator3 = furnaceGenerator;
        }
        furnaceGenerator3.totalBurnTime = ((Number)object4).intValue();
        this.active = this.burnTime != 0;
        this.particleTask = this.createParticleTask(CollectionsKt.listOf((Object)ParticlePacketBuilderKt.particle((ParticleEffect)ParticleEffect.SMOKE_NORMAL, (Function1)((Function1)new Function1<ParticlePacketBuilder, Unit>(this){
            final /* synthetic */ FurnaceGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ParticlePacketBuilder $this$particle) {
                void $this$invoke_u24lambda_u240;
                Location location;
                Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
                Location location2 = location = LocationUtilsKt.advance((Location)this.this$0.getCenterLocation(), (BlockFace)this.this$0.getFace(BlockSide.FRONT), (double)0.6);
                ParticlePacketBuilder particlePacketBuilder = $this$particle;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setY($this$invoke_u24lambda_u240.getY() + 0.8);
                particlePacketBuilder.location(location);
                $this$particle.offset(BlockFaceUtilsKt.getAxis((BlockFace)this.this$0.getFace(BlockSide.RIGHT)), 0.15f);
                $this$particle.offsetY(0.1f);
                $this$particle.speed(0.0f);
                $this$particle.amount(5);
            }
        }))), 1);
        if (this.active) {
            this.particleTask.start();
        }
        this.reload();
    }

    @NotNull
    public Lazy<FurnaceGeneratorGUI> getGui() {
        return this.gui;
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ProviderEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    @NotNull
    public NovaItemHolder getItemHolder() {
        return this.itemHolder;
    }

    private final void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            if (active) {
                this.particleTask.start();
            } else {
                this.particleTask.stop();
            }
            this.getBlockState().getModelProvider().update(MathUtilsKt.getIntValue((boolean)active));
        }
    }

    public void reload() {
        super.reload();
        double burnPercentage = (double)this.burnTime / (double)this.totalBurnTime;
        double previousBurnTime = (double)this.totalBurnTime / this.burnTimeMultiplier;
        this.burnTimeMultiplier = FurnaceGeneratorKt.access$getBURN_TIME_MULTIPLIER() / ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getSPEED())).doubleValue() * ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getEFFICIENCY())).doubleValue();
        this.totalBurnTime = (int)(previousBurnTime * this.burnTimeMultiplier);
        this.burnTime = (int)((double)this.totalBurnTime * burnPercentage);
    }

    public void handleTick() {
        if (this.burnTime == 0) {
            this.burnItem();
        }
        if (this.burnTime != 0) {
            int n = this.burnTime;
            this.burnTime = n + -1;
            this.getEnergyHolder().setEnergy(Math.min(this.getEnergyHolder().getMaxEnergy(), this.getEnergyHolder().getEnergy() + this.getEnergyHolder().getEnergyGeneration()));
            if (this.getGui().isInitialized()) {
                ((FurnaceGeneratorGUI)((Object)this.getGui().getValue())).getProgressItem().setPercentage((double)this.burnTime / (double)this.totalBurnTime);
            }
            if (!this.active) {
                this.setActive(true);
            }
        } else if (this.active) {
            this.setActive(false);
        }
    }

    private final void burnItem() {
        ItemStack fuelStack = this.inventory.getItemStack(0);
        if (this.getEnergyHolder().getEnergy() < this.getEnergyHolder().getMaxEnergy() && fuelStack != null) {
            Material material = fuelStack.getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"fuelStack.type");
            Fuel fuel = FuelUtilsKt.getFuel((Material)material);
            if (fuel != null) {
                this.burnTime += MathKt.roundToInt((double)((double)fuel.getBurnTime() * this.burnTimeMultiplier));
                this.totalBurnTime = this.burnTime;
                if (fuel.getRemains() == null) {
                    this.inventory.addItemAmount(null, 0, -1);
                } else {
                    Material material2 = fuel.getRemains();
                    Intrinsics.checkNotNull((Object)material2);
                    this.inventory.setItemStack(null, 0, MaterialUtilsKt.toItemStack$default((Material)material2, (int)0, (int)1, null));
                }
            }
        }
    }

    private final void handleInventoryUpdate(ItemUpdateEvent event) {
        if (event.getUpdateReason() != null && event.getNewItemStack() != null) {
            Material material = event.getNewItemStack().getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"event.newItemStack.type");
            if (FuelUtilsKt.getFuel((Material)material) == null) {
                event.setCancelled(true);
            }
        }
    }

    public void saveData() {
        super.saveData();
        DataHolder.storeData$default((DataHolder)((DataHolder)this), (String)"burnTime", (Object)this.burnTime, (boolean)false, (int)4, null);
        DataHolder.storeData$default((DataHolder)((DataHolder)this), (String)"totalBurnTime", (Object)this.totalBurnTime, (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ void access$handleInventoryUpdate(FurnaceGenerator $this, ItemUpdateEvent event) {
        $this.handleInventoryUpdate(event);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/energy/FurnaceGenerator$FurnaceGeneratorGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity$TileEntityGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/energy/FurnaceGenerator;)V", "gui", "Lde/studiocode/invui/gui/GUI;", "getGui", "()Lde/studiocode/invui/gui/GUI;", "progressItem", "Lxyz/xenondevs/nova/machines/gui/EnergyProgressItem;", "getProgressItem", "()Lxyz/xenondevs/nova/machines/gui/EnergyProgressItem;", "sideConfigGUI", "Lxyz/xenondevs/nova/ui/config/side/SideConfigGUI;", "machines"})
    public final class FurnaceGeneratorGUI
    extends TileEntity.TileEntityGUI {
        @NotNull
        private final EnergyProgressItem progressItem;
        @NotNull
        private final SideConfigGUI sideConfigGUI;
        @NotNull
        private final GUI gui;

        public FurnaceGeneratorGUI() {
            super((TileEntity)FurnaceGenerator.this, null, 1, null);
            this.progressItem = new EnergyProgressItem();
            this.sideConfigGUI = new SideConfigGUI((NetworkEndPoint)FurnaceGenerator.this, CollectionsKt.listOf((Object)TuplesKt.to((Object)FurnaceGenerator.this.getItemHolder().getNetworkedInventory(FurnaceGenerator.this.inventory), (Object)"inventory.machines.fuel")), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((FurnaceGeneratorGUI)((Object)this.receiver)).openWindow(p0);
                }
            });
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s # # # # # e |", "| u # # i # # e |", "| # # # ! # # e |", "| # # # # # # e |", "3 - - - - - - - 4"};
            GUI gUI = new GUIBuilder(GUIType.NORMAL).setStructure(stringArray).addIngredient('i', (SlotElement)new SlotElement.VISlotElement(FurnaceGenerator.this.inventory, 0)).addIngredient('!', (Item)this.progressItem).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGUI)).addIngredient('u', (Item)new OpenUpgradesItem(FurnaceGenerator.this.getUpgradeHolder())).addIngredient('e', (Supplier)new EnergyBar(4, (NovaEnergyHolder)FurnaceGenerator.this.getEnergyHolder())).build();
            Intrinsics.checkNotNullExpressionValue((Object)gUI, (String)"GUIBuilder(GUIType.NORMA\u2026er))\n            .build()");
            this.gui = gUI;
        }

        @NotNull
        public final EnergyProgressItem getProgressItem() {
            return this.progressItem;
        }

        @NotNull
        public GUI getGui() {
            return this.gui;
        }
    }
}

