/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.agriculture;

import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.builder.GUIBuilder;
import de.studiocode.invui.gui.builder.guitype.GUIType;
import de.studiocode.invui.item.Item;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import de.studiocode.invui.virtualinventory.event.ItemUpdateEvent;
import java.util.Collection;
import java.util.EnumMap;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.world.entity.EnumItemSlot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.data.config.GlobalValues;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.machines.registry.GUIMaterials;
import xyz.xenondevs.nova.machines.tileentity.agriculture.PlantConfiguration;
import xyz.xenondevs.nova.machines.tileentity.agriculture.TreeFactoryKt;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigGUI;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.ParticlePacketBuilder;
import xyz.xenondevs.nova.util.ParticlePacketBuilderKt;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeArmorStand;
import xyz.xenondevs.particle.ParticleEffect;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u00010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020&H\u0016J\b\u0010.\u001a\u00020&H\u0016J\b\u0010/\u001a\u00020&H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u000f0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00061"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/agriculture/TreeFactory;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "growthProgress", "", "gui", "Lkotlin/Lazy;", "Lxyz/xenondevs/nova/tileentity/TileEntity$TileEntityGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "getGui", "()Lkotlin/Lazy;", "idleTimeLeft", "", "inputInventory", "Lde/studiocode/invui/virtualinventory/VirtualInventory;", "itemHolder", "Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "getItemHolder", "()Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "maxIdleTime", "outputInventory", "plant", "Lxyz/xenondevs/nova/world/fakeentity/impl/FakeArmorStand;", "plantType", "Lorg/bukkit/Material;", "progressPerTick", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "handleInputInventoryUpdate", "", "event", "Lde/studiocode/invui/virtualinventory/event/ItemUpdateEvent;", "handleOutputInventoryUpdate", "handleRemoved", "unload", "", "handleTick", "reload", "updatePlantArmorStand", "TreeFactoryGUI", "machines"})
public final class TreeFactory
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final VirtualInventory inputInventory;
    @NotNull
    private final VirtualInventory outputInventory;
    @NotNull
    private final Lazy<TileEntity.TileEntityGUI> gui;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    @NotNull
    private final NovaItemHolder itemHolder;
    @Nullable
    private Material plantType;
    @NotNull
    private final FakeArmorStand plant;
    private double progressPerTick;
    private int maxIdleTime;
    private double growthProgress;
    private int idleTimeLeft;

    public TreeFactory(@NotNull NovaTileEntityState blockState) {
        Location location;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        Object[] objectArray = new int[]{1};
        this.inputInventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"input", (int)1, (int[])objectArray, (boolean)false, (Function1)((Function1)new Function1<ItemUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                TreeFactory.access$handleInputInventoryUpdate((TreeFactory)((Object)this.receiver), p0);
            }
        }), null, (int)32, null);
        this.outputInventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"output", (int)9, (Function1)((Function1)new Function1<ItemUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                TreeFactory.access$handleOutputInventoryUpdate((TreeFactory)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        this.gui = LazyKt.lazy((Function0)((Function0)new Function0<TreeFactoryGUI>((Object)this){

            @NotNull
            public final TreeFactoryGUI invoke() {
                return (TreeFactory)((Object)this.receiver).new TreeFactoryGUI();
            }
        }));
        objectArray = new UpgradeType[3];
        objectArray[0] = (int)UpgradeType.Companion.getSPEED();
        objectArray[1] = (int)UpgradeType.Companion.getEFFICIENCY();
        objectArray[2] = (int)UpgradeType.Companion.getENERGY();
        this.upgradeHolder = this.getUpgradeHolder((UpgradeType[])objectArray);
        this.energyHolder = new ConsumerEnergyHolder((NetworkedTileEntity)this, TreeFactoryKt.access$getMAX_ENERGY$p(), TreeFactoryKt.access$getENERGY_PER_TICK$p(), null, this.getUpgradeHolder(), (Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ TreeFactory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.BOTTOM, BlockSide.BACK};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        });
        objectArray = new Pair[1];
        objectArray[0] = (int)TuplesKt.to((Object)this.inputInventory, (Object)NetworkConnectionType.BUFFER);
        this.itemHolder = NovaItemHolderKt.NovaItemHolder$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.outputInventory, (Object)NetworkConnectionType.EXTRACT), (Pair[])objectArray, null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ TreeFactory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.BOTTOM, BlockSide.BACK};
                return this.this$0.createExclusiveSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        }), (int)8, null);
        ItemStack itemStack = this.inputInventory.getItemStack(0);
        this.plantType = itemStack != null ? itemStack.getType() : null;
        Location location2 = this.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"location.clone()");
        Location $this$_init__u24lambda_u240 = location = LocationUtilsKt.center((Location)location2);
        boolean bl = false;
        $this$_init__u24lambda_u240.setY($this$_init__u24lambda_u240.getY() + 0.0625);
        Location plantLocation = location;
        this.plant = new FakeArmorStand(plantLocation, true, (Function2)1.INSTANCE);
        this.reload();
    }

    @NotNull
    public Lazy<TileEntity.TileEntityGUI> getGui() {
        return this.gui;
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    @NotNull
    public NovaItemHolder getItemHolder() {
        return this.itemHolder;
    }

    public void reload() {
        super.reload();
        this.progressPerTick = TreeFactoryKt.access$getPROGRESS_PER_TICK() * ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getSPEED())).doubleValue();
        this.maxIdleTime = (int)((double)TreeFactoryKt.access$getIDLE_TIME() / ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getSPEED())).doubleValue());
    }

    /*
     * WARNING - void declaration
     */
    public void handleTick() {
        if (this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getEnergyConsumption() && this.plantType != null) {
            Object v = TreeFactoryKt.access$getPLANTS$p().get(this.plantType);
            Intrinsics.checkNotNull(v);
            ItemStack plantLoot = ((PlantConfiguration)v).getLoot();
            if (!GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && !this.outputInventory.canHold(plantLoot, new ItemStack[0])) {
                return;
            }
            ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
            consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getEnergyConsumption());
            if (this.idleTimeLeft == 0) {
                if (this.plantType != null) {
                    this.growthProgress += this.progressPerTick;
                    if (this.growthProgress >= 1.0) {
                        this.idleTimeLeft = this.maxIdleTime;
                    }
                    this.updatePlantArmorStand();
                }
            } else {
                int n = this.idleTimeLeft;
                this.idleTimeLeft = n + -1;
                ParticlePacketBuilderKt.particleBuilder$default((ParticleEffect)ParticleEffect.REDSTONE, null, (Function1)((Function1)new Function1<ParticlePacketBuilder, Unit>(this){
                    final /* synthetic */ TreeFactory this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ParticlePacketBuilder $this$particleBuilder) {
                        void $this$invoke_u24lambda_u240;
                        Location location;
                        Intrinsics.checkNotNullParameter((Object)$this$particleBuilder, (String)"$this$particleBuilder");
                        V v = TreeFactoryKt.access$getPLANTS$p().get(TreeFactory.access$getPlantType$p(this.this$0));
                        Intrinsics.checkNotNull(v);
                        $this$particleBuilder.color(((PlantConfiguration)v).getColor());
                        Location location2 = this.this$0.getLocation().clone();
                        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"location.clone()");
                        Location location3 = location = LocationUtilsKt.center((Location)location2);
                        ParticlePacketBuilder particlePacketBuilder = $this$particleBuilder;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setY($this$invoke_u24lambda_u240.getY() + 0.5);
                        particlePacketBuilder.location(location);
                        $this$particleBuilder.offset(0.15, 0.15, 0.15);
                        $this$particleBuilder.speed(0.1f);
                        $this$particleBuilder.amount(5);
                    }
                }), (int)2, null).display((Collection)this.getViewers());
                if (this.idleTimeLeft == 0) {
                    this.growthProgress = 0.0;
                    int leftover = this.outputInventory.addItem(TileEntity.Companion.getSELF_UPDATE_REASON(), plantLoot);
                    if (GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && leftover > 0) {
                        void $this$handleTick_u24lambda_u241;
                        ItemStack itemStack;
                        ItemStack itemStack2 = itemStack = plantLoot.clone();
                        Location location = this.getCenterLocation();
                        boolean bl = false;
                        $this$handleTick_u24lambda_u241.setAmount(leftover);
                        ItemStack itemStack3 = itemStack;
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"plantLoot.clone().apply { amount = leftover }");
                        LocationUtilsKt.dropItem((Location)location, (ItemStack)itemStack3);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePlantArmorStand() {
        ItemStack itemStack;
        int growthStage = RangesKt.coerceAtMost((int)((int)((double)199 * this.growthProgress)), (int)199);
        FakeArmorStand fakeArmorStand = this.plant;
        EnumItemSlot enumItemSlot = EnumItemSlot.f;
        Material material = this.plantType;
        if (material != null) {
            void it;
            Material material2 = material;
            EnumItemSlot enumItemSlot2 = enumItemSlot;
            FakeArmorStand fakeArmorStand2 = fakeArmorStand;
            boolean bl = false;
            Object v = TreeFactoryKt.access$getPLANTS$p().get(it);
            Intrinsics.checkNotNull(v);
            ItemStack itemStack2 = ((ItemProvider)((PlantConfiguration)v).getMiniature().getClientsideProviders().get(growthStage)).get();
            fakeArmorStand = fakeArmorStand2;
            enumItemSlot = enumItemSlot2;
            itemStack = itemStack2;
        } else {
            itemStack = null;
        }
        fakeArmorStand.setEquipment(enumItemSlot, itemStack, true);
    }

    private final void handleInputInventoryUpdate(ItemUpdateEvent event) {
        if (event.getNewItemStack() != null && !TreeFactoryKt.access$getPLANTS$p().keySet().contains(event.getNewItemStack().getType())) {
            event.setCancelled(true);
        } else {
            ItemStack itemStack = event.getNewItemStack();
            this.plantType = itemStack != null ? itemStack.getType() : null;
            this.growthProgress = 0.0;
            this.updatePlantArmorStand();
        }
    }

    private final void handleOutputInventoryUpdate(ItemUpdateEvent event) {
        event.setCancelled(!Intrinsics.areEqual((Object)event.getUpdateReason(), (Object)TileEntity.Companion.getSELF_UPDATE_REASON()) && !event.isRemove());
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        this.plant.remove();
    }

    public static final /* synthetic */ Material access$getPlantType$p(TreeFactory $this) {
        return $this.plantType;
    }

    public static final /* synthetic */ void access$handleInputInventoryUpdate(TreeFactory $this, ItemUpdateEvent event) {
        $this.handleInputInventoryUpdate(event);
    }

    public static final /* synthetic */ void access$handleOutputInventoryUpdate(TreeFactory $this, ItemUpdateEvent event) {
        $this.handleOutputInventoryUpdate(event);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/agriculture/TreeFactory$TreeFactoryGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity$TileEntityGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/agriculture/TreeFactory;)V", "gui", "Lde/studiocode/invui/gui/GUI;", "getGui", "()Lde/studiocode/invui/gui/GUI;", "sideConfigGUI", "Lxyz/xenondevs/nova/ui/config/side/SideConfigGUI;", "machines"})
    private final class TreeFactoryGUI
    extends TileEntity.TileEntityGUI {
        @NotNull
        private final SideConfigGUI sideConfigGUI;
        @NotNull
        private final GUI gui;

        public TreeFactoryGUI() {
            super((TileEntity)TreeFactory.this, null, 1, null);
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)TreeFactory.this.getItemHolder().getNetworkedInventory(TreeFactory.this.inputInventory), (Object)"inventory.nova.input"), TuplesKt.to((Object)TreeFactory.this.getItemHolder().getNetworkedInventory(TreeFactory.this.outputInventory), (Object)"inventory.nova.output")};
            this.sideConfigGUI = new SideConfigGUI((NetworkEndPoint)TreeFactory.this, CollectionsKt.listOf((Object[])objectArray), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((TreeFactoryGUI)((Object)this.receiver)).openWindow(p0);
                }
            });
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s u # # # # e |", "| # # # o o o e |", "| # i # o o o e |", "| # # # o o o e |", "3 - - - - - - - 4"};
            GUI gUI = new GUIBuilder(GUIType.NORMAL).setStructure(stringArray).addIngredient('i', (SlotElement)new SlotElement.VISlotElement(TreeFactory.this.inputInventory, 0, GUIMaterials.INSTANCE.getSAPLING_PLACEHOLDER().getClientsideProvider())).addIngredient('o', TreeFactory.this.outputInventory).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGUI)).addIngredient('u', (Item)new OpenUpgradesItem(TreeFactory.this.getUpgradeHolder())).addIngredient('e', (Supplier)new EnergyBar(4, (NovaEnergyHolder)TreeFactory.this.getEnergyHolder())).build();
            Intrinsics.checkNotNullExpressionValue((Object)gUI, (String)"GUIBuilder(GUIType.NORMA\u2026er))\n            .build()");
            this.gui = gUI;
        }

        @NotNull
        public GUI getGui() {
            return this.gui;
        }
    }
}

