/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.machines.tileentity.agriculture;

import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.builder.GUIBuilder;
import de.studiocode.invui.gui.builder.guitype.GUIType;
import de.studiocode.invui.item.Item;
import de.studiocode.invui.item.builder.ItemBuilder;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import de.studiocode.invui.virtualinventory.event.ItemUpdateEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_19_R2.CraftServer;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R2.util.RandomSourceWrapper;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.data.config.GlobalValues;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.machines.registry.GUIMaterials;
import xyz.xenondevs.nova.machines.tileentity.agriculture.AutoFisher;
import xyz.xenondevs.nova.machines.tileentity.agriculture.AutoFisherKt;
import xyz.xenondevs.nova.material.CoreGUIMaterial;
import xyz.xenondevs.nova.material.ItemNovaMaterial;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.energy.holder.ConsumerEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.energy.holder.NovaEnergyHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolder;
import xyz.xenondevs.nova.tileentity.network.item.holder.NovaItemHolderKt;
import xyz.xenondevs.nova.tileentity.upgrade.Upgradable;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeHolder;
import xyz.xenondevs.nova.tileentity.upgrade.UpgradeType;
import xyz.xenondevs.nova.ui.EnergyBar;
import xyz.xenondevs.nova.ui.OpenUpgradesItem;
import xyz.xenondevs.nova.ui.VerticalBar;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigGUI;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.EntityUtils;
import xyz.xenondevs.nova.util.InventoryUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.item.DamageableUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u00012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020*H\u0016J\b\u00100\u001a\u00020*H\u0016J\b\u00101\u001a\u00020*H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/agriculture/AutoFisher;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/tileentity/upgrade/Upgradable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "energyHolder", "Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "getEnergyHolder", "()Lxyz/xenondevs/nova/tileentity/network/energy/holder/ConsumerEnergyHolder;", "fakePlayer", "Lnet/minecraft/server/level/ServerPlayer;", "fishingRodInventory", "Lde/studiocode/invui/virtualinventory/VirtualInventory;", "gui", "Lkotlin/Lazy;", "Lxyz/xenondevs/nova/machines/tileentity/agriculture/AutoFisher$AutoFisherGUI;", "getGui", "()Lkotlin/Lazy;", "inventory", "itemDropLocation", "Lorg/bukkit/Location;", "itemHolder", "Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "getItemHolder", "()Lxyz/xenondevs/nova/tileentity/network/item/holder/NovaItemHolder;", "level", "Lnet/minecraft/server/level/ServerLevel;", "maxIdleTime", "", "position", "Lnet/minecraft/world/phys/Vec3;", "random", "Lorg/bukkit/craftbukkit/v1_19_R2/util/RandomSourceWrapper;", "timePassed", "upgradeHolder", "Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "getUpgradeHolder", "()Lxyz/xenondevs/nova/tileentity/upgrade/UpgradeHolder;", "waterBlock", "Lorg/bukkit/block/Block;", "fish", "", "handleFishingRodInventoryUpdate", "event", "Lde/studiocode/invui/virtualinventory/event/ItemUpdateEvent;", "handleInventoryUpdate", "handleTick", "reload", "useRod", "AutoFisherGUI", "machines"})
public final class AutoFisher
extends NetworkedTileEntity
implements Upgradable {
    @NotNull
    private final VirtualInventory inventory;
    @NotNull
    private final VirtualInventory fishingRodInventory;
    @NotNull
    private final Lazy<AutoFisherGUI> gui;
    @NotNull
    private final UpgradeHolder upgradeHolder;
    @NotNull
    private final ConsumerEnergyHolder energyHolder;
    @NotNull
    private final NovaItemHolder itemHolder;
    private int timePassed;
    private int maxIdleTime;
    @NotNull
    private final Block waterBlock;
    @NotNull
    private final RandomSourceWrapper random;
    @NotNull
    private final WorldServer level;
    @NotNull
    private final Vec3D position;
    @NotNull
    private final Location itemDropLocation;
    @NotNull
    private final EntityPlayer fakePlayer;

    public AutoFisher(@NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        this.inventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"inventory", (int)12, (Function1)((Function1)new Function1<ItemUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AutoFisher.access$handleInventoryUpdate((AutoFisher)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        this.fishingRodInventory = TileEntity.getInventory$default((TileEntity)((TileEntity)this), (String)"fishingRod", (int)1, (Function1)((Function1)new Function1<ItemUpdateEvent, Unit>((Object)this){

            public final void invoke(@NotNull ItemUpdateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AutoFisher.access$handleFishingRodInventoryUpdate((AutoFisher)((Object)this.receiver), p0);
            }
        }), null, (int)8, null);
        this.gui = LazyKt.lazy((Function0)((Function0)new Function0<AutoFisherGUI>((Object)this){

            @NotNull
            public final AutoFisherGUI invoke() {
                return (AutoFisher)((Object)this.receiver).new AutoFisherGUI();
            }
        }));
        UpgradeType[] upgradeTypeArray = new UpgradeType[]{UpgradeType.Companion.getSPEED(), UpgradeType.Companion.getEFFICIENCY(), UpgradeType.Companion.getENERGY()};
        this.upgradeHolder = this.getUpgradeHolder(upgradeTypeArray);
        this.energyHolder = new ConsumerEnergyHolder((NetworkedTileEntity)this, AutoFisherKt.access$getMAX_ENERGY$p(), AutoFisherKt.access$getENERGY_PER_TICK$p(), null, this.getUpgradeHolder(), (Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ AutoFisher this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.BOTTOM};
                return this.this$0.createSideConfig(NetworkConnectionType.INSERT, blockSideArray);
            }
        });
        upgradeTypeArray = new Pair[]{TuplesKt.to((Object)this.fishingRodInventory, (Object)NetworkConnectionType.BUFFER)};
        this.itemHolder = NovaItemHolderKt.NovaItemHolder$default((NetworkedTileEntity)this, (Pair)TuplesKt.to((Object)this.inventory, (Object)NetworkConnectionType.EXTRACT), (Pair[])upgradeTypeArray, null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ AutoFisher this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                BlockSide[] blockSideArray = new BlockSide[]{BlockSide.BOTTOM};
                return this.this$0.createSideConfig(NetworkConnectionType.EXTRACT, blockSideArray);
            }
        }), (int)8, null);
        Block block = this.getLocation().clone().subtract(0.0, 1.0, 0.0).getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"location.clone().subtract(0.0, 1.0, 0.0).block");
        this.waterBlock = block;
        this.random = new RandomSourceWrapper(new Random(this.getUuid().getMostSignificantBits() ^ System.currentTimeMillis()));
        this.level = NMSUtilsKt.getServerLevel((org.bukkit.World)this.getWorld());
        this.position = new Vec3D(this.getCenterLocation().getX(), this.getLocation().getY() - 0.5, this.getCenterLocation().getZ());
        Location location = this.getLocation().clone().add(0.0, 1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location.clone().add(0.0, 1.0, 0.0)");
        this.itemDropLocation = location;
        Location location2 = this.getLocation();
        UUID uUID = this.getOwnerUUID();
        if (uUID == null) {
            uUID = UUID.randomUUID();
        }
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"ownerUUID ?: UUID.randomUUID()");
        this.fakePlayer = EntityUtils.INSTANCE.createFakePlayer(location2, uUID, "AutoFisher");
        this.reload();
    }

    @NotNull
    public Lazy<AutoFisherGUI> getGui() {
        return this.gui;
    }

    @NotNull
    public UpgradeHolder getUpgradeHolder() {
        return this.upgradeHolder;
    }

    @NotNull
    public ConsumerEnergyHolder getEnergyHolder() {
        return this.energyHolder;
    }

    @NotNull
    public NovaItemHolder getItemHolder() {
        return this.itemHolder;
    }

    public void reload() {
        super.reload();
        this.maxIdleTime = (int)((double)AutoFisherKt.access$getIDLE_TIME() / ((Number)this.getUpgradeHolder().getValue(UpgradeType.Companion.getSPEED())).doubleValue());
        if (this.timePassed > this.maxIdleTime) {
            this.timePassed = this.maxIdleTime;
        }
    }

    public void handleTick() {
        if (this.getEnergyHolder().getEnergy() >= this.getEnergyHolder().getEnergyConsumption() && !this.fishingRodInventory.isEmpty() && this.waterBlock.getType() == Material.WATER) {
            if (!GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && !InventoryUtilsKt.hasEmptySlot((VirtualInventory)this.inventory)) {
                return;
            }
            ConsumerEnergyHolder consumerEnergyHolder = this.getEnergyHolder();
            consumerEnergyHolder.setEnergy(consumerEnergyHolder.getEnergy() - this.getEnergyHolder().getEnergyConsumption());
            int n = this.timePassed;
            this.timePassed = n + 1;
            if (this.timePassed >= this.maxIdleTime) {
                this.timePassed = 0;
                this.fish();
            }
            if (this.getGui().isInitialized()) {
                ((AutoFisherGUI)((Object)this.getGui().getValue())).getIdleBar().setPercentage((double)this.timePassed / (double)this.maxIdleTime);
            }
        }
    }

    private final void fish() {
        ItemStack rodItem = this.fishingRodInventory.getItemStack(0);
        Integer n = (Integer)rodItem.getEnchantments().get(Enchantment.LUCK);
        int luck = n != null ? n : 0;
        EntityFishingHook fakeFishingHook = new EntityFishingHook((EntityHuman)this.fakePlayer, (World)this.level, luck, 0);
        LootTableInfo.Builder contextBuilder = new LootTableInfo.Builder(this.level).a(LootContextParameters.f, (Object)this.position).a(LootContextParameters.i, (Object)CraftItemStack.asNMSCopy((ItemStack)rodItem)).a(LootContextParameters.a, (Object)fakeFishingHook).a((RandomSource)this.random).a((float)luck);
        Server server = Bukkit.getServer();
        Intrinsics.checkNotNull((Object)server, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.v1_19_R2.CraftServer");
        DedicatedServer server2 = ((CraftServer)server).getServer();
        LootTable lootTable = server2.aG().a(LootTables.ai);
        Intrinsics.checkNotNullExpressionValue((Object)lootTable, (String)"server.lootTables.get(BuiltInLootTables.FISHING)");
        LootTable lootTable2 = lootTable;
        ObjectArrayList list = lootTable2.a(contextBuilder.a(LootContextParameterSets.e));
        list.stream().map(arg_0 -> AutoFisher.fish$lambda$0(fish.1.INSTANCE, arg_0)).forEach(arg_0 -> AutoFisher.fish$lambda$1((Function1)new Function1<CraftItemStack, Unit>(this){
            final /* synthetic */ AutoFisher this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(CraftItemStack it) {
                int leftover = AutoFisher.access$getInventory$p(this.this$0).addItem(TileEntity.Companion.getSELF_UPDATE_REASON(), (ItemStack)it);
                if (GlobalValues.INSTANCE.getDROP_EXCESS_ON_GROUND() && leftover != 0) {
                    it.setAmount(leftover);
                    this.this$0.getWorld().dropItemNaturally(AutoFisher.access$getItemDropLocation$p(this.this$0), (ItemStack)it);
                }
            }
        }, arg_0));
        this.useRod();
    }

    private final void useRod() {
        ItemStack itemStack = this.fishingRodInventory.getItemStack(0);
        Intrinsics.checkNotNull((Object)itemStack);
        ItemStack itemStack2 = itemStack;
        this.fishingRodInventory.setItemStack(TileEntity.Companion.getSELF_UPDATE_REASON(), 0, DamageableUtils.damageItem$default((DamageableUtils)DamageableUtils.INSTANCE, (ItemStack)itemStack2, (int)0, (int)2, null));
    }

    private final void handleInventoryUpdate(ItemUpdateEvent event) {
        event.setCancelled(!Intrinsics.areEqual((Object)event.getUpdateReason(), (Object)TileEntity.Companion.getSELF_UPDATE_REASON()) && event.isAdd());
    }

    private final void handleFishingRodInventoryUpdate(ItemUpdateEvent event) {
        event.setCancelled(event.isAdd() && event.getNewItemStack().getType() != Material.FISHING_ROD);
    }

    private static final CraftItemStack fish$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CraftItemStack)$tmp0.invoke(p0);
    }

    private static final void fish$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Location access$getItemDropLocation$p(AutoFisher $this) {
        return $this.itemDropLocation;
    }

    public static final /* synthetic */ int access$getMaxIdleTime$p(AutoFisher $this) {
        return $this.maxIdleTime;
    }

    public static final /* synthetic */ int access$getTimePassed$p(AutoFisher $this) {
        return $this.timePassed;
    }

    public static final /* synthetic */ void access$handleInventoryUpdate(AutoFisher $this, ItemUpdateEvent event) {
        $this.handleInventoryUpdate(event);
    }

    public static final /* synthetic */ void access$handleFishingRodInventoryUpdate(AutoFisher $this, ItemUpdateEvent event) {
        $this.handleFishingRodInventoryUpdate(event);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lxyz/xenondevs/nova/machines/tileentity/agriculture/AutoFisher$AutoFisherGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity$TileEntityGUI;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/machines/tileentity/agriculture/AutoFisher;)V", "gui", "Lde/studiocode/invui/gui/GUI;", "getGui", "()Lde/studiocode/invui/gui/GUI;", "idleBar", "Lxyz/xenondevs/nova/ui/VerticalBar;", "getIdleBar", "()Lxyz/xenondevs/nova/ui/VerticalBar;", "sideConfigGUI", "Lxyz/xenondevs/nova/ui/config/side/SideConfigGUI;", "machines"})
    public final class AutoFisherGUI
    extends TileEntity.TileEntityGUI {
        @NotNull
        private final SideConfigGUI sideConfigGUI;
        @NotNull
        private final VerticalBar idleBar;
        @NotNull
        private final GUI gui;

        public AutoFisherGUI() {
            super((TileEntity)AutoFisher.this, null, 1, null);
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)AutoFisher.this.getItemHolder().getNetworkedInventory(AutoFisher.this.inventory), (Object)"inventory.nova.default"), TuplesKt.to((Object)AutoFisher.this.getItemHolder().getNetworkedInventory(AutoFisher.this.fishingRodInventory), (Object)"inventory.machines.fishing_rod")};
            this.sideConfigGUI = new SideConfigGUI((NetworkEndPoint)AutoFisher.this, CollectionsKt.listOf((Object[])objectArray), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((AutoFisherGUI)((Object)this.receiver)).openWindow(p0);
                }
            });
            this.idleBar = new VerticalBar(AutoFisher.this){
                @NotNull
                private final ItemNovaMaterial barMaterial;
                final /* synthetic */ AutoFisher this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                    this.barMaterial = CoreGUIMaterial.INSTANCE.getBAR_GREEN();
                }

                @NotNull
                public ItemNovaMaterial getBarMaterial() {
                    return this.barMaterial;
                }

                protected ItemBuilder modifyItemBuilder(@NotNull ItemBuilder itemBuilder) {
                    Intrinsics.checkNotNullParameter((Object)itemBuilder, (String)"itemBuilder");
                    BaseComponent[] baseComponentArray = new BaseComponent[1];
                    Object[] objectArray = new Object[]{AutoFisher.access$getMaxIdleTime$p(this.this$0) - AutoFisher.access$getTimePassed$p(this.this$0)};
                    baseComponentArray[0] = (BaseComponent)new TranslatableComponent("menu.machines.auto_fisher.idle", objectArray);
                    return (ItemBuilder)itemBuilder.setDisplayName(baseComponentArray);
                }
            };
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s u # # f p e |", "| i i i i # p e |", "| i i i i # p e |", "3 - - - - - - - 4"};
            GUI gUI = new GUIBuilder(GUIType.NORMAL).setStructure(stringArray).addIngredient('i', AutoFisher.this.inventory).addIngredient('s', (Item)new OpenSideConfigItem(this.sideConfigGUI)).addIngredient('f', (SlotElement)new SlotElement.VISlotElement(AutoFisher.this.fishingRodInventory, 0, GUIMaterials.INSTANCE.getFISHING_ROD_PLACEHOLDER().getClientsideProvider())).addIngredient('u', (Item)new OpenUpgradesItem(AutoFisher.this.getUpgradeHolder())).addIngredient('e', (Supplier)new EnergyBar(3, (NovaEnergyHolder)AutoFisher.this.getEnergyHolder())).addIngredient('p', (Supplier)this.idleBar).build();
            Intrinsics.checkNotNullExpressionValue((Object)gUI, (String)"GUIBuilder(GUIType.NORMA\u2026Bar)\n            .build()");
            this.gui = gUI;
        }

        @NotNull
        public final VerticalBar getIdleBar() {
            return this.idleBar;
        }

        @NotNull
        public GUI getGui() {
            return this.gui;
        }
    }
}

