/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.logistics.tileentity;

import java.util.EnumMap;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.util.Brightness;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.logistics.registry.Items;
import xyz.xenondevs.nova.logistics.tileentity.FluidTank;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.fluid.FluidType;
import xyz.xenondevs.nova.tileentity.network.fluid.container.FluidContainer;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.FluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolderKt;
import xyz.xenondevs.nova.ui.FluidBar;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigMenu;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeItemDisplay;
import xyz.xenondevs.nova.world.fakeentity.metadata.impl.ItemDisplayMetadata;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lxyz/xenondevs/nova/logistics/tileentity/FluidTank;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "capacity", "Lxyz/xenondevs/commons/provider/Provider;", "", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/commons/provider/Provider;Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "fluidContainer", "Lxyz/xenondevs/nova/tileentity/network/fluid/container/FluidContainer;", "getFluidContainer", "()Lxyz/xenondevs/nova/tileentity/network/fluid/container/FluidContainer;", "fluidHolder", "Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "getFluidHolder", "()Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "fluidLevel", "Lxyz/xenondevs/nova/world/fakeentity/impl/FakeItemDisplay;", "handleFluidUpdate", "", "handleInitialized", "first", "", "handleRemoved", "unload", "reload", "updateFluidLevel", "FluidTankMenu", "logistics"})
public class FluidTank
extends NetworkedTileEntity {
    @NotNull
    private final FluidContainer fluidContainer;
    @NotNull
    private final NovaFluidHolder fluidHolder;
    private FakeItemDisplay fluidLevel;

    public FluidTank(@NotNull Provider<Long> capacity, @NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter(capacity, (String)"capacity");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        Object[] objectArray = new FluidType[]{FluidType.WATER, FluidType.LAVA};
        this.fluidContainer = TileEntity.getFluidContainer$default((TileEntity)((TileEntity)this), (String)"tank", (Set)SetsKt.hashSetOf((Object[])objectArray), capacity, (long)0L, (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                FluidTank.access$handleFluidUpdate((FluidTank)((Object)this.receiver));
            }
        }), (boolean)false, (int)32, null);
        this.fluidHolder = NovaFluidHolderKt.NovaFluidHolder$default((DataHolder)((DataHolder)this), (Pair)TuplesKt.to((Object)this.fluidContainer, (Object)NetworkConnectionType.BUFFER), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ FluidTank this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                return this.this$0.createSideConfig(NetworkConnectionType.BUFFER, new BlockSide[0]);
            }
        }), (int)8, null);
    }

    @NotNull
    public final FluidContainer getFluidContainer() {
        return this.fluidContainer;
    }

    @NotNull
    public NovaFluidHolder getFluidHolder() {
        return this.fluidHolder;
    }

    public void handleInitialized(boolean first) {
        super.handleInitialized(first);
        Location location = this.getLocation().add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location.add(.5, .5, .5)");
        this.fluidLevel = new FakeItemDisplay(location, false, (Function2)handleInitialized.1.INSTANCE, 2, null);
        this.updateFluidLevel();
    }

    private final void handleFluidUpdate() {
        if (this.fluidContainer.getCapacity() == Long.MAX_VALUE && this.fluidContainer.hasFluid() && !this.fluidContainer.isFull()) {
            FluidType fluidType = this.fluidContainer.getType();
            Intrinsics.checkNotNull((Object)fluidType);
            this.fluidContainer.addFluid(fluidType, this.fluidContainer.getCapacity() - this.fluidContainer.getAmount());
        }
        this.updateFluidLevel();
    }

    public void reload() {
        super.reload();
        this.updateFluidLevel();
    }

    private final void updateFluidLevel() {
        FakeItemDisplay fakeItemDisplay;
        ItemStack stack;
        if (this.fluidContainer.hasFluid()) {
            int state = MathKt.roundToInt((double)((double)this.fluidContainer.getAmount() / (double)this.fluidContainer.getCapacity() * 99.0));
            FluidType fluidType = this.fluidContainer.getType();
            v2 = ((ItemProvider)(switch (fluidType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[fluidType.ordinal()]) {
                case 1 -> Items.INSTANCE.getTANK_LAVA_LEVELS();
                case 2 -> Items.INSTANCE.getTANK_WATER_LEVELS();
                default -> throw new IllegalStateException();
            }).getClientsideProviders().get(state)).get();
        } else {
            v2 = stack = null;
        }
        if ((fakeItemDisplay = this.fluidLevel) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fluidLevel");
            fakeItemDisplay = null;
        }
        fakeItemDisplay.updateEntityData(true, (Function1)new Function1<ItemDisplayMetadata, Unit>(this, stack){
            final /* synthetic */ FluidTank this$0;
            final /* synthetic */ ItemStack $stack;
            {
                this.this$0 = $receiver;
                this.$stack = $stack;
                super(1);
            }

            public final void invoke(@NotNull ItemDisplayMetadata $this$updateEntityData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateEntityData, (String)"$this$updateEntityData");
                $this$updateEntityData.setBrightness((Brightness)(this.this$0.getFluidContainer().getType() == FluidType.LAVA ? Brightness.c : null));
                $this$updateEntityData.setItemStack(NMSUtilsKt.getNmsCopy((ItemStack)this.$stack));
            }
        });
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        FakeItemDisplay fakeItemDisplay = this.fluidLevel;
        if (fakeItemDisplay == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fluidLevel");
            fakeItemDisplay = null;
        }
        fakeItemDisplay.remove();
    }

    public static final /* synthetic */ void access$handleFluidUpdate(FluidTank $this) {
        $this.handleFluidUpdate();
    }

    @TileEntityMenuClass
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lxyz/xenondevs/nova/logistics/tileentity/FluidTank$FluidTankMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity$GlobalTileEntityMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/logistics/tileentity/FluidTank;)V", "SideConfigMenu", "Lxyz/xenondevs/nova/ui/config/side/SideConfigMenu;", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "Lorg/jetbrains/annotations/NotNull;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "logistics"})
    public final class FluidTankMenu
    extends TileEntity.GlobalTileEntityMenu {
        @NotNull
        private final SideConfigMenu SideConfigMenu;
        @NotNull
        private final Gui gui;

        public FluidTankMenu() {
            super((TileEntity)FluidTank.this, null, 1, null);
            this.SideConfigMenu = new SideConfigMenu((NetworkEndPoint)FluidTank.this, null, CollectionsKt.listOf((Object)TuplesKt.to((Object)FluidTank.this.getFluidContainer(), (Object)"container.nova.fluid_tank")), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((FluidTankMenu)((Object)this.receiver)).openWindow(p0);
                }
            }, 2, null);
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s # # f # # # |", "| # # # f # # # |", "| # # # f # # # |", "3 - - - - - - - 4"};
            Gui gui = ((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)Gui.normal().setStructure(stringArray)).addIngredient('s', (Item)new OpenSideConfigItem(this.SideConfigMenu))).addIngredient('f', (Supplier)new FluidBar(3, (FluidHolder)FluidTank.this.getFluidHolder(), FluidTank.this.getFluidContainer()))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"normal()\n            .se\u2026er))\n            .build()");
            this.gui = gui;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FluidType.values().length];
            try {
                nArray[FluidType.LAVA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FluidType.WATER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

